/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.google.gson.JsonPrimitive;
import com.launchdarkly.client.Util;
import com.launchdarkly.shaded.org.joda.time.DateTime;
import java.util.regex.Pattern;

enum Operator {
    in{

        @Override
        public boolean apply(JsonPrimitive uValue, JsonPrimitive cValue) {
            if (uValue.equals((Object)cValue)) {
                return true;
            }
            if (uValue.isString() && cValue.isString() && uValue.getAsString().equals(cValue.getAsString())) {
                return true;
            }
            if (uValue.isNumber() && cValue.isNumber()) {
                return uValue.getAsDouble() == cValue.getAsDouble();
            }
            return false;
        }
    }
    ,
    endsWith{

        @Override
        public boolean apply(JsonPrimitive uValue, JsonPrimitive cValue) {
            return uValue.isString() && cValue.isString() && uValue.getAsString().endsWith(cValue.getAsString());
        }
    }
    ,
    startsWith{

        @Override
        public boolean apply(JsonPrimitive uValue, JsonPrimitive cValue) {
            return uValue.isString() && cValue.isString() && uValue.getAsString().startsWith(cValue.getAsString());
        }
    }
    ,
    matches{

        @Override
        public boolean apply(JsonPrimitive uValue, JsonPrimitive cValue) {
            return uValue.isString() && cValue.isString() && Pattern.compile(cValue.getAsString()).matcher(uValue.getAsString()).find();
        }
    }
    ,
    contains{

        @Override
        public boolean apply(JsonPrimitive uValue, JsonPrimitive cValue) {
            return uValue.isString() && cValue.isString() && uValue.getAsString().contains(cValue.getAsString());
        }
    }
    ,
    lessThan{

        @Override
        public boolean apply(JsonPrimitive uValue, JsonPrimitive cValue) {
            return uValue.isNumber() && cValue.isNumber() && uValue.getAsDouble() < cValue.getAsDouble();
        }
    }
    ,
    lessThanOrEqual{

        @Override
        public boolean apply(JsonPrimitive uValue, JsonPrimitive cValue) {
            return uValue.isNumber() && cValue.isNumber() && uValue.getAsDouble() <= cValue.getAsDouble();
        }
    }
    ,
    greaterThan{

        @Override
        public boolean apply(JsonPrimitive uValue, JsonPrimitive cValue) {
            return uValue.isNumber() && cValue.isNumber() && uValue.getAsDouble() > cValue.getAsDouble();
        }
    }
    ,
    greaterThanOrEqual{

        @Override
        public boolean apply(JsonPrimitive uValue, JsonPrimitive cValue) {
            return uValue.isNumber() && cValue.isNumber() && uValue.getAsDouble() >= cValue.getAsDouble();
        }
    }
    ,
    before{

        @Override
        public boolean apply(JsonPrimitive uValue, JsonPrimitive cValue) {
            DateTime cDateTime;
            DateTime uDateTime = Util.jsonPrimitiveToDateTime(uValue);
            if (uDateTime != null && (cDateTime = Util.jsonPrimitiveToDateTime(cValue)) != null) {
                return uDateTime.isBefore(cDateTime);
            }
            return false;
        }
    }
    ,
    after{

        @Override
        public boolean apply(JsonPrimitive uValue, JsonPrimitive cValue) {
            DateTime cDateTime;
            DateTime uDateTime = Util.jsonPrimitiveToDateTime(uValue);
            if (uDateTime != null && (cDateTime = Util.jsonPrimitiveToDateTime(cValue)) != null) {
                return uDateTime.isAfter(cDateTime);
            }
            return false;
        }
    };


    abstract boolean apply(JsonPrimitive var1, JsonPrimitive var2);
}

