/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.google.gson.Gson;
import com.launchdarkly.client.FeatureStore;
import com.launchdarkly.client.InMemoryFeatureStore;
import com.launchdarkly.client.LDClient;
import com.launchdarkly.shaded.com.google.common.io.Files;
import com.launchdarkly.shaded.okhttp3.Authenticator;
import com.launchdarkly.shaded.okhttp3.Cache;
import com.launchdarkly.shaded.okhttp3.ConnectionPool;
import com.launchdarkly.shaded.okhttp3.Credentials;
import com.launchdarkly.shaded.okhttp3.OkHttpClient;
import com.launchdarkly.shaded.okhttp3.Request;
import com.launchdarkly.shaded.okhttp3.Response;
import com.launchdarkly.shaded.okhttp3.Route;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LDConfig {
    private static final Logger logger = LoggerFactory.getLogger(LDConfig.class);
    static final Gson gson = new Gson();
    private static final URI DEFAULT_BASE_URI = URI.create("https://app.launchdarkly.com");
    private static final URI DEFAULT_EVENTS_URI = URI.create("https://events.launchdarkly.com");
    private static final URI DEFAULT_STREAM_URI = URI.create("https://stream.launchdarkly.com");
    private static final int DEFAULT_CAPACITY = 10000;
    private static final int DEFAULT_CONNECT_TIMEOUT_MILLIS = 2000;
    private static final int DEFAULT_SOCKET_TIMEOUT_MILLIS = 10000;
    private static final int DEFAULT_FLUSH_INTERVAL_SECONDS = 5;
    private static final long MIN_POLLING_INTERVAL_MILLIS = 30000L;
    private static final long DEFAULT_START_WAIT_MILLIS = 5000L;
    private static final int DEFAULT_SAMPLING_INTERVAL = 0;
    private static final long DEFAULT_RECONNECT_TIME_MILLIS = 1000L;
    private static final long MAX_HTTP_CACHE_SIZE_BYTES = 0xA00000L;
    protected static final LDConfig DEFAULT = new Builder().build();
    final URI baseURI;
    final URI eventsURI;
    final URI streamURI;
    final int capacity;
    final int connectTimeoutMillis;
    final int socketTimeoutMillis;
    final int flushInterval;
    final Proxy proxy;
    final Authenticator proxyAuthenticator;
    final OkHttpClient httpClient;
    final boolean stream;
    final FeatureStore featureStore;
    final boolean useLdd;
    final boolean offline;
    final boolean sendEvents;
    final long pollingIntervalMillis;
    final long startWaitMillis;
    final int samplingInterval;
    final long reconnectTimeMs;

    protected LDConfig(Builder builder) {
        this.baseURI = builder.baseURI;
        this.eventsURI = builder.eventsURI;
        this.capacity = builder.capacity;
        this.connectTimeoutMillis = builder.connectTimeoutMillis;
        this.socketTimeoutMillis = builder.socketTimeoutMillis;
        this.flushInterval = builder.flushIntervalSeconds;
        this.proxy = builder.proxy();
        this.proxyAuthenticator = builder.proxyAuthenticator();
        this.streamURI = builder.streamURI;
        this.stream = builder.stream;
        this.featureStore = builder.featureStore;
        this.useLdd = builder.useLdd;
        this.offline = builder.offline;
        this.sendEvents = builder.sendEvents;
        this.pollingIntervalMillis = builder.pollingIntervalMillis < 30000L ? 30000L : builder.pollingIntervalMillis;
        this.startWaitMillis = builder.startWaitMillis;
        this.samplingInterval = builder.samplingInterval;
        this.reconnectTimeMs = builder.reconnectTimeMillis;
        OkHttpClient.Builder httpClientBuilder = new OkHttpClient.Builder().connectionPool(new ConnectionPool(5, 5L, TimeUnit.SECONDS)).connectTimeout(this.connectTimeoutMillis, TimeUnit.MILLISECONDS).readTimeout(this.socketTimeoutMillis, TimeUnit.MILLISECONDS).writeTimeout(this.socketTimeoutMillis, TimeUnit.MILLISECONDS).retryOnConnectionFailure(true);
        if (!this.stream) {
            File cacheDir = Files.createTempDir();
            Cache cache = new Cache(cacheDir, 0xA00000L);
            httpClientBuilder.cache(cache);
        }
        if (this.proxy != null) {
            httpClientBuilder.proxy(this.proxy);
            if (this.proxyAuthenticator != null) {
                httpClientBuilder.proxyAuthenticator(this.proxyAuthenticator);
                logger.info("Using proxy: " + this.proxy + " with authentication.");
            } else {
                logger.info("Using proxy: " + this.proxy + " without authentication.");
            }
        }
        this.httpClient = httpClientBuilder.build();
    }

    Request.Builder getRequestBuilder(String sdkKey) {
        return new Request.Builder().addHeader("Authorization", sdkKey).addHeader("User-Agent", "JavaClient/" + LDClient.CLIENT_VERSION);
    }

    static /* synthetic */ URI access$1600() {
        return DEFAULT_BASE_URI;
    }

    static /* synthetic */ URI access$1700() {
        return DEFAULT_EVENTS_URI;
    }

    static /* synthetic */ URI access$1800() {
        return DEFAULT_STREAM_URI;
    }

    public static class Builder {
        private URI baseURI = LDConfig.access$1600();
        private URI eventsURI = LDConfig.access$1700();
        private URI streamURI = LDConfig.access$1800();
        private int connectTimeoutMillis = 2000;
        private int socketTimeoutMillis = 10000;
        private int capacity = 10000;
        private int flushIntervalSeconds = 5;
        private String proxyHost = "localhost";
        private int proxyPort = -1;
        private String proxyUsername = null;
        private String proxyPassword = null;
        private boolean stream = true;
        private boolean useLdd = false;
        private boolean offline = false;
        private boolean sendEvents = true;
        private long pollingIntervalMillis = 30000L;
        private FeatureStore featureStore = new InMemoryFeatureStore();
        private long startWaitMillis = 5000L;
        private int samplingInterval = 0;
        private long reconnectTimeMillis = 1000L;

        public Builder baseURI(URI baseURI) {
            this.baseURI = baseURI;
            return this;
        }

        public Builder eventsURI(URI eventsURI) {
            this.eventsURI = eventsURI;
            return this;
        }

        public Builder streamURI(URI streamURI) {
            this.streamURI = streamURI;
            return this;
        }

        public Builder featureStore(FeatureStore store) {
            this.featureStore = store;
            return this;
        }

        public Builder stream(boolean stream) {
            this.stream = stream;
            return this;
        }

        public Builder connectTimeout(int connectTimeout) {
            this.connectTimeoutMillis = connectTimeout * 1000;
            return this;
        }

        public Builder socketTimeout(int socketTimeout) {
            this.socketTimeoutMillis = socketTimeout * 1000;
            return this;
        }

        public Builder connectTimeoutMillis(int connectTimeoutMillis) {
            this.connectTimeoutMillis = connectTimeoutMillis;
            return this;
        }

        public Builder socketTimeoutMillis(int socketTimeoutMillis) {
            this.socketTimeoutMillis = socketTimeoutMillis;
            return this;
        }

        public Builder flushInterval(int flushInterval) {
            this.flushIntervalSeconds = flushInterval;
            return this;
        }

        public Builder capacity(int capacity) {
            this.capacity = capacity;
            return this;
        }

        public Builder proxyHost(String host) {
            this.proxyHost = host;
            return this;
        }

        public Builder proxyPort(int port) {
            this.proxyPort = port;
            return this;
        }

        public Builder proxyUsername(String username) {
            this.proxyUsername = username;
            return this;
        }

        public Builder proxyPassword(String password) {
            this.proxyPassword = password;
            return this;
        }

        @Deprecated
        public Builder proxyScheme(String unused) {
            return this;
        }

        public Builder useLdd(boolean useLdd) {
            this.useLdd = useLdd;
            return this;
        }

        public Builder offline(boolean offline) {
            this.offline = offline;
            return this;
        }

        public Builder sendEvents(boolean sendEvents) {
            this.sendEvents = sendEvents;
            return this;
        }

        public Builder pollingIntervalMillis(long pollingIntervalMillis) {
            this.pollingIntervalMillis = pollingIntervalMillis;
            return this;
        }

        public Builder startWaitMillis(long startWaitMillis) {
            this.startWaitMillis = startWaitMillis;
            return this;
        }

        public Builder samplingInterval(int samplingInterval) {
            this.samplingInterval = samplingInterval;
            return this;
        }

        public Builder reconnectTimeMs(long reconnectTimeMs) {
            this.reconnectTimeMillis = reconnectTimeMs;
            return this;
        }

        Proxy proxy() {
            if (this.proxyPort == -1) {
                return null;
            }
            return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.proxyHost, this.proxyPort));
        }

        Authenticator proxyAuthenticator() {
            if (this.proxyUsername != null && this.proxyPassword != null) {
                final String credential = Credentials.basic(this.proxyUsername, this.proxyPassword);
                return new Authenticator(){

                    @Override
                    public Request authenticate(Route route, Response response) throws IOException {
                        if (response.request().header("Proxy-Authorization") != null) {
                            return null;
                        }
                        return response.request().newBuilder().header("Proxy-Authorization", credential).build();
                    }
                };
            }
            return null;
        }

        public LDConfig build() {
            return new LDConfig(this);
        }
    }
}

