/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.launchdarkly.client.FeatureFlag;
import com.launchdarkly.client.FeatureFlagBuilder;
import com.launchdarkly.client.InMemoryFeatureStore;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class TestFeatureStore
extends InMemoryFeatureStore {
    private static List<JsonElement> TRUE_FALSE_VARIATIONS = Arrays.asList(new JsonPrimitive(Boolean.valueOf(true)), new JsonPrimitive(Boolean.valueOf(false)));
    private AtomicInteger version = new AtomicInteger(0);
    private volatile boolean initializedForTests = false;

    public void setBooleanValue(String key, Boolean value) {
        FeatureFlag newFeature = new FeatureFlagBuilder(key).on(false).offVariation(value != false ? 0 : 1).variations(TRUE_FALSE_VARIATIONS).version(this.version.incrementAndGet()).build();
        this.upsert(key, newFeature);
    }

    public void setFeatureTrue(String key) {
        this.setBooleanValue(key, true);
    }

    @Deprecated
    public void turnFeatureOn(String key) {
        this.setFeatureTrue(key);
    }

    public void setFeatureFalse(String key) {
        this.setBooleanValue(key, false);
    }

    @Deprecated
    public void turnFeatureOff(String key) {
        this.setFeatureFalse(key);
    }

    public void setIntegerValue(String key, Integer value) {
        this.setJsonValue(key, (JsonElement)new JsonPrimitive((Number)value));
    }

    public void setDoubleValue(String key, Double value) {
        this.setJsonValue(key, (JsonElement)new JsonPrimitive((Number)value));
    }

    public void setStringValue(String key, String value) {
        this.setJsonValue(key, (JsonElement)new JsonPrimitive(value));
    }

    public void setJsonValue(String key, JsonElement value) {
        FeatureFlag newFeature = new FeatureFlagBuilder(key).on(false).offVariation(0).variations(Arrays.asList(value)).version(this.version.incrementAndGet()).build();
        this.upsert(key, newFeature);
    }

    @Override
    public void init(Map<String, FeatureFlag> features) {
        super.init(features);
        this.initializedForTests = true;
    }

    @Override
    public boolean initialized() {
        return this.initializedForTests;
    }

    public void setInitialized(boolean value) {
        this.initializedForTests = value;
    }
}

