/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.google.gson.Gson;
import com.launchdarkly.client.FeatureStore;
import com.launchdarkly.client.RedisFeatureStoreBuilder;
import com.launchdarkly.client.VersionedData;
import com.launchdarkly.client.VersionedDataKind;
import com.launchdarkly.shaded.com.google.common.base.Optional;
import com.launchdarkly.shaded.com.google.common.cache.CacheBuilder;
import com.launchdarkly.shaded.com.google.common.cache.CacheLoader;
import com.launchdarkly.shaded.com.google.common.cache.CacheStats;
import com.launchdarkly.shaded.com.google.common.cache.LoadingCache;
import com.launchdarkly.shaded.com.google.common.util.concurrent.ListeningExecutorService;
import com.launchdarkly.shaded.com.google.common.util.concurrent.MoreExecutors;
import com.launchdarkly.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.launchdarkly.shaded.org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import com.launchdarkly.shaded.redis.clients.jedis.BinaryJedis;
import com.launchdarkly.shaded.redis.clients.jedis.Jedis;
import com.launchdarkly.shaded.redis.clients.jedis.JedisPool;
import com.launchdarkly.shaded.redis.clients.jedis.JedisPoolConfig;
import com.launchdarkly.shaded.redis.clients.jedis.Transaction;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisFeatureStore
implements FeatureStore {
    private static final Logger logger = LoggerFactory.getLogger(RedisFeatureStore.class);
    private static final String DEFAULT_PREFIX = "launchdarkly";
    private static final String INIT_KEY = "$initialized$";
    private static final String CACHE_REFRESH_THREAD_POOL_NAME_FORMAT = "RedisFeatureStore-cache-refresher-pool-%d";
    private final JedisPool pool;
    private LoadingCache<CacheKey, Optional<VersionedData>> cache;
    private final LoadingCache<String, Boolean> initCache = this.createInitCache();
    private String prefix;
    private ListeningExecutorService executorService;

    protected RedisFeatureStore(RedisFeatureStoreBuilder builder) {
        this.pool = builder.poolConfig == null ? new JedisPool((GenericObjectPoolConfig)RedisFeatureStore.getPoolConfig(), builder.uri, builder.connectTimeout, builder.socketTimeout) : new JedisPool((GenericObjectPoolConfig)builder.poolConfig, builder.uri, builder.connectTimeout, builder.socketTimeout);
        this.setPrefix(builder.prefix);
        this.createCache(builder.cacheTimeSecs, builder.refreshStaleValues, builder.asyncRefresh);
    }

    public RedisFeatureStore() {
        this.pool = new JedisPool((GenericObjectPoolConfig)RedisFeatureStore.getPoolConfig(), "localhost");
        this.prefix = DEFAULT_PREFIX;
    }

    private void setPrefix(String prefix) {
        this.prefix = prefix == null || prefix.isEmpty() ? DEFAULT_PREFIX : prefix;
    }

    private void createCache(long cacheTimeSecs) {
        this.createCache(cacheTimeSecs, false, false);
    }

    private void createCache(long cacheTimeSecs, boolean refreshStaleValues, boolean asyncRefresh) {
        if (cacheTimeSecs > 0L) {
            if (refreshStaleValues) {
                this.createRefreshCache(cacheTimeSecs, asyncRefresh);
            } else {
                this.createExpiringCache(cacheTimeSecs);
            }
        }
    }

    private CacheLoader<CacheKey, Optional<VersionedData>> createDefaultCacheLoader() {
        return new CacheLoader<CacheKey, Optional<VersionedData>>(){

            @Override
            public Optional<VersionedData> load(CacheKey key) throws Exception {
                return Optional.fromNullable(RedisFeatureStore.this.getRedis(key.kind, key.key));
            }
        };
    }

    private void createRefreshCache(long cacheTimeSecs, boolean asyncRefresh) {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat(CACHE_REFRESH_THREAD_POOL_NAME_FORMAT).setDaemon(true).build();
        ExecutorService parentExecutor = Executors.newSingleThreadExecutor(threadFactory);
        this.executorService = MoreExecutors.listeningDecorator(parentExecutor);
        CacheLoader<CacheKey, Optional<VersionedData>> cacheLoader = this.createDefaultCacheLoader();
        if (asyncRefresh) {
            cacheLoader = CacheLoader.asyncReloading(cacheLoader, this.executorService);
        }
        this.cache = CacheBuilder.newBuilder().refreshAfterWrite(cacheTimeSecs, TimeUnit.SECONDS).build(cacheLoader);
    }

    private void createExpiringCache(long cacheTimeSecs) {
        this.cache = CacheBuilder.newBuilder().expireAfterWrite(cacheTimeSecs, TimeUnit.SECONDS).build(this.createDefaultCacheLoader());
    }

    private LoadingCache<String, Boolean> createInitCache() {
        return CacheBuilder.newBuilder().build(new CacheLoader<String, Boolean>(){

            @Override
            public Boolean load(String key) throws Exception {
                return RedisFeatureStore.this.getInit();
            }
        });
    }

    @Override
    public <T extends VersionedData> T get(VersionedDataKind<T> kind, String key) {
        VersionedData item = this.cache != null ? this.cache.getUnchecked(new CacheKey(kind, key)).orNull() : this.getRedis(kind, key);
        if (item != null) {
            logger.debug("[get] Key: {} with version: {} found in \"{}\".", new Object[]{key, item.getVersion(), kind.getNamespace()});
        }
        return (T)item;
    }

    @Override
    public <T extends VersionedData> Map<String, T> all(VersionedDataKind<T> kind) {
        try (Jedis jedis = this.pool.getResource();){
            Map<String, String> allJson = jedis.hgetAll(this.itemsKey(kind));
            HashMap<String, VersionedData> result = new HashMap<String, VersionedData>();
            Gson gson = new Gson();
            for (Map.Entry<String, String> entry : allJson.entrySet()) {
                VersionedData item = (VersionedData)gson.fromJson(entry.getValue(), kind.getItemClass());
                if (item.isDeleted()) continue;
                result.put(entry.getKey(), item);
            }
            HashMap<String, VersionedData> hashMap = result;
            return hashMap;
        }
    }

    @Override
    public void init(Map<VersionedDataKind<?>, Map<String, ? extends VersionedData>> allData) {
        try (Jedis jedis = this.pool.getResource();){
            Gson gson = new Gson();
            Transaction t = jedis.multi();
            for (Map.Entry<VersionedDataKind<?>, Map<String, VersionedData>> entry : allData.entrySet()) {
                String baseKey = this.itemsKey(entry.getKey());
                t.del(baseKey);
                for (VersionedData versionedData : entry.getValue().values()) {
                    t.hset(baseKey, versionedData.getKey(), gson.toJson((Object)versionedData));
                }
            }
            t.exec();
        }
        this.cache.invalidateAll();
        this.initCache.put(INIT_KEY, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends VersionedData> void delete(VersionedDataKind<T> kind, String key, int version) {
        BinaryJedis jedis = null;
        try {
            Gson gson = new Gson();
            jedis = this.pool.getResource();
            String baseKey = this.itemsKey(kind);
            ((Jedis)jedis).watch(baseKey);
            T item = this.getRedis(kind, key, (Jedis)jedis);
            if (item != null && item.getVersion() >= version) {
                logger.warn("Attempted to delete key: {} version: {} with a version that is the same or older: {} in \"{}\"", new Object[]{key, item.getVersion(), version, kind.getNamespace()});
                return;
            }
            T deletedItem = kind.makeDeletedItem(key, version);
            ((Jedis)jedis).hset(baseKey, key, gson.toJson(deletedItem));
            if (this.cache != null) {
                this.cache.invalidate(new CacheKey(kind, key));
            }
        }
        finally {
            if (jedis != null) {
                jedis.unwatch();
                ((Jedis)jedis).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends VersionedData> void upsert(VersionedDataKind<T> kind, T item) {
        Jedis jedis = null;
        try {
            jedis = this.pool.getResource();
            Gson gson = new Gson();
            String baseKey = this.itemsKey(kind);
            jedis.watch(baseKey);
            T old = this.getRedisEvenIfDeleted(kind, item.getKey(), jedis);
            if (old != null && old.getVersion() >= item.getVersion()) {
                logger.warn("Attempted to update key: {} version: {} with a version that is the same or older: {} in \"{}\"", new Object[]{item.getKey(), old.getVersion(), item.getVersion(), kind.getNamespace()});
                return;
            }
            jedis.hset(baseKey, item.getKey(), gson.toJson(item));
            if (this.cache != null) {
                this.cache.invalidate(new CacheKey(kind, item.getKey()));
            }
        }
        finally {
            if (jedis != null) {
                jedis.unwatch();
                jedis.close();
            }
        }
    }

    @Override
    public boolean initialized() {
        return this.initCache.getUnchecked(INIT_KEY);
    }

    @Override
    public void close() throws IOException {
        logger.info("Closing LaunchDarkly RedisFeatureStore");
        try {
            if (this.executorService != null) {
                this.executorService.shutdownNow();
            }
        }
        finally {
            this.pool.destroy();
        }
    }

    public CacheStats getCacheStats() {
        if (this.cache != null) {
            return this.cache.stats();
        }
        return null;
    }

    private String itemsKey(VersionedDataKind<?> kind) {
        return this.prefix + ":" + kind.getNamespace();
    }

    private Boolean getInit() {
        try (Jedis jedis = this.pool.getResource();){
            Boolean bl = jedis.exists(this.itemsKey(VersionedDataKind.FEATURES));
            return bl;
        }
    }

    private <T extends VersionedData> T getRedis(VersionedDataKind<T> kind, String key) {
        try (Jedis jedis = this.pool.getResource();){
            T t = this.getRedis(kind, key, jedis);
            return t;
        }
    }

    private <T extends VersionedData> T getRedis(VersionedDataKind<T> kind, String key, Jedis jedis) {
        T item = this.getRedisEvenIfDeleted(kind, key, jedis);
        if (item != null && item.isDeleted()) {
            logger.debug("[get] Key: {} has been deleted in \"{}\". Returning null", (Object)key, (Object)kind.getNamespace());
            return null;
        }
        return item;
    }

    private <T extends VersionedData> T getRedisEvenIfDeleted(VersionedDataKind<T> kind, String key, Jedis jedis) {
        Gson gson = new Gson();
        String json = jedis.hget(this.itemsKey(kind), key);
        if (json == null) {
            logger.debug("[get] Key: {} not found in \"{}\". Returning null", (Object)key, (Object)kind.getNamespace());
            return null;
        }
        return (T)((VersionedData)gson.fromJson(json, kind.getItemClass()));
    }

    private static JedisPoolConfig getPoolConfig() {
        return new JedisPoolConfig();
    }

    private static class CacheKey {
        final VersionedDataKind<?> kind;
        final String key;

        public CacheKey(VersionedDataKind<?> kind, String key) {
            this.kind = kind;
            this.key = key;
        }

        public boolean equals(Object other) {
            if (other instanceof CacheKey) {
                CacheKey o = (CacheKey)other;
                return o.kind.getNamespace().equals(this.kind.getNamespace()) && o.key.equals(this.key);
            }
            return false;
        }

        public int hashCode() {
            return this.kind.getNamespace().hashCode() * 31 + this.key.hashCode();
        }
    }
}

