/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.google.gson.Gson;
import com.launchdarkly.client.FeatureStore;
import com.launchdarkly.client.RedisFeatureStoreBuilder;
import com.launchdarkly.client.VersionedData;
import com.launchdarkly.client.VersionedDataKind;
import com.launchdarkly.shaded.com.google.common.annotations.VisibleForTesting;
import com.launchdarkly.shaded.com.google.common.base.Optional;
import com.launchdarkly.shaded.com.google.common.cache.CacheBuilder;
import com.launchdarkly.shaded.com.google.common.cache.CacheLoader;
import com.launchdarkly.shaded.com.google.common.cache.CacheStats;
import com.launchdarkly.shaded.com.google.common.cache.LoadingCache;
import com.launchdarkly.shaded.com.google.common.util.concurrent.ListeningExecutorService;
import com.launchdarkly.shaded.com.google.common.util.concurrent.MoreExecutors;
import com.launchdarkly.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.launchdarkly.shaded.org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import com.launchdarkly.shaded.redis.clients.jedis.Jedis;
import com.launchdarkly.shaded.redis.clients.jedis.JedisPool;
import com.launchdarkly.shaded.redis.clients.jedis.JedisPoolConfig;
import com.launchdarkly.shaded.redis.clients.jedis.Transaction;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisFeatureStore
implements FeatureStore {
    private static final Logger logger = LoggerFactory.getLogger(RedisFeatureStore.class);
    private static final String DEFAULT_PREFIX = "launchdarkly";
    private static final String INIT_KEY = "$initialized$";
    private static final String CACHE_REFRESH_THREAD_POOL_NAME_FORMAT = "RedisFeatureStore-cache-refresher-pool-%d";
    private static final Gson gson = new Gson();
    private final JedisPool pool;
    private LoadingCache<CacheKey, Optional<VersionedData>> cache;
    private final LoadingCache<String, Boolean> initCache = this.createInitCache();
    private String prefix;
    private ListeningExecutorService executorService;
    private UpdateListener updateListener;

    protected RedisFeatureStore(RedisFeatureStoreBuilder builder) {
        this.pool = builder.poolConfig == null ? new JedisPool((GenericObjectPoolConfig)RedisFeatureStore.getPoolConfig(), builder.uri, builder.connectTimeout, builder.socketTimeout) : new JedisPool((GenericObjectPoolConfig)builder.poolConfig, builder.uri, builder.connectTimeout, builder.socketTimeout);
        this.setPrefix(builder.prefix);
        this.createCache(builder.cacheTimeSecs, builder.refreshStaleValues, builder.asyncRefresh);
    }

    public RedisFeatureStore() {
        this.pool = new JedisPool((GenericObjectPoolConfig)RedisFeatureStore.getPoolConfig(), "localhost");
        this.prefix = DEFAULT_PREFIX;
    }

    private void setPrefix(String prefix) {
        this.prefix = prefix == null || prefix.isEmpty() ? DEFAULT_PREFIX : prefix;
    }

    private void createCache(long cacheTimeSecs, boolean refreshStaleValues, boolean asyncRefresh) {
        if (cacheTimeSecs > 0L) {
            if (refreshStaleValues) {
                this.createRefreshCache(cacheTimeSecs, asyncRefresh);
            } else {
                this.createExpiringCache(cacheTimeSecs);
            }
        }
    }

    private CacheLoader<CacheKey, Optional<VersionedData>> createDefaultCacheLoader() {
        return new CacheLoader<CacheKey, Optional<VersionedData>>(){

            @Override
            public Optional<VersionedData> load(CacheKey key) throws Exception {
                try (Jedis jedis = RedisFeatureStore.this.pool.getResource();){
                    Optional<VersionedData> optional = Optional.fromNullable(RedisFeatureStore.this.getRedisEvenIfDeleted(key.kind, key.key, jedis));
                    return optional;
                }
            }
        };
    }

    private void createRefreshCache(long cacheTimeSecs, boolean asyncRefresh) {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat(CACHE_REFRESH_THREAD_POOL_NAME_FORMAT).setDaemon(true).build();
        ExecutorService parentExecutor = Executors.newSingleThreadExecutor(threadFactory);
        this.executorService = MoreExecutors.listeningDecorator(parentExecutor);
        CacheLoader<CacheKey, Optional<VersionedData>> cacheLoader = this.createDefaultCacheLoader();
        if (asyncRefresh) {
            cacheLoader = CacheLoader.asyncReloading(cacheLoader, this.executorService);
        }
        this.cache = CacheBuilder.newBuilder().refreshAfterWrite(cacheTimeSecs, TimeUnit.SECONDS).build(cacheLoader);
    }

    private void createExpiringCache(long cacheTimeSecs) {
        this.cache = CacheBuilder.newBuilder().expireAfterWrite(cacheTimeSecs, TimeUnit.SECONDS).build(this.createDefaultCacheLoader());
    }

    private LoadingCache<String, Boolean> createInitCache() {
        return CacheBuilder.newBuilder().build(new CacheLoader<String, Boolean>(){

            @Override
            public Boolean load(String key) throws Exception {
                return RedisFeatureStore.this.getInit();
            }
        });
    }

    @Override
    public <T extends VersionedData> T get(VersionedDataKind<T> kind, String key) {
        VersionedData item;
        if (this.cache != null) {
            item = this.cache.getUnchecked(new CacheKey(kind, key)).orNull();
        } else {
            try (Jedis jedis = this.pool.getResource();){
                item = this.getRedisEvenIfDeleted(kind, key, jedis);
            }
        }
        if (item != null && item.isDeleted()) {
            logger.debug("[get] Key: {} has been deleted in \"{}\". Returning null", (Object)key, (Object)kind.getNamespace());
            return null;
        }
        if (item != null) {
            logger.debug("[get] Key: {} with version: {} found in \"{}\".", new Object[]{key, item.getVersion(), kind.getNamespace()});
        }
        return (T)item;
    }

    @Override
    public <T extends VersionedData> Map<String, T> all(VersionedDataKind<T> kind) {
        try (Jedis jedis = this.pool.getResource();){
            Map<String, String> allJson = jedis.hgetAll(this.itemsKey(kind));
            HashMap<String, VersionedData> result = new HashMap<String, VersionedData>();
            for (Map.Entry<String, String> entry : allJson.entrySet()) {
                VersionedData item = (VersionedData)gson.fromJson(entry.getValue(), kind.getItemClass());
                if (item.isDeleted()) continue;
                result.put(entry.getKey(), item);
            }
            HashMap<String, VersionedData> hashMap = result;
            return hashMap;
        }
    }

    @Override
    public void init(Map<VersionedDataKind<?>, Map<String, ? extends VersionedData>> allData) {
        try (Jedis jedis = this.pool.getResource();){
            Transaction t = jedis.multi();
            for (Map.Entry<VersionedDataKind<?>, Map<String, VersionedData>> entry : allData.entrySet()) {
                String baseKey = this.itemsKey(entry.getKey());
                t.del(baseKey);
                for (VersionedData versionedData : entry.getValue().values()) {
                    t.hset(baseKey, versionedData.getKey(), gson.toJson((Object)versionedData));
                }
            }
            t.exec();
        }
        this.cache.invalidateAll();
        this.initCache.put(INIT_KEY, true);
    }

    @Override
    public <T extends VersionedData> void delete(VersionedDataKind<T> kind, String key, int version) {
        T deletedItem = kind.makeDeletedItem(key, version);
        this.updateItemWithVersioning(kind, deletedItem);
    }

    @Override
    public <T extends VersionedData> void upsert(VersionedDataKind<T> kind, T item) {
        this.updateItemWithVersioning(kind, item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends VersionedData> void updateItemWithVersioning(VersionedDataKind<T> kind, T newItem) {
        while (true) {
            Jedis jedis = null;
            try {
                T oldItem;
                jedis = this.pool.getResource();
                String baseKey = this.itemsKey(kind);
                jedis.watch(baseKey);
                if (this.updateListener != null) {
                    this.updateListener.aboutToUpdate(baseKey, newItem.getKey());
                }
                if ((oldItem = this.getRedisEvenIfDeleted(kind, newItem.getKey(), jedis)) != null && oldItem.getVersion() >= newItem.getVersion()) {
                    logger.debug("Attempted to {} key: {} version: {} with a version that is the same or older: {} in \"{}\"", new Object[]{newItem.isDeleted() ? "delete" : "update", newItem.getKey(), oldItem.getVersion(), newItem.getVersion(), kind.getNamespace()});
                    return;
                }
                Transaction tx = jedis.multi();
                tx.hset(baseKey, newItem.getKey(), gson.toJson(newItem));
                List<Object> result = tx.exec();
                if (result.isEmpty()) {
                    logger.debug("Concurrent modification detected, retrying");
                    continue;
                }
                if (this.cache == null) continue;
                this.cache.invalidate(new CacheKey(kind, newItem.getKey()));
                continue;
            }
            finally {
                if (jedis == null) continue;
                jedis.unwatch();
                jedis.close();
                continue;
            }
            break;
        }
    }

    @Override
    public boolean initialized() {
        return this.initCache.getUnchecked(INIT_KEY);
    }

    @Override
    public void close() throws IOException {
        logger.info("Closing LaunchDarkly RedisFeatureStore");
        try {
            if (this.executorService != null) {
                this.executorService.shutdownNow();
            }
        }
        finally {
            this.pool.destroy();
        }
    }

    public CacheStats getCacheStats() {
        if (this.cache != null) {
            return this.cache.stats();
        }
        return null;
    }

    private String itemsKey(VersionedDataKind<?> kind) {
        return this.prefix + ":" + kind.getNamespace();
    }

    private Boolean getInit() {
        try (Jedis jedis = this.pool.getResource();){
            Boolean bl = jedis.exists(this.itemsKey(VersionedDataKind.FEATURES));
            return bl;
        }
    }

    private <T extends VersionedData> T getRedisEvenIfDeleted(VersionedDataKind<T> kind, String key, Jedis jedis) {
        String json = jedis.hget(this.itemsKey(kind), key);
        if (json == null) {
            logger.debug("[get] Key: {} not found in \"{}\". Returning null", (Object)key, (Object)kind.getNamespace());
            return null;
        }
        return (T)((VersionedData)gson.fromJson(json, kind.getItemClass()));
    }

    private static JedisPoolConfig getPoolConfig() {
        return new JedisPoolConfig();
    }

    @VisibleForTesting
    void setUpdateListener(UpdateListener updateListener) {
        this.updateListener = updateListener;
    }

    static interface UpdateListener {
        public void aboutToUpdate(String var1, String var2);
    }

    private static class CacheKey {
        final VersionedDataKind<?> kind;
        final String key;

        public CacheKey(VersionedDataKind<?> kind, String key) {
            this.kind = kind;
            this.key = key;
        }

        public boolean equals(Object other) {
            if (other instanceof CacheKey) {
                CacheKey o = (CacheKey)other;
                return o.kind.getNamespace().equals(this.kind.getNamespace()) && o.key.equals(this.key);
            }
            return false;
        }

        public int hashCode() {
            return this.kind.getNamespace().hashCode() * 31 + this.key.hashCode();
        }
    }
}

