/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.launchdarkly.client.FeatureFlag;
import com.launchdarkly.client.FeatureFlagBuilder;
import com.launchdarkly.client.Segment;
import com.launchdarkly.client.VersionedData;

public abstract class VersionedDataKind<T extends VersionedData> {
    public static VersionedDataKind<FeatureFlag> FEATURES = new VersionedDataKind<FeatureFlag>(){

        @Override
        public String getNamespace() {
            return "features";
        }

        @Override
        public Class<FeatureFlag> getItemClass() {
            return FeatureFlag.class;
        }

        @Override
        public String getStreamApiPath() {
            return "/flags/";
        }

        @Override
        public FeatureFlag makeDeletedItem(String key, int version) {
            return new FeatureFlagBuilder(key).deleted(true).version(version).build();
        }
    };
    public static VersionedDataKind<Segment> SEGMENTS = new VersionedDataKind<Segment>(){

        @Override
        public String getNamespace() {
            return "segments";
        }

        @Override
        public Class<Segment> getItemClass() {
            return Segment.class;
        }

        @Override
        public String getStreamApiPath() {
            return "/segments/";
        }

        @Override
        public Segment makeDeletedItem(String key, int version) {
            return new Segment.Builder(key).deleted(true).version(version).build();
        }
    };

    public abstract String getNamespace();

    public abstract Class<T> getItemClass();

    public abstract String getStreamApiPath();

    public abstract T makeDeletedItem(String var1, int var2);

    String getKeyFromStreamApiPath(String path) {
        return path.startsWith(this.getStreamApiPath()) ? path.substring(this.getStreamApiPath().length()) : null;
    }
}

