/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.google.gson.JsonElement;
import com.google.gson.annotations.SerializedName;
import com.launchdarkly.client.CustomEvent;
import com.launchdarkly.client.Event;
import com.launchdarkly.client.EventProcessor;
import com.launchdarkly.client.EventSummarizer;
import com.launchdarkly.client.FeatureRequestEvent;
import com.launchdarkly.client.IdentifyEvent;
import com.launchdarkly.client.LDConfig;
import com.launchdarkly.client.LDUser;
import com.launchdarkly.client.SimpleLRUCache;
import com.launchdarkly.shaded.com.google.common.annotations.VisibleForTesting;
import com.launchdarkly.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.launchdarkly.shaded.okhttp3.MediaType;
import com.launchdarkly.shaded.okhttp3.Request;
import com.launchdarkly.shaded.okhttp3.RequestBody;
import com.launchdarkly.shaded.okhttp3.Response;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultEventProcessor
implements EventProcessor {
    private static final Logger logger = LoggerFactory.getLogger(DefaultEventProcessor.class);
    static final SimpleDateFormat HTTP_DATE_FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
    private static final int CHANNEL_BLOCK_MILLIS = 1000;
    private final BlockingQueue<EventProcessorMessage> inputChannel;
    private final ThreadFactory threadFactory;
    private final ScheduledExecutorService scheduler;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final AtomicBoolean inputCapacityExceeded = new AtomicBoolean(false);

    DefaultEventProcessor(String sdkKey, LDConfig config) {
        this.inputChannel = new ArrayBlockingQueue<EventProcessorMessage>(config.capacity);
        this.threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("LaunchDarkly-EventProcessor-%d").build();
        this.scheduler = Executors.newSingleThreadScheduledExecutor(this.threadFactory);
        new EventConsumer(sdkKey, config, this.inputChannel, this.threadFactory);
        Runnable flusher = new Runnable(){

            @Override
            public void run() {
                DefaultEventProcessor.this.postMessageAsync(MessageType.FLUSH, null);
            }
        };
        this.scheduler.scheduleAtFixedRate(flusher, config.flushInterval, config.flushInterval, TimeUnit.SECONDS);
        Runnable userKeysFlusher = new Runnable(){

            @Override
            public void run() {
                DefaultEventProcessor.this.postMessageAsync(MessageType.FLUSH_USERS, null);
            }
        };
        this.scheduler.scheduleAtFixedRate(userKeysFlusher, config.userKeysFlushInterval, config.userKeysFlushInterval, TimeUnit.SECONDS);
    }

    @Override
    public void sendEvent(Event e) {
        if (!this.closed.get()) {
            this.postMessageAsync(MessageType.EVENT, e);
        }
    }

    @Override
    public void flush() {
        if (!this.closed.get()) {
            this.postMessageAsync(MessageType.FLUSH, null);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            this.scheduler.shutdown();
            this.postMessageAsync(MessageType.FLUSH, null);
            this.postMessageAndWait(MessageType.SHUTDOWN, null);
        }
    }

    @VisibleForTesting
    void waitUntilInactive() throws IOException {
        this.postMessageAndWait(MessageType.SYNC, null);
    }

    private void postMessageAsync(MessageType type, Event event) {
        this.postToChannel(new EventProcessorMessage(type, event, false));
    }

    private void postMessageAndWait(MessageType type, Event event) {
        EventProcessorMessage message = new EventProcessorMessage(type, event, true);
        this.postToChannel(message);
        message.waitForCompletion();
    }

    private void postToChannel(EventProcessorMessage message) {
        block2: while (true) {
            try {
                while (true) {
                    if (this.inputChannel.offer(message, 1000L, TimeUnit.MILLISECONDS)) {
                        this.inputCapacityExceeded.set(false);
                        break block2;
                    }
                    if (!this.inputCapacityExceeded.compareAndSet(false, true)) continue;
                    logger.warn("Events are being produced faster than they can be processed");
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private static class SummaryEventCounter {
        final JsonElement value;
        final Integer version;
        final int count;
        final Boolean unknown;

        SummaryEventCounter(JsonElement value, Integer version, int count, Boolean unknown) {
            this.value = value;
            this.version = version;
            this.count = count;
            this.unknown = unknown;
        }
    }

    private static class SummaryEventFlag {
        @SerializedName(value="default")
        final JsonElement defaultVal;
        final List<SummaryEventCounter> counters;

        SummaryEventFlag(JsonElement defaultVal, List<SummaryEventCounter> counters) {
            this.defaultVal = defaultVal;
            this.counters = counters;
        }
    }

    private static class SummaryEventOutput
    implements EventOutput {
        private final String kind;
        private final long startDate;
        private final long endDate;
        private final Map<String, SummaryEventFlag> features;

        SummaryEventOutput(long startDate, long endDate, Map<String, SummaryEventFlag> features) {
            this.kind = "summary";
            this.startDate = startDate;
            this.endDate = endDate;
            this.features = features;
        }
    }

    private static class IndexEventOutput
    implements EventOutput {
        private final String kind;
        private final long creationDate;
        private final LDUser user;

        public IndexEventOutput(long creationDate, LDUser user) {
            this.kind = "index";
            this.creationDate = creationDate;
            this.user = user;
        }
    }

    private static class IndexEvent
    extends Event {
        IndexEvent(long creationDate, LDUser user) {
            super(creationDate, user);
        }
    }

    private static class CustomEventOutput
    implements EventOutput {
        private final String kind;
        private final long creationDate;
        private final String key;
        private final String userKey;
        private final LDUser user;
        private final JsonElement data;

        CustomEventOutput(long creationDate, String key, String userKey, LDUser user, JsonElement data) {
            this.kind = "custom";
            this.creationDate = creationDate;
            this.key = key;
            this.userKey = userKey;
            this.user = user;
            this.data = data;
        }
    }

    private static class IdentifyEventOutput
    extends Event
    implements EventOutput {
        private final String kind;
        private final String key;

        IdentifyEventOutput(long creationDate, LDUser user) {
            super(creationDate, user);
            this.kind = "identify";
            this.key = user.getKeyAsString();
        }
    }

    private static class FeatureRequestEventOutput
    implements EventOutput {
        private final String kind;
        private final long creationDate;
        private final String key;
        private final String userKey;
        private final LDUser user;
        private final Integer version;
        private final JsonElement value;
        @SerializedName(value="default")
        private final JsonElement defaultVal;
        private final String prereqOf;

        FeatureRequestEventOutput(long creationDate, String key, String userKey, LDUser user, Integer version, JsonElement value, JsonElement defaultVal, String prereqOf, boolean debug) {
            this.kind = debug ? "debug" : "feature";
            this.creationDate = creationDate;
            this.key = key;
            this.userKey = userKey;
            this.user = user;
            this.version = version;
            this.value = value;
            this.defaultVal = defaultVal;
            this.prereqOf = prereqOf;
        }
    }

    private static interface EventOutput {
    }

    private static class FlushPayload {
        final Event[] events;
        final EventSummarizer.EventSummary summary;

        FlushPayload(Event[] events, EventSummarizer.EventSummary summary) {
            this.events = events;
            this.summary = summary;
        }
    }

    private static class EventProcessorMessage {
        private final MessageType type;
        private final Event event;
        private final Semaphore reply;

        private EventProcessorMessage(MessageType type, Event event, boolean sync) {
            this.type = type;
            this.event = event;
            this.reply = sync ? new Semaphore(0) : null;
        }

        void completed() {
            if (this.reply != null) {
                this.reply.release();
            }
        }

        void waitForCompletion() {
            if (this.reply == null) {
                return;
            }
            while (true) {
                try {
                    this.reply.acquire();
                    return;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        public String toString() {
            return (this.event == null ? this.type.toString() : (Object)((Object)this.type) + ": " + this.event.getClass().getSimpleName()) + (this.reply == null ? "" : " (sync)");
        }
    }

    private static enum MessageType {
        EVENT,
        FLUSH,
        FLUSH_USERS,
        SYNC,
        SHUTDOWN;

    }

    private static class EventConsumer {
        private static final int MAX_FLUSH_THREADS = 5;
        private final String sdkKey;
        private final LDConfig config;
        private final BlockingQueue<EventProcessorMessage> inputChannel;
        private final AtomicInteger flushWorkersActive;
        private final Thread mainThread;
        private final List<Thread> flushWorkerThreads;
        private final BlockingQueue<FlushPayload> payloadQueue;
        private final ArrayList<Event> buffer;
        private final EventSummarizer summarizer;
        private final SimpleLRUCache<String, String> userKeys;
        private final Random random = new Random();
        private final AtomicLong lastKnownPastTime = new AtomicLong(0L);
        private final AtomicBoolean disabled = new AtomicBoolean(false);
        private final AtomicBoolean shuttingDown = new AtomicBoolean(false);
        private boolean capacityExceeded = false;

        private EventConsumer(String sdkKey, LDConfig config, BlockingQueue<EventProcessorMessage> inputChannel, ThreadFactory threadFactory) {
            this.sdkKey = sdkKey;
            this.config = config;
            this.inputChannel = inputChannel;
            this.flushWorkersActive = new AtomicInteger(0);
            this.buffer = new ArrayList(config.capacity);
            this.summarizer = new EventSummarizer();
            this.userKeys = new SimpleLRUCache(config.userKeysCapacity);
            this.payloadQueue = new ArrayBlockingQueue<FlushPayload>(1);
            this.mainThread = threadFactory.newThread(new Runnable(){

                @Override
                public void run() {
                    EventConsumer.this.runMainLoop();
                }
            });
            this.mainThread.setDaemon(true);
            this.mainThread.start();
            this.flushWorkerThreads = new ArrayList<Thread>();
            for (int i = 0; i < 5; ++i) {
                Thread workerThread = threadFactory.newThread(new Runnable(){

                    @Override
                    public void run() {
                        EventConsumer.this.runFlushWorker();
                    }
                });
                workerThread.setDaemon(true);
                workerThread.start();
                this.flushWorkerThreads.add(workerThread);
            }
        }

        private void runMainLoop() {
            while (true) {
                try {
                    while (true) {
                        EventProcessorMessage message = this.inputChannel.take();
                        switch (message.type) {
                            case EVENT: {
                                this.processEvent(message.event);
                                break;
                            }
                            case FLUSH: {
                                this.triggerFlush();
                                break;
                            }
                            case FLUSH_USERS: {
                                this.userKeys.clear();
                                break;
                            }
                            case SYNC: {
                                this.waitUntilAllFlushWorkersInactive();
                                message.completed();
                                break;
                            }
                            case SHUTDOWN: {
                                this.doShutdown();
                                message.completed();
                                return;
                            }
                        }
                        message.completed();
                    }
                }
                catch (InterruptedException message) {
                    continue;
                }
                catch (Exception e) {
                    logger.error("Unexpected error in event processor: " + e);
                    logger.debug(e.getMessage(), (Throwable)e);
                    continue;
                }
                break;
            }
        }

        private void doShutdown() {
            this.waitUntilAllFlushWorkersInactive();
            this.disabled.set(true);
            this.shuttingDown.set(true);
            for (Thread t : this.flushWorkerThreads) {
                t.interrupt();
            }
        }

        private void runFlushWorker() {
            while (!this.shuttingDown.get()) {
                FlushPayload payload = null;
                try {
                    payload = this.payloadQueue.take();
                }
                catch (InterruptedException e) {
                    continue;
                }
                try {
                    this.doFlush(payload);
                }
                catch (Exception e) {
                    logger.error("Unexpected error in event processor: " + e);
                    logger.debug(e.getMessage(), (Throwable)e);
                }
                this.flushWorkerFinishedWork();
            }
        }

        private void flushWorkerStartingWork() {
            this.flushWorkersActive.incrementAndGet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void flushWorkerFinishedWork() {
            AtomicInteger atomicInteger = this.flushWorkersActive;
            synchronized (atomicInteger) {
                this.flushWorkersActive.decrementAndGet();
                this.flushWorkersActive.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void waitUntilAllFlushWorkersInactive() {
            while (true) {
                try {
                    while (true) {
                        AtomicInteger atomicInteger = this.flushWorkersActive;
                        synchronized (atomicInteger) {
                            if (this.flushWorkersActive.get() == 0) {
                                return;
                            }
                            this.flushWorkersActive.wait();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        private void processEvent(Event e) {
            if (this.disabled.get()) {
                return;
            }
            if (!(this.config.inlineUsersInEvents || e.user == null || this.noticeUser(e.user) || e instanceof IdentifyEvent)) {
                IndexEvent ie = new IndexEvent(e.creationDate, e.user);
                this.addToBuffer(ie);
            }
            this.summarizer.summarizeEvent(e);
            if (this.shouldTrackFullEvent(e)) {
                if (this.config.samplingInterval > 0 && this.random.nextInt(this.config.samplingInterval) != 0) {
                    return;
                }
                this.addToBuffer(e);
            }
        }

        private boolean noticeUser(LDUser user) {
            if (user == null || user.getKey() == null) {
                return false;
            }
            String key = user.getKeyAsString();
            return this.userKeys.put(key, key) != null;
        }

        private void addToBuffer(Event e) {
            if (this.buffer.size() >= this.config.capacity) {
                if (!this.capacityExceeded) {
                    this.capacityExceeded = true;
                    logger.warn("Exceeded event queue capacity. Increase capacity to avoid dropping events.");
                }
            } else {
                this.capacityExceeded = false;
                this.buffer.add(e);
            }
        }

        private boolean shouldTrackFullEvent(Event e) {
            if (e instanceof FeatureRequestEvent) {
                FeatureRequestEvent fe = (FeatureRequestEvent)e;
                if (fe.trackEvents) {
                    return true;
                }
                if (fe.debugEventsUntilDate != null) {
                    long lastPast = this.lastKnownPastTime.get();
                    if (fe.debugEventsUntilDate > lastPast && fe.debugEventsUntilDate > System.currentTimeMillis()) {
                        return true;
                    }
                }
                return false;
            }
            return true;
        }

        private void triggerFlush() {
            if (this.disabled.get()) {
                return;
            }
            Event[] events = this.buffer.toArray(new Event[this.buffer.size()]);
            EventSummarizer.EventSummary summary = this.summarizer.snapshot();
            if (events.length != 0 || !summary.isEmpty()) {
                this.flushWorkerStartingWork();
                FlushPayload payload = new FlushPayload(events, summary);
                if (this.payloadQueue.offer(payload)) {
                    this.buffer.clear();
                    this.summarizer.clear();
                } else {
                    logger.debug("Skipped flushing because all workers are busy");
                    this.flushWorkerFinishedWork();
                }
            }
        }

        private void doFlush(FlushPayload payload) {
            if (payload.events.length == 0 && payload.summary.isEmpty()) {
                return;
            }
            ArrayList<EventOutput> eventsOut = new ArrayList<EventOutput>(payload.events.length + 1);
            for (Event event : payload.events) {
                eventsOut.add(this.createEventOutput(event));
            }
            if (!payload.summary.isEmpty()) {
                eventsOut.add(this.createSummaryEvent(payload.summary));
            }
            String json = this.config.gson.toJson(eventsOut);
            logger.debug("Posting {} event(s) to {} with payload: {}", new Object[]{eventsOut.size(), this.config.eventsURI, json});
            Request request = this.config.getRequestBuilder(this.sdkKey).url(this.config.eventsURI.toString() + "/bulk").post(RequestBody.create(MediaType.parse("application/json; charset=utf-8"), json)).addHeader("Content-Type", "application/json").build();
            long startTime = System.currentTimeMillis();
            try (Response response = this.config.httpClient.newCall(request).execute();){
                long endTime = System.currentTimeMillis();
                logger.debug("Event delivery took {} ms, response status {}", (Object)(endTime - startTime), (Object)response.code());
                this.handleResponse(response);
            }
            catch (IOException e) {
                logger.info("Unhandled exception in LaunchDarkly client when posting events to URL: " + request.url(), (Throwable)e);
            }
        }

        private EventOutput createEventOutput(Event e) {
            String userKey;
            String string = userKey = e.user == null ? null : e.user.getKeyAsString();
            if (e instanceof FeatureRequestEvent) {
                FeatureRequestEvent fe = (FeatureRequestEvent)e;
                boolean isDebug = !fe.trackEvents && fe.debugEventsUntilDate != null;
                return new FeatureRequestEventOutput(fe.creationDate, fe.key, this.config.inlineUsersInEvents ? null : userKey, this.config.inlineUsersInEvents ? e.user : null, fe.version, fe.value, fe.defaultVal, fe.prereqOf, isDebug);
            }
            if (e instanceof IdentifyEvent) {
                return new IdentifyEventOutput(e.creationDate, e.user);
            }
            if (e instanceof CustomEvent) {
                CustomEvent ce = (CustomEvent)e;
                return new CustomEventOutput(ce.creationDate, ce.key, this.config.inlineUsersInEvents ? null : userKey, this.config.inlineUsersInEvents ? e.user : null, ce.data);
            }
            if (e instanceof IndexEvent) {
                return new IndexEventOutput(e.creationDate, e.user);
            }
            return null;
        }

        private EventOutput createSummaryEvent(EventSummarizer.EventSummary summary) {
            HashMap<String, SummaryEventFlag> flagsOut = new HashMap<String, SummaryEventFlag>();
            for (Map.Entry<EventSummarizer.CounterKey, EventSummarizer.CounterValue> entry : summary.counters.entrySet()) {
                SummaryEventFlag fsd = (SummaryEventFlag)flagsOut.get(entry.getKey().key);
                if (fsd == null) {
                    fsd = new SummaryEventFlag(entry.getValue().defaultVal, new ArrayList<SummaryEventCounter>());
                    flagsOut.put(entry.getKey().key, fsd);
                }
                SummaryEventCounter c = new SummaryEventCounter(entry.getValue().flagValue, entry.getKey().version, entry.getValue().count, entry.getKey().version == null ? Boolean.valueOf(true) : null);
                fsd.counters.add(c);
            }
            return new SummaryEventOutput(summary.startDate, summary.endDate, flagsOut);
        }

        private void handleResponse(Response response) {
            String dateStr = response.header("Date");
            if (dateStr != null) {
                try {
                    this.lastKnownPastTime.set(HTTP_DATE_FORMAT.parse(dateStr).getTime());
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            if (!response.isSuccessful()) {
                logger.info("Got unexpected response when posting events: " + response);
                if (response.code() == 401) {
                    this.disabled.set(true);
                    logger.error("Received 401 error, no further events will be posted since SDK key is invalid");
                }
            }
        }
    }
}

