/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.google.gson.JsonElement;
import com.launchdarkly.client.CustomEvent;
import com.launchdarkly.client.FeatureFlag;
import com.launchdarkly.client.FeatureRequestEvent;
import com.launchdarkly.client.IdentifyEvent;
import com.launchdarkly.client.LDUser;

abstract class EventFactory {
    public static final EventFactory DEFAULT = new DefaultEventFactory();

    EventFactory() {
    }

    protected abstract long getTimestamp();

    public FeatureRequestEvent newFeatureRequestEvent(FeatureFlag flag, LDUser user, FeatureFlag.VariationAndValue result, JsonElement defaultVal) {
        return new FeatureRequestEvent(this.getTimestamp(), flag.getKey(), user, flag.getVersion(), result == null ? null : result.getVariation(), result == null ? null : result.getValue(), defaultVal, null, flag.isTrackEvents(), flag.getDebugEventsUntilDate());
    }

    public FeatureRequestEvent newUnknownFeatureRequestEvent(String key, LDUser user, JsonElement defaultValue) {
        return new FeatureRequestEvent(this.getTimestamp(), key, user, null, null, defaultValue, defaultValue, null, false, null);
    }

    public FeatureRequestEvent newPrerequisiteFeatureRequestEvent(FeatureFlag prereqFlag, LDUser user, FeatureFlag.VariationAndValue result, FeatureFlag prereqOf) {
        return new FeatureRequestEvent(this.getTimestamp(), prereqFlag.getKey(), user, prereqFlag.getVersion(), result == null ? null : result.getVariation(), result == null ? null : result.getValue(), null, prereqOf.getKey(), prereqFlag.isTrackEvents(), prereqFlag.getDebugEventsUntilDate());
    }

    public CustomEvent newCustomEvent(String key, LDUser user, JsonElement data) {
        return new CustomEvent(this.getTimestamp(), key, user, data);
    }

    public IdentifyEvent newIdentifyEvent(LDUser user) {
        return new IdentifyEvent(this.getTimestamp(), user);
    }

    public static class DefaultEventFactory
    extends EventFactory {
        @Override
        protected long getTimestamp() {
            return System.currentTimeMillis();
        }
    }
}

