/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.google.gson.JsonElement;
import com.google.gson.reflect.TypeToken;
import com.launchdarkly.client.EvaluationException;
import com.launchdarkly.client.EventFactory;
import com.launchdarkly.client.FeatureRequestEvent;
import com.launchdarkly.client.FeatureStore;
import com.launchdarkly.client.LDConfig;
import com.launchdarkly.client.LDUser;
import com.launchdarkly.client.Prerequisite;
import com.launchdarkly.client.Rule;
import com.launchdarkly.client.Target;
import com.launchdarkly.client.VariationOrRollout;
import com.launchdarkly.client.VersionedData;
import com.launchdarkly.client.VersionedDataKind;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FeatureFlag
implements VersionedData {
    private static final Logger logger = LoggerFactory.getLogger(FeatureFlag.class);
    private static final Type mapType = new TypeToken<Map<String, FeatureFlag>>(){}.getType();
    private String key;
    private int version;
    private boolean on;
    private List<Prerequisite> prerequisites;
    private String salt;
    private List<Target> targets;
    private List<Rule> rules;
    private VariationOrRollout fallthrough;
    private Integer offVariation;
    private List<JsonElement> variations;
    private boolean trackEvents;
    private Long debugEventsUntilDate;
    private boolean deleted;

    static FeatureFlag fromJson(LDConfig config, String json) {
        return (FeatureFlag)config.gson.fromJson(json, FeatureFlag.class);
    }

    static Map<String, FeatureFlag> fromJsonMap(LDConfig config, String json) {
        return (Map)config.gson.fromJson(json, mapType);
    }

    FeatureFlag() {
    }

    FeatureFlag(String key, int version, boolean on, List<Prerequisite> prerequisites, String salt, List<Target> targets, List<Rule> rules, VariationOrRollout fallthrough, Integer offVariation, List<JsonElement> variations, boolean trackEvents, Long debugEventsUntilDate, boolean deleted) {
        this.key = key;
        this.version = version;
        this.on = on;
        this.prerequisites = prerequisites;
        this.salt = salt;
        this.targets = targets;
        this.rules = rules;
        this.fallthrough = fallthrough;
        this.offVariation = offVariation;
        this.variations = variations;
        this.trackEvents = trackEvents;
        this.debugEventsUntilDate = debugEventsUntilDate;
        this.deleted = deleted;
    }

    EvalResult evaluate(LDUser user, FeatureStore featureStore, EventFactory eventFactory) throws EvaluationException {
        VariationAndValue result;
        ArrayList<FeatureRequestEvent> prereqEvents = new ArrayList<FeatureRequestEvent>();
        if (user == null || user.getKey() == null) {
            logger.warn("Null user or null user key when evaluating flag: " + this.key + "; returning null");
            return new EvalResult(null, prereqEvents);
        }
        if (this.isOn() && (result = this.evaluate(user, featureStore, prereqEvents, eventFactory)) != null) {
            return new EvalResult(result, prereqEvents);
        }
        return new EvalResult(new VariationAndValue(this.offVariation, this.getOffVariationValue()), prereqEvents);
    }

    private VariationAndValue evaluate(LDUser user, FeatureStore featureStore, List<FeatureRequestEvent> events, EventFactory eventFactory) throws EvaluationException {
        boolean prereqOk = true;
        if (this.prerequisites != null) {
            for (Prerequisite prereq : this.prerequisites) {
                FeatureFlag prereqFeatureFlag = featureStore.get(VersionedDataKind.FEATURES, prereq.getKey());
                VariationAndValue prereqEvalResult = null;
                if (prereqFeatureFlag == null) {
                    logger.error("Could not retrieve prerequisite flag: " + prereq.getKey() + " when evaluating: " + this.key);
                    return null;
                }
                if (prereqFeatureFlag.isOn()) {
                    prereqEvalResult = prereqFeatureFlag.evaluate(user, featureStore, events, eventFactory);
                    if (prereqEvalResult == null || prereqEvalResult.getVariation().intValue() != prereq.getVariation()) {
                        prereqOk = false;
                    }
                } else {
                    prereqOk = false;
                }
                events.add(eventFactory.newPrerequisiteFeatureRequestEvent(prereqFeatureFlag, user, prereqEvalResult, this));
            }
        }
        if (prereqOk) {
            Integer index = this.evaluateIndex(user, featureStore);
            return new VariationAndValue(index, this.getVariation(index));
        }
        return null;
    }

    private Integer evaluateIndex(LDUser user, FeatureStore store) {
        if (this.targets != null) {
            for (Target target : this.targets) {
                for (String v : target.getValues()) {
                    if (!v.equals(user.getKey().getAsString())) continue;
                    return target.getVariation();
                }
            }
        }
        if (this.rules != null) {
            for (Rule rule : this.rules) {
                if (!rule.matchesUser(store, user)) continue;
                return rule.variationIndexForUser(user, this.key, this.salt);
            }
        }
        return this.fallthrough.variationIndexForUser(user, this.key, this.salt);
    }

    JsonElement getOffVariationValue() throws EvaluationException {
        if (this.offVariation == null) {
            return null;
        }
        if (this.offVariation >= this.variations.size()) {
            throw new EvaluationException("Invalid off variation index");
        }
        return this.variations.get(this.offVariation);
    }

    private JsonElement getVariation(Integer index) throws EvaluationException {
        if (index == null) {
            return null;
        }
        if (index >= this.variations.size()) {
            throw new EvaluationException("Invalid index");
        }
        return this.variations.get(index);
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public boolean isTrackEvents() {
        return this.trackEvents;
    }

    public Long getDebugEventsUntilDate() {
        return this.debugEventsUntilDate;
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    boolean isOn() {
        return this.on;
    }

    List<Prerequisite> getPrerequisites() {
        return this.prerequisites;
    }

    String getSalt() {
        return this.salt;
    }

    List<Target> getTargets() {
        return this.targets;
    }

    List<Rule> getRules() {
        return this.rules;
    }

    VariationOrRollout getFallthrough() {
        return this.fallthrough;
    }

    List<JsonElement> getVariations() {
        return this.variations;
    }

    Integer getOffVariation() {
        return this.offVariation;
    }

    static class EvalResult {
        private final VariationAndValue result;
        private final List<FeatureRequestEvent> prerequisiteEvents;

        private EvalResult(VariationAndValue result, List<FeatureRequestEvent> prerequisiteEvents) {
            this.result = result;
            this.prerequisiteEvents = prerequisiteEvents;
        }

        VariationAndValue getResult() {
            return this.result;
        }

        List<FeatureRequestEvent> getPrerequisiteEvents() {
            return this.prerequisiteEvents;
        }
    }

    static class VariationAndValue {
        private final Integer variation;
        private final JsonElement value;

        VariationAndValue(Integer variation, JsonElement value) {
            this.variation = variation;
            this.value = value;
        }

        Integer getVariation() {
            return this.variation;
        }

        JsonElement getValue() {
            return this.value;
        }
    }
}

