/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.google.gson.JsonElement;
import com.launchdarkly.client.FeatureFlag;
import com.launchdarkly.client.Prerequisite;
import com.launchdarkly.client.Rule;
import com.launchdarkly.client.Target;
import com.launchdarkly.client.VariationOrRollout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

class FeatureFlagBuilder {
    private String key;
    private int version;
    private boolean on;
    private List<Prerequisite> prerequisites = new ArrayList<Prerequisite>();
    private String salt;
    private List<Target> targets = new ArrayList<Target>();
    private List<Rule> rules = new ArrayList<Rule>();
    private VariationOrRollout fallthrough;
    private Integer offVariation;
    private List<JsonElement> variations = new ArrayList<JsonElement>();
    private boolean trackEvents;
    private Long debugEventsUntilDate;
    private boolean deleted;

    FeatureFlagBuilder(String key) {
        this.key = key;
    }

    FeatureFlagBuilder(FeatureFlag f) {
        if (f != null) {
            this.key = f.getKey();
            this.version = f.getVersion();
            this.on = f.isOn();
            this.prerequisites = f.getPrerequisites();
            this.salt = f.getSalt();
            this.targets = f.getTargets();
            this.rules = f.getRules();
            this.fallthrough = f.getFallthrough();
            this.offVariation = f.getOffVariation();
            this.variations = f.getVariations();
            this.trackEvents = f.isTrackEvents();
            this.debugEventsUntilDate = f.getDebugEventsUntilDate();
            this.deleted = f.isDeleted();
        }
    }

    FeatureFlagBuilder version(int version) {
        this.version = version;
        return this;
    }

    FeatureFlagBuilder on(boolean on) {
        this.on = on;
        return this;
    }

    FeatureFlagBuilder prerequisites(List<Prerequisite> prerequisites) {
        this.prerequisites = prerequisites;
        return this;
    }

    FeatureFlagBuilder salt(String salt) {
        this.salt = salt;
        return this;
    }

    FeatureFlagBuilder targets(List<Target> targets) {
        this.targets = targets;
        return this;
    }

    FeatureFlagBuilder rules(List<Rule> rules) {
        this.rules = rules;
        return this;
    }

    FeatureFlagBuilder fallthrough(VariationOrRollout fallthrough) {
        this.fallthrough = fallthrough;
        return this;
    }

    FeatureFlagBuilder offVariation(Integer offVariation) {
        this.offVariation = offVariation;
        return this;
    }

    FeatureFlagBuilder variations(List<JsonElement> variations) {
        this.variations = variations;
        return this;
    }

    FeatureFlagBuilder variations(JsonElement ... variations) {
        return this.variations(Arrays.asList(variations));
    }

    FeatureFlagBuilder trackEvents(boolean trackEvents) {
        this.trackEvents = trackEvents;
        return this;
    }

    FeatureFlagBuilder debugEventsUntilDate(Long debugEventsUntilDate) {
        this.debugEventsUntilDate = debugEventsUntilDate;
        return this;
    }

    FeatureFlagBuilder deleted(boolean deleted) {
        this.deleted = deleted;
        return this;
    }

    FeatureFlag build() {
        return new FeatureFlag(this.key, this.version, this.on, this.prerequisites, this.salt, this.targets, this.rules, this.fallthrough, this.offVariation, this.variations, this.trackEvents, this.debugEventsUntilDate, this.deleted);
    }
}

