/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.shaded.redis.clients.jedis;

import com.launchdarkly.shaded.redis.clients.jedis.BinaryShardedJedis;
import com.launchdarkly.shaded.redis.clients.jedis.Client;
import com.launchdarkly.shaded.redis.clients.jedis.Jedis;
import com.launchdarkly.shaded.redis.clients.jedis.PipelineBase;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public class ShardedJedisPipeline
extends PipelineBase {
    private BinaryShardedJedis jedis;
    private List<FutureResult> results = new ArrayList<FutureResult>();
    private Queue<Client> clients = new LinkedList<Client>();

    public void setShardedJedis(BinaryShardedJedis jedis) {
        this.jedis = jedis;
    }

    public List<Object> getResults() {
        ArrayList<Object> r = new ArrayList<Object>();
        for (FutureResult fr : this.results) {
            r.add(fr.get());
        }
        return r;
    }

    public void sync() {
        for (Client client : this.clients) {
            this.generateResponse(client.getOne());
        }
    }

    public List<Object> syncAndReturnAll() {
        ArrayList<Object> formatted = new ArrayList<Object>();
        for (Client client : this.clients) {
            formatted.add(this.generateResponse(client.getOne()).get());
        }
        return formatted;
    }

    @Deprecated
    public void execute() {
    }

    @Override
    protected Client getClient(String key) {
        Client client = ((Jedis)this.jedis.getShard(key)).getClient();
        this.clients.add(client);
        this.results.add(new FutureResult(client));
        return client;
    }

    @Override
    protected Client getClient(byte[] key) {
        Client client = ((Jedis)this.jedis.getShard(key)).getClient();
        this.clients.add(client);
        this.results.add(new FutureResult(client));
        return client;
    }

    private static class FutureResult {
        private Client client;

        public FutureResult(Client client) {
            this.client = client;
        }

        public Object get() {
            return this.client.getOne();
        }
    }
}

