/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.google.gson.JsonElement;
import com.launchdarkly.client.Event;
import com.launchdarkly.client.FeatureFlag;
import com.launchdarkly.client.LDUser;

abstract class EventFactory {
    public static final EventFactory DEFAULT = new DefaultEventFactory();

    EventFactory() {
    }

    protected abstract long getTimestamp();

    public Event.FeatureRequest newFeatureRequestEvent(FeatureFlag flag, LDUser user, FeatureFlag.VariationAndValue result, JsonElement defaultVal) {
        return new Event.FeatureRequest(this.getTimestamp(), flag.getKey(), user, flag.getVersion(), result == null ? null : result.getVariation(), result == null ? null : result.getValue(), defaultVal, null, flag.isTrackEvents(), flag.getDebugEventsUntilDate(), false);
    }

    public Event.FeatureRequest newDefaultFeatureRequestEvent(FeatureFlag flag, LDUser user, JsonElement defaultValue) {
        return new Event.FeatureRequest(this.getTimestamp(), flag.getKey(), user, flag.getVersion(), null, defaultValue, defaultValue, null, flag.isTrackEvents(), flag.getDebugEventsUntilDate(), false);
    }

    public Event.FeatureRequest newUnknownFeatureRequestEvent(String key, LDUser user, JsonElement defaultValue) {
        return new Event.FeatureRequest(this.getTimestamp(), key, user, null, null, defaultValue, defaultValue, null, false, null, false);
    }

    public Event.FeatureRequest newPrerequisiteFeatureRequestEvent(FeatureFlag prereqFlag, LDUser user, FeatureFlag.VariationAndValue result, FeatureFlag prereqOf) {
        return new Event.FeatureRequest(this.getTimestamp(), prereqFlag.getKey(), user, prereqFlag.getVersion(), result == null ? null : result.getVariation(), result == null ? null : result.getValue(), null, prereqOf.getKey(), prereqFlag.isTrackEvents(), prereqFlag.getDebugEventsUntilDate(), false);
    }

    public Event.FeatureRequest newDebugEvent(Event.FeatureRequest from) {
        return new Event.FeatureRequest(from.creationDate, from.key, from.user, from.version, from.variation, from.value, from.defaultVal, from.prereqOf, from.trackEvents, from.debugEventsUntilDate, true);
    }

    public Event.Custom newCustomEvent(String key, LDUser user, JsonElement data) {
        return new Event.Custom(this.getTimestamp(), key, user, data);
    }

    public Event.Identify newIdentifyEvent(LDUser user) {
        return new Event.Identify(this.getTimestamp(), user);
    }

    public static class DefaultEventFactory
    extends EventFactory {
        @Override
        protected long getTimestamp() {
            return System.currentTimeMillis();
        }
    }
}

