/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.client.LDConfig;
import com.launchdarkly.client.LDCountryCode;
import com.launchdarkly.client.UserAttribute;
import com.launchdarkly.shaded.com.google.common.collect.ImmutableMap;
import com.launchdarkly.shaded.com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDUser {
    private final JsonPrimitive key;
    private JsonPrimitive secondary;
    private JsonPrimitive ip;
    private JsonPrimitive email;
    private JsonPrimitive name;
    private JsonPrimitive avatar;
    private JsonPrimitive firstName;
    private JsonPrimitive lastName;
    private JsonPrimitive anonymous;
    private JsonPrimitive country;
    protected Map<String, JsonElement> custom;
    protected transient Set<String> privateAttributeNames;
    private static final Logger logger = LoggerFactory.getLogger(LDUser.class);

    protected LDUser(Builder builder) {
        if (builder.key == null || builder.key.equals("")) {
            logger.warn("User was created with null/empty key");
        }
        this.key = builder.key == null ? null : new JsonPrimitive(builder.key);
        this.ip = builder.ip == null ? null : new JsonPrimitive(builder.ip);
        this.country = builder.country == null ? null : new JsonPrimitive(builder.country.getAlpha2());
        this.secondary = builder.secondary == null ? null : new JsonPrimitive(builder.secondary);
        this.firstName = builder.firstName == null ? null : new JsonPrimitive(builder.firstName);
        this.lastName = builder.lastName == null ? null : new JsonPrimitive(builder.lastName);
        this.email = builder.email == null ? null : new JsonPrimitive(builder.email);
        this.name = builder.name == null ? null : new JsonPrimitive(builder.name);
        this.avatar = builder.avatar == null ? null : new JsonPrimitive(builder.avatar);
        this.anonymous = builder.anonymous == null ? null : new JsonPrimitive(builder.anonymous);
        this.custom = new HashMap<String, JsonElement>(builder.custom);
        this.privateAttributeNames = new HashSet<String>(builder.privateAttrNames);
    }

    public LDUser(String key) {
        this.key = new JsonPrimitive(key);
        this.custom = new HashMap<String, JsonElement>();
        this.privateAttributeNames = new HashSet<String>();
    }

    protected JsonElement getValueForEvaluation(String attribute) {
        for (UserAttribute builtIn : UserAttribute.values()) {
            if (!builtIn.name().equals(attribute)) continue;
            return builtIn.get(this);
        }
        return this.getCustom(attribute);
    }

    JsonPrimitive getKey() {
        return this.key;
    }

    String getKeyAsString() {
        if (this.key == null) {
            return "";
        }
        return this.key.getAsString();
    }

    JsonPrimitive getIp() {
        return this.ip;
    }

    JsonPrimitive getCountry() {
        return this.country;
    }

    JsonPrimitive getSecondary() {
        return this.secondary;
    }

    JsonPrimitive getName() {
        return this.name;
    }

    JsonPrimitive getFirstName() {
        return this.firstName;
    }

    JsonPrimitive getLastName() {
        return this.lastName;
    }

    JsonPrimitive getEmail() {
        return this.email;
    }

    JsonPrimitive getAvatar() {
        return this.avatar;
    }

    JsonPrimitive getAnonymous() {
        return this.anonymous;
    }

    JsonElement getCustom(String key) {
        if (this.custom != null) {
            return this.custom.get(key);
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LDUser ldUser = (LDUser)o;
        if (this.key != null ? !this.key.equals((Object)ldUser.key) : ldUser.key != null) {
            return false;
        }
        if (this.secondary != null ? !this.secondary.equals((Object)ldUser.secondary) : ldUser.secondary != null) {
            return false;
        }
        if (this.ip != null ? !this.ip.equals((Object)ldUser.ip) : ldUser.ip != null) {
            return false;
        }
        if (this.email != null ? !this.email.equals((Object)ldUser.email) : ldUser.email != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals((Object)ldUser.name) : ldUser.name != null) {
            return false;
        }
        if (this.avatar != null ? !this.avatar.equals((Object)ldUser.avatar) : ldUser.avatar != null) {
            return false;
        }
        if (this.firstName != null ? !this.firstName.equals((Object)ldUser.firstName) : ldUser.firstName != null) {
            return false;
        }
        if (this.lastName != null ? !this.lastName.equals((Object)ldUser.lastName) : ldUser.lastName != null) {
            return false;
        }
        if (this.anonymous != null ? !this.anonymous.equals((Object)ldUser.anonymous) : ldUser.anonymous != null) {
            return false;
        }
        if (this.country != null ? !this.country.equals((Object)ldUser.country) : ldUser.country != null) {
            return false;
        }
        if (this.custom != null ? !this.custom.equals(ldUser.custom) : ldUser.custom != null) {
            return false;
        }
        return this.privateAttributeNames != null ? this.privateAttributeNames.equals(ldUser.privateAttributeNames) : ldUser.privateAttributeNames == null;
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + (this.secondary != null ? this.secondary.hashCode() : 0);
        result = 31 * result + (this.ip != null ? this.ip.hashCode() : 0);
        result = 31 * result + (this.email != null ? this.email.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.avatar != null ? this.avatar.hashCode() : 0);
        result = 31 * result + (this.firstName != null ? this.firstName.hashCode() : 0);
        result = 31 * result + (this.lastName != null ? this.lastName.hashCode() : 0);
        result = 31 * result + (this.anonymous != null ? this.anonymous.hashCode() : 0);
        result = 31 * result + (this.country != null ? this.country.hashCode() : 0);
        result = 31 * result + (this.custom != null ? this.custom.hashCode() : 0);
        result = 31 * result + (this.privateAttributeNames != null ? this.privateAttributeNames.hashCode() : 0);
        return result;
    }

    public static class Builder {
        private String key;
        private String secondary;
        private String ip;
        private String firstName;
        private String lastName;
        private String email;
        private String name;
        private String avatar;
        private Boolean anonymous;
        private LDCountryCode country;
        private Map<String, JsonElement> custom;
        private Set<String> privateAttrNames;

        public Builder(String key) {
            this.key = key;
            this.custom = new HashMap<String, JsonElement>();
            this.privateAttrNames = new HashSet<String>();
        }

        public Builder(LDUser user) {
            JsonPrimitive userKey = user.getKey();
            this.key = userKey.isJsonNull() ? null : user.getKeyAsString();
            this.secondary = user.getSecondary() != null ? user.getSecondary().getAsString() : null;
            this.ip = user.getIp() != null ? user.getIp().getAsString() : null;
            this.firstName = user.getFirstName() != null ? user.getFirstName().getAsString() : null;
            this.lastName = user.getLastName() != null ? user.getLastName().getAsString() : null;
            this.email = user.getEmail() != null ? user.getEmail().getAsString() : null;
            this.name = user.getName() != null ? user.getName().getAsString() : null;
            this.avatar = user.getAvatar() != null ? user.getAvatar().getAsString() : null;
            this.anonymous = user.getAnonymous() != null ? Boolean.valueOf(user.getAnonymous().getAsBoolean()) : null;
            this.country = user.getCountry() != null ? LDCountryCode.valueOf(user.getCountry().getAsString()) : null;
            this.custom = ImmutableMap.copyOf(user.custom);
            this.privateAttrNames = ImmutableSet.copyOf(user.privateAttributeNames);
        }

        public Builder ip(String s) {
            this.ip = s;
            return this;
        }

        public Builder privateIp(String s) {
            this.privateAttrNames.add("ip");
            return this.ip(s);
        }

        public Builder secondary(String s) {
            this.secondary = s;
            return this;
        }

        public Builder privateSecondary(String s) {
            this.privateAttrNames.add("secondary");
            return this.secondary(s);
        }

        public Builder country(String s) {
            this.country = LDCountryCode.getByCode(s, false);
            if (this.country == null) {
                List<LDCountryCode> codes = LDCountryCode.findByName("^" + Pattern.quote(s) + ".*");
                if (codes.isEmpty()) {
                    logger.warn("Invalid country. Expected valid ISO-3166-1 code: " + s);
                } else if (codes.size() > 1) {
                    for (LDCountryCode c : codes) {
                        if (!c.getName().equals(s)) continue;
                        this.country = c;
                        return this;
                    }
                    logger.warn("Ambiguous country. Provided code matches multiple countries: " + s);
                    this.country = codes.get(0);
                } else {
                    this.country = codes.get(0);
                }
            }
            return this;
        }

        public Builder privateCountry(String s) {
            this.privateAttrNames.add("country");
            return this.country(s);
        }

        public Builder country(LDCountryCode country) {
            this.country = country;
            return this;
        }

        public Builder privateCountry(LDCountryCode country) {
            this.privateAttrNames.add("country");
            return this.country(country);
        }

        public Builder firstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public Builder privateFirstName(String firstName) {
            this.privateAttrNames.add("firstName");
            return this.firstName(firstName);
        }

        public Builder anonymous(boolean anonymous) {
            this.anonymous = anonymous;
            return this;
        }

        public Builder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public Builder privateLastName(String lastName) {
            this.privateAttrNames.add("lastName");
            return this.lastName(lastName);
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder privateName(String name) {
            this.privateAttrNames.add("name");
            return this.name(name);
        }

        public Builder avatar(String avatar) {
            this.avatar = avatar;
            return this;
        }

        public Builder privateAvatar(String avatar) {
            this.privateAttrNames.add("avatar");
            return this.avatar(avatar);
        }

        public Builder email(String email) {
            this.email = email;
            return this;
        }

        public Builder privateEmail(String email) {
            this.privateAttrNames.add("email");
            return this.email(email);
        }

        public Builder custom(String k, String v) {
            this.checkCustomAttribute(k);
            if (k != null && v != null) {
                this.custom.put(k, (JsonElement)new JsonPrimitive(v));
            }
            return this;
        }

        public Builder custom(String k, Number n) {
            this.checkCustomAttribute(k);
            if (k != null && n != null) {
                this.custom.put(k, (JsonElement)new JsonPrimitive(n));
            }
            return this;
        }

        public Builder custom(String k, Boolean b) {
            this.checkCustomAttribute(k);
            if (k != null && b != null) {
                this.custom.put(k, (JsonElement)new JsonPrimitive(b));
            }
            return this;
        }

        public Builder customString(String k, List<String> vs) {
            this.checkCustomAttribute(k);
            JsonArray array = new JsonArray();
            for (String v : vs) {
                if (v == null) continue;
                array.add((JsonElement)new JsonPrimitive(v));
            }
            this.custom.put(k, (JsonElement)array);
            return this;
        }

        public Builder customNumber(String k, List<Number> vs) {
            this.checkCustomAttribute(k);
            JsonArray array = new JsonArray();
            for (Number v : vs) {
                if (v == null) continue;
                array.add((JsonElement)new JsonPrimitive(v));
            }
            this.custom.put(k, (JsonElement)array);
            return this;
        }

        public Builder customValues(String k, List<JsonElement> vs) {
            this.checkCustomAttribute(k);
            JsonArray array = new JsonArray();
            for (JsonElement v : vs) {
                if (v == null) continue;
                array.add(v);
            }
            this.custom.put(k, (JsonElement)array);
            return this;
        }

        public Builder privateCustom(String k, String v) {
            this.privateAttrNames.add(k);
            return this.custom(k, v);
        }

        public Builder privateCustom(String k, Number n) {
            this.privateAttrNames.add(k);
            return this.custom(k, n);
        }

        public Builder privateCustom(String k, Boolean b) {
            this.privateAttrNames.add(k);
            return this.custom(k, b);
        }

        public Builder privateCustomString(String k, List<String> vs) {
            this.privateAttrNames.add(k);
            return this.customString(k, vs);
        }

        public Builder privateCustomNumber(String k, List<Number> vs) {
            this.privateAttrNames.add(k);
            return this.customNumber(k, vs);
        }

        public Builder privateCustomValues(String k, List<JsonElement> vs) {
            this.privateAttrNames.add(k);
            return this.customValues(k, vs);
        }

        private void checkCustomAttribute(String key) {
            for (UserAttribute a : UserAttribute.values()) {
                if (!a.name().equals(key)) continue;
                logger.warn("Built-in attribute key: " + key + " added as custom attribute! This custom attribute will be ignored during Feature Flag evaluation");
                return;
            }
        }

        public LDUser build() {
            return new LDUser(this);
        }
    }

    static class UserAdapter
    extends TypeAdapter<LDUser> {
        private final LDConfig config;

        public UserAdapter(LDConfig config) {
            this.config = config;
        }

        public void write(JsonWriter out, LDUser user) throws IOException {
            if (user == null) {
                out.value((String)null);
                return;
            }
            HashSet<String> privateAttributeNames = new HashSet<String>(this.config.privateAttrNames);
            out.beginObject();
            out.name("key").value(user.getKeyAsString());
            if (user.getSecondary() != null && !this.checkAndAddPrivate("secondary", user, privateAttributeNames)) {
                out.name("secondary").value(user.getSecondary().getAsString());
            }
            if (user.getIp() != null && !this.checkAndAddPrivate("ip", user, privateAttributeNames)) {
                out.name("ip").value(user.getIp().getAsString());
            }
            if (user.getEmail() != null && !this.checkAndAddPrivate("email", user, privateAttributeNames)) {
                out.name("email").value(user.getEmail().getAsString());
            }
            if (user.getName() != null && !this.checkAndAddPrivate("name", user, privateAttributeNames)) {
                out.name("name").value(user.getName().getAsString());
            }
            if (user.getAvatar() != null && !this.checkAndAddPrivate("avatar", user, privateAttributeNames)) {
                out.name("avatar").value(user.getAvatar().getAsString());
            }
            if (user.getFirstName() != null && !this.checkAndAddPrivate("firstName", user, privateAttributeNames)) {
                out.name("firstName").value(user.getFirstName().getAsString());
            }
            if (user.getLastName() != null && !this.checkAndAddPrivate("lastName", user, privateAttributeNames)) {
                out.name("lastName").value(user.getLastName().getAsString());
            }
            if (user.getAnonymous() != null) {
                out.name("anonymous").value(user.getAnonymous().getAsBoolean());
            }
            if (user.getCountry() != null && !this.checkAndAddPrivate("country", user, privateAttributeNames)) {
                out.name("country").value(user.getCountry().getAsString());
            }
            this.writeCustomAttrs(out, user, privateAttributeNames);
            this.writePrivateAttrNames(out, privateAttributeNames);
            out.endObject();
        }

        private void writePrivateAttrNames(JsonWriter out, Set<String> names) throws IOException {
            if (names.isEmpty()) {
                return;
            }
            out.name("privateAttrs");
            out.beginArray();
            for (String name : names) {
                out.value(name);
            }
            out.endArray();
        }

        private boolean checkAndAddPrivate(String key, LDUser user, Set<String> privateAttrs) {
            boolean result;
            boolean bl = result = this.config.allAttributesPrivate || this.config.privateAttrNames.contains(key) || user.privateAttributeNames != null && user.privateAttributeNames.contains(key);
            if (result) {
                privateAttrs.add(key);
            }
            return result;
        }

        private void writeCustomAttrs(JsonWriter out, LDUser user, Set<String> privateAttributeNames) throws IOException {
            boolean beganObject = false;
            if (user.custom == null) {
                return;
            }
            for (Map.Entry<String, JsonElement> entry : user.custom.entrySet()) {
                if (this.checkAndAddPrivate(entry.getKey(), user, privateAttributeNames)) continue;
                if (!beganObject) {
                    out.name("custom");
                    out.beginObject();
                    beganObject = true;
                }
                out.name(entry.getKey());
                Streams.write((JsonElement)entry.getValue(), (JsonWriter)out);
            }
            if (beganObject) {
                out.endObject();
            }
        }

        public LDUser read(JsonReader in) throws IOException {
            return null;
        }
    }
}

