/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.launchdarkly.client.FeatureStore;
import com.launchdarkly.client.LDUser;
import com.launchdarkly.client.Operator;
import com.launchdarkly.client.Segment;
import com.launchdarkly.client.VersionedDataKind;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Clause {
    private static final Logger logger = LoggerFactory.getLogger(Clause.class);
    private String attribute;
    private Operator op;
    private List<JsonPrimitive> values;
    private boolean negate;

    public Clause() {
    }

    public Clause(String attribute, Operator op, List<JsonPrimitive> values, boolean negate) {
        this.attribute = attribute;
        this.op = op;
        this.values = values;
        this.negate = negate;
    }

    boolean matchesUserNoSegments(LDUser user) {
        JsonElement userValue = user.getValueForEvaluation(this.attribute);
        if (userValue == null) {
            return false;
        }
        if (userValue.isJsonArray()) {
            JsonArray array = userValue.getAsJsonArray();
            for (JsonElement jsonElement : array) {
                if (!jsonElement.isJsonPrimitive()) {
                    logger.error("Invalid custom attribute value in user object: " + jsonElement);
                    return false;
                }
                if (!this.matchAny(jsonElement.getAsJsonPrimitive())) continue;
                return this.maybeNegate(true);
            }
            return this.maybeNegate(false);
        }
        if (userValue.isJsonPrimitive()) {
            return this.maybeNegate(this.matchAny(userValue.getAsJsonPrimitive()));
        }
        logger.warn("Got unexpected user attribute type: " + userValue.getClass().getName() + " for user key: " + user.getKey() + " and attribute: " + this.attribute);
        return false;
    }

    boolean matchesUser(FeatureStore store, LDUser user) {
        if (this.op == Operator.segmentMatch) {
            for (JsonPrimitive j : this.values) {
                Segment segment;
                if (!j.isString() || (segment = store.get(VersionedDataKind.SEGMENTS, j.getAsString())) == null || !segment.matchesUser(user)) continue;
                return this.maybeNegate(true);
            }
            return this.maybeNegate(false);
        }
        return this.matchesUserNoSegments(user);
    }

    private boolean matchAny(JsonPrimitive userValue) {
        if (this.op != null) {
            for (JsonPrimitive v : this.values) {
                if (!this.op.apply(userValue, v)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean maybeNegate(boolean b) {
        if (this.negate) {
            return !b;
        }
        return b;
    }
}

