/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.launchdarkly.client.Event;
import com.launchdarkly.client.EventFactory;
import com.launchdarkly.client.EventOutput;
import com.launchdarkly.client.EventProcessor;
import com.launchdarkly.client.EventSummarizer;
import com.launchdarkly.client.LDConfig;
import com.launchdarkly.client.LDUser;
import com.launchdarkly.client.SimpleLRUCache;
import com.launchdarkly.client.Util;
import com.launchdarkly.shaded.com.google.common.annotations.VisibleForTesting;
import com.launchdarkly.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.launchdarkly.shaded.okhttp3.MediaType;
import com.launchdarkly.shaded.okhttp3.Request;
import com.launchdarkly.shaded.okhttp3.RequestBody;
import com.launchdarkly.shaded.okhttp3.Response;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultEventProcessor
implements EventProcessor {
    private static final Logger logger = LoggerFactory.getLogger(DefaultEventProcessor.class);
    private static final int CHANNEL_BLOCK_MILLIS = 1000;
    private static final String EVENT_SCHEMA_HEADER = "X-LaunchDarkly-Event-Schema";
    private static final String EVENT_SCHEMA_VERSION = "2";
    private final BlockingQueue<EventProcessorMessage> inputChannel;
    private final ScheduledExecutorService scheduler;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final AtomicBoolean inputCapacityExceeded = new AtomicBoolean(false);

    DefaultEventProcessor(String sdkKey, LDConfig config) {
        this.inputChannel = new ArrayBlockingQueue<EventProcessorMessage>(config.capacity);
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("LaunchDarkly-EventProcessor-%d").build();
        this.scheduler = Executors.newSingleThreadScheduledExecutor(threadFactory);
        new EventDispatcher(sdkKey, config, this.inputChannel, threadFactory);
        Runnable flusher = new Runnable(){

            @Override
            public void run() {
                DefaultEventProcessor.this.postMessageAsync(MessageType.FLUSH, null);
            }
        };
        this.scheduler.scheduleAtFixedRate(flusher, config.flushInterval, config.flushInterval, TimeUnit.SECONDS);
        Runnable userKeysFlusher = new Runnable(){

            @Override
            public void run() {
                DefaultEventProcessor.this.postMessageAsync(MessageType.FLUSH_USERS, null);
            }
        };
        this.scheduler.scheduleAtFixedRate(userKeysFlusher, config.userKeysFlushInterval, config.userKeysFlushInterval, TimeUnit.SECONDS);
    }

    @Override
    public void sendEvent(Event e) {
        if (!this.closed.get()) {
            this.postMessageAsync(MessageType.EVENT, e);
        }
    }

    @Override
    public void flush() {
        if (!this.closed.get()) {
            this.postMessageAsync(MessageType.FLUSH, null);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            this.scheduler.shutdown();
            this.postMessageAsync(MessageType.FLUSH, null);
            this.postMessageAndWait(MessageType.SHUTDOWN, null);
        }
    }

    @VisibleForTesting
    void waitUntilInactive() throws IOException {
        this.postMessageAndWait(MessageType.SYNC, null);
    }

    private void postMessageAsync(MessageType type, Event event) {
        this.postToChannel(new EventProcessorMessage(type, event, false));
    }

    private void postMessageAndWait(MessageType type, Event event) {
        EventProcessorMessage message = new EventProcessorMessage(type, event, true);
        this.postToChannel(message);
        message.waitForCompletion();
    }

    private void postToChannel(EventProcessorMessage message) {
        block2: while (true) {
            try {
                while (true) {
                    if (this.inputChannel.offer(message, 1000L, TimeUnit.MILLISECONDS)) {
                        this.inputCapacityExceeded.set(false);
                        break block2;
                    }
                    if (!this.inputCapacityExceeded.compareAndSet(false, true)) continue;
                    logger.warn("Events are being produced faster than they can be processed");
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private static final class SendEventsTask
    implements Runnable {
        private final String sdkKey;
        private final LDConfig config;
        private final EventResponseListener responseListener;
        private final BlockingQueue<FlushPayload> payloadQueue;
        private final AtomicInteger activeFlushWorkersCount;
        private final AtomicBoolean stopping;
        private final EventOutput.Formatter formatter;
        private final Thread thread;

        SendEventsTask(String sdkKey, LDConfig config, EventResponseListener responseListener, BlockingQueue<FlushPayload> payloadQueue, AtomicInteger activeFlushWorkersCount, ThreadFactory threadFactory) {
            this.sdkKey = sdkKey;
            this.config = config;
            this.formatter = new EventOutput.Formatter(config.inlineUsersInEvents);
            this.responseListener = responseListener;
            this.payloadQueue = payloadQueue;
            this.activeFlushWorkersCount = activeFlushWorkersCount;
            this.stopping = new AtomicBoolean(false);
            this.thread = threadFactory.newThread(this);
            this.thread.setDaemon(true);
            this.thread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.stopping.get()) {
                FlushPayload payload = null;
                try {
                    payload = this.payloadQueue.take();
                }
                catch (InterruptedException e) {
                    continue;
                }
                try {
                    List<EventOutput> eventsOut = this.formatter.makeOutputEvents(payload.events, payload.summary);
                    if (!eventsOut.isEmpty()) {
                        this.postEvents(eventsOut);
                    }
                }
                catch (Exception e) {
                    logger.error("Unexpected error in event processor: " + e);
                    logger.debug(e.getMessage(), (Throwable)e);
                }
                AtomicInteger atomicInteger = this.activeFlushWorkersCount;
                synchronized (atomicInteger) {
                    this.activeFlushWorkersCount.decrementAndGet();
                    this.activeFlushWorkersCount.notifyAll();
                }
            }
        }

        void stop() {
            this.stopping.set(true);
            this.thread.interrupt();
        }

        private void postEvents(List<EventOutput> eventsOut) {
            String json = this.config.gson.toJson(eventsOut);
            String uriStr = this.config.eventsURI.toString() + "/bulk";
            logger.debug("Posting {} event(s) to {} with payload: {}", new Object[]{eventsOut.size(), uriStr, json});
            for (int attempt = 0; attempt < 2; ++attempt) {
                if (attempt > 0) {
                    logger.warn("Will retry posting events after 1 second");
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                Request request = Util.getRequestBuilder(this.sdkKey).url(uriStr).post(RequestBody.create(MediaType.parse("application/json; charset=utf-8"), json)).addHeader("Content-Type", "application/json").addHeader(DefaultEventProcessor.EVENT_SCHEMA_HEADER, DefaultEventProcessor.EVENT_SCHEMA_VERSION).build();
                long startTime = System.currentTimeMillis();
                try (Response response = this.config.httpClient.newCall(request).execute();){
                    long endTime = System.currentTimeMillis();
                    logger.debug("Event delivery took {} ms, response status {}", (Object)(endTime - startTime), (Object)response.code());
                    if (!response.isSuccessful()) {
                        logger.warn("Unexpected response status when posting events: {}", (Object)response.code());
                        if (Util.isHttpErrorRecoverable(response.code())) continue;
                    }
                    this.responseListener.handleResponse(response);
                    break;
                }
                catch (IOException e) {
                    logger.warn("Unhandled exception in LaunchDarkly client when posting events to URL: " + request.url(), (Throwable)e);
                }
            }
        }
    }

    private static interface EventResponseListener {
        public void handleResponse(Response var1);
    }

    private static final class FlushPayload {
        final Event[] events;
        final EventSummarizer.EventSummary summary;

        FlushPayload(Event[] events, EventSummarizer.EventSummary summary) {
            this.events = events;
            this.summary = summary;
        }
    }

    private static final class EventBuffer {
        final List<Event> events = new ArrayList<Event>();
        final EventSummarizer summarizer = new EventSummarizer();
        private final int capacity;
        private boolean capacityExceeded = false;

        EventBuffer(int capacity) {
            this.capacity = capacity;
        }

        void add(Event e) {
            if (this.events.size() >= this.capacity) {
                if (!this.capacityExceeded) {
                    this.capacityExceeded = true;
                    logger.warn("Exceeded event queue capacity. Increase capacity to avoid dropping events.");
                }
            } else {
                this.capacityExceeded = false;
                this.events.add(e);
            }
        }

        void addToSummary(Event e) {
            this.summarizer.summarizeEvent(e);
        }

        boolean isEmpty() {
            return this.events.isEmpty() && this.summarizer.snapshot().isEmpty();
        }

        FlushPayload getPayload() {
            Event[] eventsOut = this.events.toArray(new Event[this.events.size()]);
            EventSummarizer.EventSummary summary = this.summarizer.snapshot();
            return new FlushPayload(eventsOut, summary);
        }

        void clear() {
            this.events.clear();
            this.summarizer.clear();
        }
    }

    static final class EventDispatcher {
        private static final int MAX_FLUSH_THREADS = 5;
        static final SimpleDateFormat HTTP_DATE_FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
        private final LDConfig config;
        private final List<SendEventsTask> flushWorkers;
        private final AtomicInteger busyFlushWorkersCount;
        private final Random random = new Random();
        private final AtomicLong lastKnownPastTime = new AtomicLong(0L);
        private final AtomicBoolean disabled = new AtomicBoolean(false);

        private EventDispatcher(String sdkKey, LDConfig config, final BlockingQueue<EventProcessorMessage> inputChannel, ThreadFactory threadFactory) {
            this.config = config;
            this.busyFlushWorkersCount = new AtomicInteger(0);
            final ArrayBlockingQueue<FlushPayload> payloadQueue = new ArrayBlockingQueue<FlushPayload>(1);
            final EventBuffer buffer = new EventBuffer(config.capacity);
            final SimpleLRUCache userKeys = new SimpleLRUCache(config.userKeysCapacity);
            Thread mainThread = threadFactory.newThread(new Runnable(){

                @Override
                public void run() {
                    EventDispatcher.this.runMainLoop(inputChannel, buffer, userKeys, payloadQueue);
                }
            });
            mainThread.setDaemon(true);
            mainThread.start();
            this.flushWorkers = new ArrayList<SendEventsTask>();
            EventResponseListener listener = new EventResponseListener(){

                @Override
                public void handleResponse(Response response) {
                    EventDispatcher.this.handleResponse(response);
                }
            };
            for (int i = 0; i < 5; ++i) {
                SendEventsTask task = new SendEventsTask(sdkKey, config, listener, payloadQueue, this.busyFlushWorkersCount, threadFactory);
                this.flushWorkers.add(task);
            }
        }

        private void runMainLoop(BlockingQueue<EventProcessorMessage> inputChannel, EventBuffer buffer, SimpleLRUCache<String, String> userKeys, BlockingQueue<FlushPayload> payloadQueue) {
            while (true) {
                try {
                    while (true) {
                        EventProcessorMessage message = inputChannel.take();
                        switch (message.type) {
                            case EVENT: {
                                this.processEvent(message.event, userKeys, buffer);
                                break;
                            }
                            case FLUSH: {
                                this.triggerFlush(buffer, payloadQueue);
                                break;
                            }
                            case FLUSH_USERS: {
                                userKeys.clear();
                                break;
                            }
                            case SYNC: {
                                this.waitUntilAllFlushWorkersInactive();
                                message.completed();
                                break;
                            }
                            case SHUTDOWN: {
                                this.doShutdown();
                                message.completed();
                                return;
                            }
                        }
                        message.completed();
                    }
                }
                catch (InterruptedException message) {
                    continue;
                }
                catch (Exception e) {
                    logger.error("Unexpected error in event processor: " + e);
                    logger.debug(e.getMessage(), (Throwable)e);
                    continue;
                }
                break;
            }
        }

        private void doShutdown() {
            this.waitUntilAllFlushWorkersInactive();
            this.disabled.set(true);
            for (SendEventsTask task : this.flushWorkers) {
                task.stop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void waitUntilAllFlushWorkersInactive() {
            while (true) {
                try {
                    while (true) {
                        AtomicInteger atomicInteger = this.busyFlushWorkersCount;
                        synchronized (atomicInteger) {
                            if (this.busyFlushWorkersCount.get() == 0) {
                                return;
                            }
                            this.busyFlushWorkersCount.wait();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        private void processEvent(Event e, SimpleLRUCache<String, String> userKeys, EventBuffer buffer) {
            if (this.disabled.get()) {
                return;
            }
            buffer.addToSummary(e);
            boolean addIndexEvent = false;
            boolean addFullEvent = false;
            Event.FeatureRequest debugEvent = null;
            if (e instanceof Event.FeatureRequest) {
                if (this.shouldSampleEvent()) {
                    Event.FeatureRequest fe = (Event.FeatureRequest)e;
                    addFullEvent = fe.trackEvents;
                    if (this.shouldDebugEvent(fe)) {
                        debugEvent = EventFactory.DEFAULT.newDebugEvent(fe);
                    }
                }
            } else {
                addFullEvent = this.shouldSampleEvent();
            }
            if (!(addFullEvent && this.config.inlineUsersInEvents || e.user == null || e.user.getKey() == null || this.noticeUser(e.user, userKeys) || e instanceof Event.Identify)) {
                addIndexEvent = true;
            }
            if (addIndexEvent) {
                Event.Index ie = new Event.Index(e.creationDate, e.user);
                buffer.add(ie);
            }
            if (addFullEvent) {
                buffer.add(e);
            }
            if (debugEvent != null) {
                buffer.add(debugEvent);
            }
        }

        private boolean noticeUser(LDUser user, SimpleLRUCache<String, String> userKeys) {
            if (user == null || user.getKey() == null) {
                return false;
            }
            String key = user.getKeyAsString();
            return userKeys.put(key, key) != null;
        }

        private boolean shouldSampleEvent() {
            return this.config.samplingInterval <= 0 || this.random.nextInt(this.config.samplingInterval) == 0;
        }

        private boolean shouldDebugEvent(Event.FeatureRequest fe) {
            if (fe.debugEventsUntilDate != null) {
                long lastPast = this.lastKnownPastTime.get();
                if (fe.debugEventsUntilDate > lastPast && fe.debugEventsUntilDate > System.currentTimeMillis()) {
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void triggerFlush(EventBuffer buffer, BlockingQueue<FlushPayload> payloadQueue) {
            if (this.disabled.get() || buffer.isEmpty()) {
                return;
            }
            FlushPayload payload = buffer.getPayload();
            this.busyFlushWorkersCount.incrementAndGet();
            if (payloadQueue.offer(payload)) {
                buffer.clear();
            } else {
                logger.debug("Skipped flushing because all workers are busy");
                AtomicInteger atomicInteger = this.busyFlushWorkersCount;
                synchronized (atomicInteger) {
                    this.busyFlushWorkersCount.decrementAndGet();
                    this.busyFlushWorkersCount.notify();
                }
            }
        }

        private void handleResponse(Response response) {
            String dateStr = response.header("Date");
            if (dateStr != null) {
                try {
                    this.lastKnownPastTime.set(HTTP_DATE_FORMAT.parse(dateStr).getTime());
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            if (!Util.isHttpErrorRecoverable(response.code())) {
                this.disabled.set(true);
                logger.error(Util.httpErrorMessage(response.code(), "posting events", "some events were dropped"));
            }
        }
    }

    private static final class EventProcessorMessage {
        private final MessageType type;
        private final Event event;
        private final Semaphore reply;

        private EventProcessorMessage(MessageType type, Event event, boolean sync) {
            this.type = type;
            this.event = event;
            this.reply = sync ? new Semaphore(0) : null;
        }

        void completed() {
            if (this.reply != null) {
                this.reply.release();
            }
        }

        void waitForCompletion() {
            if (this.reply == null) {
                return;
            }
            while (true) {
                try {
                    this.reply.acquire();
                    return;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        public String toString() {
            return (this.event == null ? this.type.toString() : (Object)((Object)this.type) + ": " + this.event.getClass().getSimpleName()) + (this.reply == null ? "" : " (sync)");
        }
    }

    private static enum MessageType {
        EVENT,
        FLUSH,
        FLUSH_USERS,
        SYNC,
        SHUTDOWN;

    }
}

