/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.google.gson.JsonElement;
import com.google.gson.annotations.SerializedName;
import com.launchdarkly.client.Event;
import com.launchdarkly.client.EventSummarizer;
import com.launchdarkly.client.LDUser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

abstract class EventOutput {
    private final String kind;

    protected EventOutput(String kind) {
        this.kind = kind;
    }

    static final class Formatter {
        private final boolean inlineUsers;

        Formatter(boolean inlineUsers) {
            this.inlineUsers = inlineUsers;
        }

        List<EventOutput> makeOutputEvents(Event[] events, EventSummarizer.EventSummary summary) {
            ArrayList<EventOutput> eventsOut = new ArrayList<EventOutput>(events.length + 1);
            for (Event event : events) {
                eventsOut.add(this.createOutputEvent(event));
            }
            if (!summary.isEmpty()) {
                eventsOut.add(this.createSummaryEvent(summary));
            }
            return eventsOut;
        }

        private EventOutput createOutputEvent(Event e) {
            String userKey;
            String string = userKey = e.user == null ? null : e.user.getKeyAsString();
            if (e instanceof Event.FeatureRequest) {
                Event.FeatureRequest fe = (Event.FeatureRequest)e;
                boolean inlineThisUser = this.inlineUsers || fe.debug;
                return new FeatureRequest(fe.creationDate, fe.key, inlineThisUser ? null : userKey, inlineThisUser ? e.user : null, fe.version, fe.variation, fe.value, fe.defaultVal, fe.prereqOf, fe.debug);
            }
            if (e instanceof Event.Identify) {
                return new Identify(e.creationDate, e.user);
            }
            if (e instanceof Event.Custom) {
                Event.Custom ce = (Event.Custom)e;
                return new Custom(ce.creationDate, ce.key, this.inlineUsers ? null : userKey, this.inlineUsers ? e.user : null, ce.data);
            }
            if (e instanceof Event.Index) {
                return new Index(e.creationDate, e.user);
            }
            return null;
        }

        private EventOutput createSummaryEvent(EventSummarizer.EventSummary summary) {
            HashMap<String, SummaryEventFlag> flagsOut = new HashMap<String, SummaryEventFlag>();
            for (Map.Entry<EventSummarizer.CounterKey, EventSummarizer.CounterValue> entry : summary.counters.entrySet()) {
                SummaryEventFlag fsd = (SummaryEventFlag)flagsOut.get(entry.getKey().key);
                if (fsd == null) {
                    fsd = new SummaryEventFlag(entry.getValue().defaultVal, new ArrayList<SummaryEventCounter>());
                    flagsOut.put(entry.getKey().key, fsd);
                }
                SummaryEventCounter c = new SummaryEventCounter(entry.getKey().variation, entry.getValue().flagValue, entry.getKey().version, entry.getValue().count, entry.getKey().version == null ? Boolean.valueOf(true) : null);
                fsd.counters.add(c);
            }
            return new Summary(summary.startDate, summary.endDate, flagsOut);
        }
    }

    static final class SummaryEventCounter {
        final Integer variation;
        final JsonElement value;
        final Integer version;
        final int count;
        final Boolean unknown;

        SummaryEventCounter(Integer variation, JsonElement value, Integer version, int count, Boolean unknown) {
            this.variation = variation;
            this.value = value;
            this.version = version;
            this.count = count;
            this.unknown = unknown;
        }
    }

    static final class SummaryEventFlag {
        @SerializedName(value="default")
        final JsonElement defaultVal;
        final List<SummaryEventCounter> counters;

        SummaryEventFlag(JsonElement defaultVal, List<SummaryEventCounter> counters) {
            this.defaultVal = defaultVal;
            this.counters = counters;
        }
    }

    static final class Summary
    extends EventOutput {
        private final long startDate;
        private final long endDate;
        private final Map<String, SummaryEventFlag> features;

        Summary(long startDate, long endDate, Map<String, SummaryEventFlag> features) {
            super("summary");
            this.startDate = startDate;
            this.endDate = endDate;
            this.features = features;
        }
    }

    static final class Index
    extends EventOutputWithTimestamp {
        private final LDUser user;

        public Index(long creationDate, LDUser user) {
            super("index", creationDate);
            this.user = user;
        }
    }

    static final class Custom
    extends EventOutputWithTimestamp {
        private final String key;
        private final String userKey;
        private final LDUser user;
        private final JsonElement data;

        Custom(long creationDate, String key, String userKey, LDUser user, JsonElement data) {
            super("custom", creationDate);
            this.key = key;
            this.userKey = userKey;
            this.user = user;
            this.data = data;
        }
    }

    static final class Identify
    extends EventOutputWithTimestamp {
        private final LDUser user;
        private final String key;

        Identify(long creationDate, LDUser user) {
            super("identify", creationDate);
            this.user = user;
            this.key = user.getKeyAsString();
        }
    }

    static final class FeatureRequest
    extends EventOutputWithTimestamp {
        private final String key;
        private final String userKey;
        private final LDUser user;
        private final Integer version;
        private final Integer variation;
        private final JsonElement value;
        @SerializedName(value="default")
        private final JsonElement defaultVal;
        private final String prereqOf;

        FeatureRequest(long creationDate, String key, String userKey, LDUser user, Integer version, Integer variation, JsonElement value, JsonElement defaultVal, String prereqOf, boolean debug) {
            super(debug ? "debug" : "feature", creationDate);
            this.key = key;
            this.userKey = userKey;
            this.user = user;
            this.variation = variation;
            this.version = version;
            this.value = value;
            this.defaultVal = defaultVal;
            this.prereqOf = prereqOf;
        }
    }

    static class EventOutputWithTimestamp
    extends EventOutput {
        private final long creationDate;

        protected EventOutputWithTimestamp(String kind, long creationDate) {
            super(kind);
            this.creationDate = creationDate;
        }
    }
}

