/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.launchdarkly.client.FeatureStoreFactory;
import com.launchdarkly.client.RedisFeatureStore;
import com.launchdarkly.shaded.redis.clients.jedis.JedisPoolConfig;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RedisFeatureStoreBuilder
implements FeatureStoreFactory {
    private static final Logger logger = LoggerFactory.getLogger(RedisFeatureStoreBuilder.class);
    public static final URI DEFAULT_URI = URI.create("com/launchdarkly/shaded/redis://localhost:6379");
    public static final String DEFAULT_PREFIX = "launchdarkly";
    public static final long DEFAULT_CACHE_TIME_SECONDS = 15L;
    final URI uri;
    boolean refreshStaleValues = false;
    boolean asyncRefresh = false;
    String prefix = "launchdarkly";
    int connectTimeout = 2000;
    int socketTimeout = 2000;
    long cacheTimeSecs = 15L;
    JedisPoolConfig poolConfig = null;

    RedisFeatureStoreBuilder() {
        this.uri = DEFAULT_URI;
    }

    RedisFeatureStoreBuilder(URI uri) {
        this.uri = uri;
    }

    public RedisFeatureStoreBuilder(URI uri, long cacheTimeSecs) {
        this.uri = uri;
        this.cacheTime(cacheTimeSecs, TimeUnit.SECONDS);
    }

    public RedisFeatureStoreBuilder(String scheme, String host, int port, long cacheTimeSecs) throws URISyntaxException {
        this.uri = new URI(scheme, null, host, port, null, null, null);
        this.cacheTime(cacheTimeSecs, TimeUnit.SECONDS);
    }

    public RedisFeatureStoreBuilder refreshStaleValues(boolean enabled) {
        this.refreshStaleValues = enabled;
        return this;
    }

    public RedisFeatureStoreBuilder asyncRefresh(boolean enabled) {
        this.asyncRefresh = enabled;
        return this;
    }

    public RedisFeatureStoreBuilder prefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public RedisFeatureStoreBuilder cacheTime(long cacheTime, TimeUnit timeUnit) {
        this.cacheTimeSecs = timeUnit.toSeconds(cacheTime);
        return this;
    }

    public RedisFeatureStoreBuilder poolConfig(JedisPoolConfig poolConfig) {
        this.poolConfig = poolConfig;
        return this;
    }

    public RedisFeatureStoreBuilder connectTimeout(int connectTimeout, TimeUnit timeUnit) {
        this.connectTimeout = (int)timeUnit.toMillis(connectTimeout);
        return this;
    }

    public RedisFeatureStoreBuilder socketTimeout(int socketTimeout, TimeUnit timeUnit) {
        this.socketTimeout = (int)timeUnit.toMillis(socketTimeout);
        return this;
    }

    public RedisFeatureStore build() {
        logger.info("Creating RedisFeatureStore with uri: " + this.uri + " and prefix: " + this.prefix);
        return new RedisFeatureStore(this);
    }

    @Override
    public RedisFeatureStore createFeatureStore() {
        return this.build();
    }
}

