/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.shaded.com.launchdarkly.client.files;

import com.google.gson.JsonElement;
import com.launchdarkly.client.VersionedDataKind;
import com.launchdarkly.shaded.com.launchdarkly.client.files.DataBuilder;
import com.launchdarkly.shaded.com.launchdarkly.client.files.DataLoaderException;
import com.launchdarkly.shaded.com.launchdarkly.client.files.FlagFactory;
import com.launchdarkly.shaded.com.launchdarkly.client.files.FlagFileParser;
import com.launchdarkly.shaded.com.launchdarkly.client.files.FlagFileRep;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

final class DataLoader {
    private final List<Path> files;

    public DataLoader(List<Path> files) {
        this.files = new ArrayList<Path>(files);
    }

    public Iterable<Path> getFiles() {
        return this.files;
    }

    public void load(DataBuilder builder) throws DataLoaderException {
        for (Path p : this.files) {
            try {
                byte[] data = Files.readAllBytes(p);
                FlagFileParser parser = FlagFileParser.selectForContent(data);
                FlagFileRep fileContents = parser.parse(new ByteArrayInputStream(data));
                if (fileContents.flags != null) {
                    for (Map.Entry<String, JsonElement> e : fileContents.flags.entrySet()) {
                        builder.add(VersionedDataKind.FEATURES, FlagFactory.flagFromJson(e.getValue()));
                    }
                }
                if (fileContents.flagValues != null) {
                    for (Map.Entry<String, JsonElement> e : fileContents.flagValues.entrySet()) {
                        builder.add(VersionedDataKind.FEATURES, FlagFactory.flagWithValue(e.getKey(), e.getValue()));
                    }
                }
                if (fileContents.segments == null) continue;
                for (Map.Entry<String, JsonElement> e : fileContents.segments.entrySet()) {
                    builder.add(VersionedDataKind.SEGMENTS, FlagFactory.segmentFromJson(e.getValue()));
                }
            }
            catch (DataLoaderException e) {
                throw new DataLoaderException(e.getMessage(), e.getCause(), p);
            }
            catch (IOException e) {
                throw new DataLoaderException(null, e, p);
            }
        }
    }
}

