/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.shaded.com.launchdarkly.client.files;

import com.launchdarkly.client.FeatureStore;
import com.launchdarkly.client.LDConfig;
import com.launchdarkly.client.UpdateProcessor;
import com.launchdarkly.client.UpdateProcessorFactory;
import com.launchdarkly.shaded.com.launchdarkly.client.files.DataLoader;
import com.launchdarkly.shaded.com.launchdarkly.client.files.FileDataSource;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public class FileDataSourceFactory
implements UpdateProcessorFactory {
    private final List<Path> sources = new ArrayList<Path>();
    private boolean autoUpdate = false;

    public FileDataSourceFactory filePaths(String ... filePaths) throws InvalidPathException {
        for (String p : filePaths) {
            this.sources.add(Paths.get(p, new String[0]));
        }
        return this;
    }

    public FileDataSourceFactory filePaths(Path ... filePaths) {
        for (Path p : filePaths) {
            this.sources.add(p);
        }
        return this;
    }

    public FileDataSourceFactory autoUpdate(boolean autoUpdate) {
        this.autoUpdate = autoUpdate;
        return this;
    }

    @Override
    public UpdateProcessor createUpdateProcessor(String sdkKey, LDConfig config, FeatureStore featureStore) {
        return new FileDataSource(featureStore, new DataLoader(this.sources), this.autoUpdate);
    }
}

