/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.google.gson.JsonPrimitive;
import com.launchdarkly.client.SemanticVersion;
import com.launchdarkly.client.Util;

enum OperandType {
    string,
    number,
    date,
    semVer;


    public static OperandType bestGuess(JsonPrimitive value) {
        return value.isNumber() ? number : string;
    }

    public Object getValueAsType(JsonPrimitive value) {
        switch (this) {
            case string: {
                return value.getAsString();
            }
            case number: {
                if (value.isNumber()) {
                    try {
                        return value.getAsDouble();
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                return null;
            }
            case date: {
                return Util.jsonPrimitiveToDateTime(value);
            }
            case semVer: {
                try {
                    return SemanticVersion.parse(value.getAsString(), true);
                }
                catch (SemanticVersion.InvalidVersionException e) {
                    return null;
                }
            }
        }
        return null;
    }
}

