/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.launchdarkly.client.EvaluationReason;
import com.launchdarkly.shaded.com.google.common.base.Objects;

public class EvaluationDetail<T> {
    private final EvaluationReason reason;
    private final Integer variationIndex;
    private final T value;

    public EvaluationDetail(EvaluationReason reason, Integer variationIndex, T value) {
        this.reason = reason;
        this.variationIndex = variationIndex;
        this.value = value;
    }

    static <T> EvaluationDetail<T> error(EvaluationReason.ErrorKind errorKind, T defaultValue) {
        return new EvaluationDetail<T>(EvaluationReason.error(errorKind), null, defaultValue);
    }

    public EvaluationReason getReason() {
        return this.reason;
    }

    public Integer getVariationIndex() {
        return this.variationIndex;
    }

    public T getValue() {
        return this.value;
    }

    public boolean isDefaultValue() {
        return this.variationIndex == null;
    }

    public boolean equals(Object other) {
        if (other instanceof EvaluationDetail) {
            EvaluationDetail o = (EvaluationDetail)other;
            return Objects.equal(this.reason, o.reason) && Objects.equal(this.variationIndex, o.variationIndex) && Objects.equal(this.value, o.value);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.reason, this.variationIndex, this.value);
    }

    public String toString() {
        return "{" + this.reason + "," + this.variationIndex + "," + this.value + "}";
    }
}

