/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.launchdarkly.client.FeatureStore;
import com.launchdarkly.client.VersionedData;
import com.launchdarkly.client.VersionedDataKind;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryFeatureStore
implements FeatureStore {
    private static final Logger logger = LoggerFactory.getLogger(InMemoryFeatureStore.class);
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final Map<VersionedDataKind<?>, Map<String, VersionedData>> allData = new HashMap();
    private volatile boolean initialized = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends VersionedData> T get(VersionedDataKind<T> kind, String key) {
        try {
            this.lock.readLock().lock();
            Map<String, VersionedData> items = this.allData.get(kind);
            if (items == null) {
                logger.debug("[get] no objects exist for \"{}\". Returning null", (Object)kind.getNamespace());
                T t = null;
                return t;
            }
            VersionedData o = items.get(key);
            if (o == null) {
                logger.debug("[get] Key: {} not found in \"{}\". Returning null", (Object)key, (Object)kind.getNamespace());
                T t = null;
                return t;
            }
            if (!kind.getItemClass().isInstance(o)) {
                logger.warn("[get] Unexpected object class {} found for key: {} in \"{}\". Returning null", new Object[]{o.getClass().getName(), key, kind.getNamespace()});
                T t = null;
                return t;
            }
            VersionedData item = (VersionedData)kind.getItemClass().cast(o);
            if (item.isDeleted()) {
                logger.debug("[get] Key: {} has been deleted. Returning null", (Object)key);
                T t = null;
                return t;
            }
            logger.debug("[get] Key: {} with version: {} found in \"{}\".", new Object[]{key, item.getVersion(), kind.getNamespace()});
            VersionedData versionedData = item;
            return (T)versionedData;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends VersionedData> Map<String, T> all(VersionedDataKind<T> kind) {
        try {
            this.lock.readLock().lock();
            HashMap fs = new HashMap();
            Map<String, VersionedData> items = this.allData.get(kind);
            if (items != null) {
                for (Map.Entry entry : items.entrySet()) {
                    if (((VersionedData)entry.getValue()).isDeleted()) continue;
                    fs.put(entry.getKey(), kind.getItemClass().cast(entry.getValue()));
                }
            }
            HashMap hashMap = fs;
            return hashMap;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(Map<VersionedDataKind<?>, Map<String, ? extends VersionedData>> allData) {
        try {
            this.lock.writeLock().lock();
            this.allData.clear();
            for (Map.Entry<VersionedDataKind<?>, Map<String, VersionedData>> entry : allData.entrySet()) {
                this.allData.put(entry.getKey(), new HashMap<String, VersionedData>(entry.getValue()));
            }
            this.initialized = true;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends VersionedData> void delete(VersionedDataKind<T> kind, String key, int version) {
        try {
            VersionedData item;
            this.lock.writeLock().lock();
            Map<String, VersionedData> items = this.allData.get(kind);
            if (items == null) {
                items = new HashMap<String, VersionedData>();
                this.allData.put(kind, items);
            }
            if ((item = items.get(key)) == null || item.getVersion() < version) {
                items.put(key, (VersionedData)kind.makeDeletedItem(key, version));
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends VersionedData> void upsert(VersionedDataKind<T> kind, T item) {
        try {
            VersionedData old;
            this.lock.writeLock().lock();
            Map<String, VersionedData> items = this.allData.get(kind);
            if (items == null) {
                items = new HashMap<String, VersionedData>();
                this.allData.put(kind, items);
            }
            if ((old = items.get(item.getKey())) == null || old.getVersion() < item.getVersion()) {
                items.put(item.getKey(), item);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean initialized() {
        return this.initialized;
    }

    @Override
    public void close() throws IOException {
    }
}

