/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.google.gson.JsonElement;
import com.launchdarkly.client.EvaluationDetail;
import com.launchdarkly.client.EvaluationReason;
import com.launchdarkly.client.Event;
import com.launchdarkly.client.FeatureFlag;
import com.launchdarkly.client.LDUser;

abstract class EventFactory {
    public static final EventFactory DEFAULT = new DefaultEventFactory(false);
    public static final EventFactory DEFAULT_WITH_REASONS = new DefaultEventFactory(true);

    EventFactory() {
    }

    protected abstract long getTimestamp();

    protected abstract boolean isIncludeReasons();

    public Event.FeatureRequest newFeatureRequestEvent(FeatureFlag flag, LDUser user, EvaluationDetail<JsonElement> result, JsonElement defaultVal) {
        return new Event.FeatureRequest(this.getTimestamp(), flag.getKey(), user, flag.getVersion(), result == null ? null : result.getVariationIndex(), result == null ? null : result.getValue(), defaultVal, null, flag.isTrackEvents(), flag.getDebugEventsUntilDate(), this.isIncludeReasons() ? result.getReason() : null, false);
    }

    public Event.FeatureRequest newDefaultFeatureRequestEvent(FeatureFlag flag, LDUser user, JsonElement defaultValue, EvaluationReason.ErrorKind errorKind) {
        return new Event.FeatureRequest(this.getTimestamp(), flag.getKey(), user, flag.getVersion(), null, defaultValue, defaultValue, null, flag.isTrackEvents(), flag.getDebugEventsUntilDate(), this.isIncludeReasons() ? EvaluationReason.error(errorKind) : null, false);
    }

    public Event.FeatureRequest newUnknownFeatureRequestEvent(String key, LDUser user, JsonElement defaultValue, EvaluationReason.ErrorKind errorKind) {
        return new Event.FeatureRequest(this.getTimestamp(), key, user, null, null, defaultValue, defaultValue, null, false, null, this.isIncludeReasons() ? EvaluationReason.error(errorKind) : null, false);
    }

    public Event.FeatureRequest newPrerequisiteFeatureRequestEvent(FeatureFlag prereqFlag, LDUser user, EvaluationDetail<JsonElement> result, FeatureFlag prereqOf) {
        return new Event.FeatureRequest(this.getTimestamp(), prereqFlag.getKey(), user, prereqFlag.getVersion(), result == null ? null : result.getVariationIndex(), result == null ? null : result.getValue(), null, prereqOf.getKey(), prereqFlag.isTrackEvents(), prereqFlag.getDebugEventsUntilDate(), this.isIncludeReasons() ? result.getReason() : null, false);
    }

    public Event.FeatureRequest newDebugEvent(Event.FeatureRequest from) {
        return new Event.FeatureRequest(from.creationDate, from.key, from.user, from.version, from.variation, from.value, from.defaultVal, from.prereqOf, from.trackEvents, from.debugEventsUntilDate, from.reason, true);
    }

    public Event.Custom newCustomEvent(String key, LDUser user, JsonElement data) {
        return new Event.Custom(this.getTimestamp(), key, user, data);
    }

    public Event.Identify newIdentifyEvent(LDUser user) {
        return new Event.Identify(this.getTimestamp(), user);
    }

    public static class DefaultEventFactory
    extends EventFactory {
        private final boolean includeReasons;

        public DefaultEventFactory(boolean includeReasons) {
            this.includeReasons = includeReasons;
        }

        @Override
        protected long getTimestamp() {
            return System.currentTimeMillis();
        }

        @Override
        protected boolean isIncludeReasons() {
            return this.includeReasons;
        }
    }
}

