/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client.utils;

import com.launchdarkly.client.FeatureStore;
import com.launchdarkly.client.FeatureStoreCacheConfig;
import com.launchdarkly.client.VersionedData;
import com.launchdarkly.client.VersionedDataKind;
import com.launchdarkly.client.utils.FeatureStoreCore;
import com.launchdarkly.shaded.com.google.common.base.Optional;
import com.launchdarkly.shaded.com.google.common.cache.CacheBuilder;
import com.launchdarkly.shaded.com.google.common.cache.CacheLoader;
import com.launchdarkly.shaded.com.google.common.cache.CacheStats;
import com.launchdarkly.shaded.com.google.common.cache.LoadingCache;
import com.launchdarkly.shaded.com.google.common.util.concurrent.ListeningExecutorService;
import com.launchdarkly.shaded.com.google.common.util.concurrent.MoreExecutors;
import com.launchdarkly.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;

public class CachingStoreWrapper
implements FeatureStore {
    private static final String CACHE_REFRESH_THREAD_POOL_NAME_FORMAT = "CachingStoreWrapper-refresher-pool-%d";
    private final FeatureStoreCore core;
    private final LoadingCache<CacheKey, Optional<VersionedData>> itemCache;
    private final LoadingCache<VersionedDataKind<?>, Map<String, VersionedData>> allCache;
    private final LoadingCache<String, Boolean> initCache;
    private final AtomicBoolean inited = new AtomicBoolean(false);
    private final ListeningExecutorService executorService;

    public static Builder builder(FeatureStoreCore core) {
        return new Builder(core);
    }

    protected CachingStoreWrapper(final FeatureStoreCore core, FeatureStoreCacheConfig caching) {
        this.core = core;
        if (!caching.isEnabled()) {
            this.itemCache = null;
            this.allCache = null;
            this.initCache = null;
            this.executorService = null;
        } else {
            CacheLoader<CacheKey, Optional<VersionedData>> itemLoader = new CacheLoader<CacheKey, Optional<VersionedData>>(){

                @Override
                public Optional<VersionedData> load(CacheKey key) throws Exception {
                    return Optional.fromNullable(core.getInternal(key.kind, key.key));
                }
            };
            CacheLoader allLoader = new CacheLoader<VersionedDataKind<?>, Map<String, VersionedData>>(){

                @Override
                public Map<String, VersionedData> load(VersionedDataKind<?> kind) throws Exception {
                    return CachingStoreWrapper.this.itemsOnlyIfNotDeleted(core.getAllInternal(kind));
                }
            };
            CacheLoader<String, Boolean> initLoader = new CacheLoader<String, Boolean>(){

                @Override
                public Boolean load(String key) throws Exception {
                    return core.initializedInternal();
                }
            };
            switch (caching.getStaleValuesPolicy()) {
                case EVICT: {
                    this.itemCache = CacheBuilder.newBuilder().expireAfterWrite(caching.getCacheTime(), caching.getCacheTimeUnit()).build(itemLoader);
                    this.allCache = CacheBuilder.newBuilder().expireAfterWrite(caching.getCacheTime(), caching.getCacheTimeUnit()).build(allLoader);
                    this.executorService = null;
                    break;
                }
                default: {
                    ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat(CACHE_REFRESH_THREAD_POOL_NAME_FORMAT).setDaemon(true).build();
                    ExecutorService parentExecutor = Executors.newSingleThreadExecutor(threadFactory);
                    this.executorService = MoreExecutors.listeningDecorator(parentExecutor);
                    if (caching.getStaleValuesPolicy() == FeatureStoreCacheConfig.StaleValuesPolicy.REFRESH_ASYNC) {
                        itemLoader = CacheLoader.asyncReloading(itemLoader, this.executorService);
                    }
                    this.itemCache = CacheBuilder.newBuilder().refreshAfterWrite(caching.getCacheTime(), caching.getCacheTimeUnit()).build(itemLoader);
                    this.allCache = CacheBuilder.newBuilder().refreshAfterWrite(caching.getCacheTime(), caching.getCacheTimeUnit()).build(allLoader);
                }
            }
            this.initCache = CacheBuilder.newBuilder().expireAfterWrite(caching.getCacheTime(), caching.getCacheTimeUnit()).build(initLoader);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
        this.core.close();
    }

    @Override
    public <T extends VersionedData> T get(VersionedDataKind<T> kind, String key) {
        Optional<VersionedData> cachedItem;
        if (this.itemCache != null && (cachedItem = this.itemCache.getUnchecked(CacheKey.forItem(kind, key))) != null) {
            return (T)this.itemOnlyIfNotDeleted(cachedItem.orNull());
        }
        return (T)this.itemOnlyIfNotDeleted(this.core.getInternal(kind, key));
    }

    @Override
    public <T extends VersionedData> Map<String, T> all(VersionedDataKind<T> kind) {
        Map<String, VersionedData> items;
        if (this.allCache != null && (items = this.allCache.getUnchecked(kind)) != null) {
            return items;
        }
        return this.itemsOnlyIfNotDeleted(this.core.getAllInternal(kind));
    }

    @Override
    public void init(Map<VersionedDataKind<?>, Map<String, ? extends VersionedData>> allData) {
        Map<VersionedDataKind<?>, Map<String, VersionedData>> castMap = allData;
        this.core.initInternal(castMap);
        this.inited.set(true);
        if (this.allCache != null && this.itemCache != null) {
            this.allCache.invalidateAll();
            this.itemCache.invalidateAll();
            for (Map.Entry<VersionedDataKind<?>, Map<String, VersionedData>> e0 : castMap.entrySet()) {
                VersionedDataKind<?> kind = e0.getKey();
                this.allCache.put(kind, this.itemsOnlyIfNotDeleted(e0.getValue()));
                for (Map.Entry<String, VersionedData> e1 : e0.getValue().entrySet()) {
                    this.itemCache.put(CacheKey.forItem(kind, e1.getKey()), Optional.of(e1.getValue()));
                }
            }
        }
    }

    @Override
    public <T extends VersionedData> void delete(VersionedDataKind<T> kind, String key, int version) {
        this.upsert(kind, kind.makeDeletedItem(key, version));
    }

    @Override
    public <T extends VersionedData> void upsert(VersionedDataKind<T> kind, T item) {
        VersionedData newState = this.core.upsertInternal(kind, item);
        if (this.itemCache != null) {
            this.itemCache.put(CacheKey.forItem(kind, item.getKey()), Optional.fromNullable(newState));
        }
        if (this.allCache != null) {
            this.allCache.invalidate(kind);
        }
    }

    @Override
    public boolean initialized() {
        if (this.inited.get()) {
            return true;
        }
        boolean result = this.initCache != null ? this.initCache.getUnchecked("arbitrary-key").booleanValue() : this.core.initializedInternal();
        if (result) {
            this.inited.set(true);
        }
        return result;
    }

    public CacheStats getCacheStats() {
        if (this.itemCache != null) {
            return this.itemCache.stats();
        }
        return null;
    }

    public FeatureStoreCore getCore() {
        return this.core;
    }

    private VersionedData itemOnlyIfNotDeleted(VersionedData item) {
        return item != null && item.isDeleted() ? null : item;
    }

    private <T extends VersionedData> Map<String, T> itemsOnlyIfNotDeleted(Map<String, ? extends VersionedData> items) {
        HashMap<String, VersionedData> ret = new HashMap<String, VersionedData>();
        if (items != null) {
            for (Map.Entry<String, ? extends VersionedData> item : items.entrySet()) {
                if (item.getValue().isDeleted()) continue;
                ret.put(item.getKey(), item.getValue());
            }
        }
        return ret;
    }

    public static class Builder {
        private final FeatureStoreCore core;
        private FeatureStoreCacheConfig caching = FeatureStoreCacheConfig.DEFAULT;

        Builder(FeatureStoreCore core) {
            this.core = core;
        }

        public Builder caching(FeatureStoreCacheConfig caching) {
            this.caching = caching;
            return this;
        }

        public CachingStoreWrapper build() {
            return new CachingStoreWrapper(this.core, this.caching);
        }
    }

    private static class CacheKey {
        final VersionedDataKind<?> kind;
        final String key;

        public static CacheKey forItem(VersionedDataKind<?> kind, String key) {
            return new CacheKey(kind, key);
        }

        private CacheKey(VersionedDataKind<?> kind, String key) {
            this.kind = kind;
            this.key = key;
        }

        public boolean equals(Object other) {
            if (other instanceof CacheKey) {
                CacheKey o = (CacheKey)other;
                return o.kind.getNamespace().equals(this.kind.getNamespace()) && o.key.equals(this.key);
            }
            return false;
        }

        public int hashCode() {
            return this.kind.getNamespace().hashCode() * 31 + this.key.hashCode();
        }
    }
}

