/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.google.gson.reflect.TypeToken;
import com.launchdarkly.client.LDConfig;
import com.launchdarkly.client.LDUser;
import com.launchdarkly.client.SegmentRule;
import com.launchdarkly.client.VersionedData;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

class Segment
implements VersionedData {
    private static final Type mapType = new TypeToken<Map<String, Segment>>(){}.getType();
    private String key;
    private List<String> included;
    private List<String> excluded;
    private String salt;
    private List<SegmentRule> rules;
    private int version;
    private boolean deleted;

    static Segment fromJson(LDConfig config, String json) {
        return (Segment)config.gson.fromJson(json, Segment.class);
    }

    static Map<String, Segment> fromJsonMap(LDConfig config, String json) {
        return (Map)config.gson.fromJson(json, mapType);
    }

    Segment() {
    }

    private Segment(Builder builder) {
        this.key = builder.key;
        this.included = builder.included;
        this.excluded = builder.excluded;
        this.salt = builder.salt;
        this.rules = builder.rules;
        this.version = builder.version;
        this.deleted = builder.deleted;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public Iterable<String> getIncluded() {
        return this.included;
    }

    public Iterable<String> getExcluded() {
        return this.excluded;
    }

    public String getSalt() {
        return this.salt;
    }

    public Iterable<SegmentRule> getRules() {
        return this.rules;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    public boolean matchesUser(LDUser user) {
        String key = user.getKeyAsString();
        if (key == null) {
            return false;
        }
        if (this.included.contains(key)) {
            return true;
        }
        if (this.excluded.contains(key)) {
            return false;
        }
        for (SegmentRule rule : this.rules) {
            if (!rule.matchUser(user, key, this.salt)) continue;
            return true;
        }
        return false;
    }

    public static class Builder {
        private String key;
        private List<String> included = new ArrayList<String>();
        private List<String> excluded = new ArrayList<String>();
        private String salt = "";
        private List<SegmentRule> rules = new ArrayList<SegmentRule>();
        private int version = 0;
        private boolean deleted;

        public Builder(String key) {
            this.key = key;
        }

        public Builder(Segment from) {
            this.key = from.key;
            this.included = new ArrayList<String>(from.included);
            this.excluded = new ArrayList<String>(from.excluded);
            this.salt = from.salt;
            this.rules = new ArrayList<SegmentRule>(from.rules);
            this.version = from.version;
            this.deleted = from.deleted;
        }

        public Segment build() {
            return new Segment(this);
        }

        public Builder included(Collection<String> included) {
            this.included = new ArrayList<String>(included);
            return this;
        }

        public Builder excluded(Collection<String> excluded) {
            this.excluded = new ArrayList<String>(excluded);
            return this;
        }

        public Builder salt(String salt) {
            this.salt = salt;
            return this;
        }

        public Builder rules(Collection<SegmentRule> rules) {
            this.rules = new ArrayList<SegmentRule>(rules);
            return this;
        }

        public Builder version(int version) {
            this.version = version;
            return this;
        }

        public Builder deleted(boolean deleted) {
            this.deleted = deleted;
            return this;
        }
    }
}

