/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.launchdarkly.client.Clause;
import com.launchdarkly.client.LDUser;
import com.launchdarkly.client.VariationOrRollout;
import java.util.List;

public class SegmentRule {
    private final List<Clause> clauses;
    private final Integer weight;
    private final String bucketBy;

    public SegmentRule(List<Clause> clauses, Integer weight, String bucketBy) {
        this.clauses = clauses;
        this.weight = weight;
        this.bucketBy = bucketBy;
    }

    public boolean matchUser(LDUser user, String segmentKey, String salt) {
        for (Clause c : this.clauses) {
            if (c.matchesUserNoSegments(user)) continue;
            return false;
        }
        if (this.weight == null) {
            return true;
        }
        String by = this.bucketBy == null ? "key" : this.bucketBy;
        double bucket = VariationOrRollout.bucketUser(user, segmentKey, by, salt);
        double weight = (double)this.weight.intValue() / 100000.0;
        return bucket < weight;
    }
}

