/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.google.gson.JsonElement;
import com.launchdarkly.client.EvaluationException;

abstract class VariationType<T> {
    static VariationType<Boolean> Boolean = new VariationType<Boolean>(){

        @Override
        Boolean coerceValue(JsonElement result) throws EvaluationException {
            if (result.isJsonPrimitive() && result.getAsJsonPrimitive().isBoolean()) {
                return result.getAsBoolean();
            }
            throw new EvaluationException("Feature flag evaluation expected result as boolean type, but got non-boolean type.");
        }
    };
    static VariationType<Integer> Integer = new VariationType<Integer>(){

        @Override
        Integer coerceValue(JsonElement result) throws EvaluationException {
            if (result.isJsonPrimitive() && result.getAsJsonPrimitive().isNumber()) {
                return result.getAsInt();
            }
            throw new EvaluationException("Feature flag evaluation expected result as number type, but got non-number type.");
        }
    };
    static VariationType<Double> Double = new VariationType<Double>(){

        @Override
        Double coerceValue(JsonElement result) throws EvaluationException {
            if (result.isJsonPrimitive() && result.getAsJsonPrimitive().isNumber()) {
                return result.getAsDouble();
            }
            throw new EvaluationException("Feature flag evaluation expected result as number type, but got non-number type.");
        }
    };
    static VariationType<String> String = new VariationType<String>(){

        @Override
        String coerceValue(JsonElement result) throws EvaluationException {
            if (result.isJsonPrimitive() && result.getAsJsonPrimitive().isString()) {
                return result.getAsString();
            }
            throw new EvaluationException("Feature flag evaluation expected result as string type, but got non-string type.");
        }
    };
    static VariationType<JsonElement> Json = new VariationType<JsonElement>(){

        @Override
        JsonElement coerceValue(JsonElement result) throws EvaluationException {
            return result;
        }
    };

    abstract T coerceValue(JsonElement var1) throws EvaluationException;

    private VariationType() {
    }
}

