/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk;

import com.google.gson.JsonIOException;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.sdk.AttributeRef;
import com.launchdarkly.sdk.ContextBuilder;
import com.launchdarkly.sdk.ContextKind;
import com.launchdarkly.sdk.ContextMultiBuilder;
import com.launchdarkly.sdk.LDContext;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.LDValueType;
import com.launchdarkly.sdk.LDValueTypeAdapter;
import java.io.IOException;
import java.util.Map;

final class LDContextTypeAdapter
extends TypeAdapter<LDContext> {
    private static final String JSON_PROP_META = "_meta";
    private static final String JSON_PROP_PRIVATE = "privateAttributes";
    private static final String JSON_PROP_OLD_PRIVATE = "privateAttributeNames";
    private static final String JSON_PROP_OLD_CUSTOM = "custom";

    LDContextTypeAdapter() {
    }

    public void write(JsonWriter out, LDContext c) throws IOException {
        if (!c.isValid()) {
            throw new JsonIOException("tried to serialize invalid LDContext: " + c.getError());
        }
        if (c.isMultiple()) {
            out.beginObject();
            out.name("kind").value(ContextKind.MULTI.toString());
            for (LDContext c1 : c.multiContexts) {
                out.name(c1.getKind().toString());
                this.writeSingleKind(out, c1, false);
            }
            out.endObject();
        } else {
            this.writeSingleKind(out, c, true);
        }
    }

    private void writeSingleKind(JsonWriter out, LDContext c, boolean includeKind) throws IOException {
        out.beginObject();
        if (includeKind) {
            out.name("kind").value(c.getKind().toString());
        }
        out.name("key").value(c.getKey());
        if (c.getName() != null) {
            out.name("name").value(c.getName());
        }
        if (c.isAnonymous()) {
            out.name("anonymous").value(c.isAnonymous());
        }
        if (c.attributes != null) {
            for (Map.Entry<String, LDValue> kv : c.attributes.entrySet()) {
                out.name(kv.getKey());
                LDValueTypeAdapter.INSTANCE.write(out, kv.getValue());
            }
        }
        if (c.getPrivateAttributeCount() != 0) {
            out.name(JSON_PROP_META).beginObject();
            out.name(JSON_PROP_PRIVATE).beginArray();
            for (AttributeRef a : c.privateAttributes) {
                out.value(a.toString());
            }
            out.endArray();
            out.endObject();
        }
        out.endObject();
    }

    public LDContext read(JsonReader in) throws IOException {
        LDContext ret;
        LDValue obj = LDContextTypeAdapter.requireValueType(LDValueTypeAdapter.INSTANCE.read(in), LDValueType.OBJECT, false, null);
        ContextKind kind = null;
        for (String key : obj.keys()) {
            if (!key.equals("kind")) continue;
            kind = ContextKind.of(LDContextTypeAdapter.requireValueType(obj.get(key), LDValueType.STRING, false, "kind").stringValue());
            break;
        }
        if (kind == null) {
            ret = LDContextTypeAdapter.readOldUser(obj);
        } else if (kind.equals(ContextKind.MULTI)) {
            ContextMultiBuilder mb = LDContext.multiBuilder();
            for (String key : obj.keys()) {
                if (key.equals("kind")) continue;
                mb.add(LDContextTypeAdapter.readSingleKind(obj.get(key), ContextKind.of(key)));
            }
            ret = mb.build();
        } else {
            ret = LDContextTypeAdapter.readSingleKind(obj, null);
        }
        if (!ret.isValid()) {
            throw new JsonParseException("invalid LDContext: " + ret.getError());
        }
        return ret;
    }

    private static LDValue requireValueType(LDValue v, LDValueType t, boolean nullable, String propName) throws JsonParseException {
        if (!(v.getType() == t || nullable && v.isNull())) {
            throw new JsonParseException("expected " + (Object)((Object)t) + ", found " + (Object)((Object)v.getType()) + (propName == null ? "" : " for " + propName));
        }
        return v;
    }

    private static LDContext readOldUser(LDValue obj) throws JsonParseException {
        LDContextTypeAdapter.requireValueType(obj, LDValueType.OBJECT, false, null);
        ContextBuilder cb = LDContext.builder(null);
        cb.setAllowEmptyKey(true);
        block21: for (String key : obj.keys()) {
            LDValue v = obj.get(key);
            switch (key) {
                case "key": {
                    cb.key(LDContextTypeAdapter.requireValueType(v, LDValueType.STRING, false, key).stringValue());
                    break;
                }
                case "name": {
                    cb.name(LDContextTypeAdapter.requireValueType(v, LDValueType.STRING, true, key).stringValue());
                    break;
                }
                case "anonymous": {
                    cb.anonymous(LDContextTypeAdapter.requireValueType(v, LDValueType.BOOLEAN, true, key).booleanValue());
                    break;
                }
                case "privateAttributeNames": {
                    LDValue privateAttrs = LDContextTypeAdapter.requireValueType(v, LDValueType.ARRAY, true, JSON_PROP_OLD_PRIVATE);
                    for (LDValue privateAttr : privateAttrs.values()) {
                        cb.privateAttributes(AttributeRef.fromLiteral(LDContextTypeAdapter.requireValueType(privateAttr, LDValueType.STRING, false, JSON_PROP_PRIVATE).stringValue()));
                    }
                    continue block21;
                }
                case "custom": {
                    for (String customKey : LDContextTypeAdapter.requireValueType(v, LDValueType.OBJECT, true, JSON_PROP_OLD_CUSTOM).keys()) {
                        cb.set(customKey, v.get(customKey));
                    }
                    continue block21;
                }
                case "firstName": 
                case "lastName": 
                case "email": 
                case "country": 
                case "ip": 
                case "avatar": {
                    cb.set(key, LDContextTypeAdapter.requireValueType(v, LDValueType.STRING, true, key));
                    break;
                }
            }
        }
        return cb.build();
    }

    private static LDContext readSingleKind(LDValue obj, ContextKind kind) throws JsonParseException {
        LDContextTypeAdapter.requireValueType(obj, LDValueType.OBJECT, false, kind == null ? null : kind.toString());
        ContextBuilder cb = LDContext.builder("").kind(kind);
        boolean hasNonEmptyKind = kind != null;
        block14: for (String key : obj.keys()) {
            LDValue v = obj.get(key);
            switch (key) {
                case "kind": {
                    String s = LDContextTypeAdapter.requireValueType(v, LDValueType.STRING, false, key).stringValue();
                    if (s.isEmpty()) continue block14;
                    hasNonEmptyKind = true;
                    cb.kind(s);
                    break;
                }
                case "key": {
                    cb.key(LDContextTypeAdapter.requireValueType(v, LDValueType.STRING, false, key).stringValue());
                    break;
                }
                case "name": {
                    cb.name(LDContextTypeAdapter.requireValueType(v, LDValueType.STRING, true, key).stringValue());
                    break;
                }
                case "anonymous": {
                    cb.anonymous(LDContextTypeAdapter.requireValueType(v, LDValueType.BOOLEAN, true, key).booleanValue());
                    break;
                }
                case "_meta": {
                    LDValue meta = LDContextTypeAdapter.requireValueType(v, LDValueType.OBJECT, true, key);
                    LDValue privateAttrs = LDContextTypeAdapter.requireValueType(meta.get(JSON_PROP_PRIVATE), LDValueType.ARRAY, true, JSON_PROP_PRIVATE);
                    for (LDValue privateAttr : privateAttrs.values()) {
                        cb.privateAttributes(AttributeRef.fromPath(LDContextTypeAdapter.requireValueType(privateAttr, LDValueType.STRING, false, JSON_PROP_PRIVATE).stringValue()));
                    }
                    continue block14;
                }
                default: {
                    cb.set(key, v);
                }
            }
        }
        if (!hasNonEmptyKind) {
            return LDContext.failed("context kind must not be empty in JSON");
        }
        return cb.build();
    }
}

