/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.internal.events;

import com.google.gson.stream.JsonWriter;
import com.launchdarkly.sdk.AttributeRef;
import com.launchdarkly.sdk.EvaluationReason;
import com.launchdarkly.sdk.LDContext;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.internal.GsonHelpers;
import com.launchdarkly.sdk.internal.events.Event;
import com.launchdarkly.sdk.internal.events.EventContextFormatter;
import com.launchdarkly.sdk.internal.events.EventSummarizer;
import com.launchdarkly.sdk.internal.events.EventsConfiguration;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;

final class EventOutputFormatter {
    private final EventContextFormatter contextFormatter;

    EventOutputFormatter(EventsConfiguration config) {
        this.contextFormatter = new EventContextFormatter(config.allAttributesPrivate, config.privateAttributes.toArray(new AttributeRef[config.privateAttributes.size()]));
    }

    final int writeOutputEvents(Event[] events, EventSummarizer.EventSummary summary, Writer writer) throws IOException {
        int count = 0;
        JsonWriter jsonWriter = new JsonWriter(writer);
        jsonWriter.beginArray();
        for (Event event : events) {
            if (!this.writeOutputEvent(event, jsonWriter)) continue;
            ++count;
        }
        if (!summary.isEmpty()) {
            this.writeSummaryEvent(summary, jsonWriter);
            ++count;
        }
        jsonWriter.endArray();
        jsonWriter.flush();
        return count;
    }

    private final boolean writeOutputEvent(Event event, JsonWriter jw) throws IOException {
        if (event.getContext() == null || !event.getContext().isValid()) {
            return false;
        }
        if (event instanceof Event.FeatureRequest) {
            Event.FeatureRequest fe = (Event.FeatureRequest)event;
            jw.beginObject();
            this.writeKindAndCreationDate(jw, fe.isDebug() ? "debug" : "feature", event.getCreationDate());
            jw.name("key").value(fe.getKey());
            if (fe.isDebug()) {
                this.writeContext(fe.getContext(), jw);
            } else {
                this.writeContextKeys(fe.getContext(), jw);
            }
            if (fe.getVersion() >= 0) {
                jw.name("version");
                jw.value((long)fe.getVersion());
            }
            if (fe.getVariation() >= 0) {
                jw.name("variation");
                jw.value((long)fe.getVariation());
            }
            this.writeLDValue("value", fe.getValue(), jw);
            this.writeLDValue("default", fe.getDefaultVal(), jw);
            if (fe.getPrereqOf() != null) {
                jw.name("prereqOf");
                jw.value(fe.getPrereqOf());
            }
            this.writeEvaluationReason("reason", fe.getReason(), jw);
            jw.endObject();
        } else if (event instanceof Event.Identify) {
            jw.beginObject();
            this.writeKindAndCreationDate(jw, "identify", event.getCreationDate());
            this.writeContext(event.getContext(), jw);
            jw.endObject();
        } else if (event instanceof Event.Custom) {
            Event.Custom ce = (Event.Custom)event;
            jw.beginObject();
            this.writeKindAndCreationDate(jw, "custom", event.getCreationDate());
            jw.name("key").value(ce.getKey());
            this.writeContextKeys(ce.getContext(), jw);
            this.writeLDValue("data", ce.getData(), jw);
            if (ce.getMetricValue() != null) {
                jw.name("metricValue");
                jw.value((Number)ce.getMetricValue());
            }
            jw.endObject();
        } else if (event instanceof Event.Index) {
            jw.beginObject();
            this.writeKindAndCreationDate(jw, "index", event.getCreationDate());
            this.writeContext(event.getContext(), jw);
            jw.endObject();
        } else {
            return false;
        }
        return true;
    }

    private final void writeSummaryEvent(EventSummarizer.EventSummary summary, JsonWriter jw) throws IOException {
        jw.beginObject();
        jw.name("kind");
        jw.value("summary");
        jw.name("startDate");
        jw.value(summary.startDate);
        jw.name("endDate");
        jw.value(summary.endDate);
        jw.name("features");
        jw.beginObject();
        for (Map.Entry<String, EventSummarizer.FlagInfo> flag : summary.counters.entrySet()) {
            String flagKey = flag.getKey();
            EventSummarizer.FlagInfo flagInfo = flag.getValue();
            jw.name(flagKey);
            jw.beginObject();
            this.writeLDValue("default", flagInfo.defaultVal, jw);
            jw.name("contextKinds").beginArray();
            for (String kind : flagInfo.contextKinds) {
                jw.value(kind);
            }
            jw.endArray();
            jw.name("counters");
            jw.beginArray();
            for (int i = 0; i < flagInfo.versionsAndVariations.size(); ++i) {
                int version = flagInfo.versionsAndVariations.keyAt(i);
                EventSummarizer.SimpleIntKeyedMap<EventSummarizer.CounterValue> variations = flagInfo.versionsAndVariations.valueAt(i);
                for (int j = 0; j < variations.size(); ++j) {
                    int variation = variations.keyAt(j);
                    EventSummarizer.CounterValue counter = variations.valueAt(j);
                    jw.beginObject();
                    if (variation >= 0) {
                        jw.name("variation").value((long)variation);
                    }
                    if (version >= 0) {
                        jw.name("version").value((long)version);
                    } else {
                        jw.name("unknown").value(true);
                    }
                    this.writeLDValue("value", counter.flagValue, jw);
                    jw.name("count").value(counter.count);
                    jw.endObject();
                }
            }
            jw.endArray();
            jw.endObject();
        }
        jw.endObject();
        jw.endObject();
    }

    private final void writeKindAndCreationDate(JsonWriter jw, String kind, long creationDate) throws IOException {
        jw.name("kind").value(kind);
        jw.name("creationDate").value(creationDate);
    }

    private final void writeContext(LDContext context, JsonWriter jw) throws IOException {
        jw.name("context");
        this.contextFormatter.write(context, jw);
    }

    private final void writeContextKeys(LDContext context, JsonWriter jw) throws IOException {
        jw.name("contextKeys").beginObject();
        for (int i = 0; i < context.getIndividualContextCount(); ++i) {
            LDContext c = context.getIndividualContext(i);
            if (c == null) continue;
            jw.name(c.getKind().toString()).value(c.getKey());
        }
        jw.endObject();
    }

    private final void writeLDValue(String key, LDValue value, JsonWriter jw) throws IOException {
        if (value == null || value.isNull()) {
            return;
        }
        jw.name(key);
        GsonHelpers.gsonInstance().toJson((Object)value, LDValue.class, jw);
    }

    private final void writeEvaluationReason(String key, EvaluationReason er, JsonWriter jw) throws IOException {
        if (er == null) {
            return;
        }
        jw.name(key);
        GsonHelpers.gsonInstance().toJson((Object)er, EvaluationReason.class, jw);
    }
}

