/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.internal.events;

import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.LDValueType;
import com.launchdarkly.sdk.ObjectBuilder;
import com.launchdarkly.sdk.internal.events.DiagnosticConfigProperty;
import com.launchdarkly.sdk.internal.events.DiagnosticEvent;
import com.launchdarkly.sdk.internal.events.DiagnosticId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public final class DiagnosticStore {
    private final DiagnosticId diagnosticId;
    private final long creationDate;
    private final SdkDiagnosticParams diagnosticParams;
    private volatile long dataSinceDate;
    private final AtomicInteger eventsInLastBatch = new AtomicInteger(0);
    private final Object streamInitsLock = new Object();
    private ArrayList<DiagnosticEvent.StreamInit> streamInits = new ArrayList();

    public DiagnosticStore(SdkDiagnosticParams params) {
        this.creationDate = this.dataSinceDate = System.currentTimeMillis();
        this.diagnosticId = new DiagnosticId(params.sdkKeyOrMobileKey);
        this.diagnosticParams = params;
    }

    public DiagnosticId getDiagnosticId() {
        return this.diagnosticId;
    }

    public long getDataSinceDate() {
        return this.dataSinceDate;
    }

    public DiagnosticEvent getInitEvent() {
        return DiagnosticEvent.makeInit(this.creationDate, this.diagnosticId, this.makeInitEventSdkData(), this.makeInitEventConfigData(), this.makeInitEventPlatformData());
    }

    private LDValue makeInitEventSdkData() {
        ObjectBuilder b = LDValue.buildObject().put("name", this.diagnosticParams.sdkName).put("version", this.diagnosticParams.sdkVersion);
        for (Map.Entry<String, String> kv : this.diagnosticParams.defaultHttpHeaders.entrySet()) {
            if (!kv.getKey().equalsIgnoreCase("x-launchdarkly-wrapper")) continue;
            if (kv.getValue().contains("/")) {
                b.put("wrapperName", kv.getValue().substring(0, kv.getValue().indexOf("/")));
                b.put("wrapperVersion", kv.getValue().substring(kv.getValue().indexOf("/") + 1));
                continue;
            }
            b.put("wrapperName", kv.getValue());
        }
        return b.build();
    }

    private LDValue makeInitEventConfigData() {
        ObjectBuilder b = LDValue.buildObject();
        for (LDValue configProps : this.diagnosticParams.configProperties) {
            if (configProps == null || configProps.getType() != LDValueType.OBJECT) continue;
            block1: for (String prop : configProps.keys()) {
                for (DiagnosticConfigProperty p : DiagnosticConfigProperty.values()) {
                    if (!p.name.equals(prop)) continue;
                    LDValue value = configProps.get(prop);
                    if (value.getType() != p.type) continue block1;
                    b.put(prop, value);
                    continue block1;
                }
            }
        }
        return b.build();
    }

    private LDValue makeInitEventPlatformData() {
        ObjectBuilder b = LDValue.buildObject().put("name", this.diagnosticParams.platformName).put("osArch", System.getProperty("os.arch")).put("osVersion", System.getProperty("os.version"));
        if (this.diagnosticParams.extraPlatformData != null) {
            for (String key : this.diagnosticParams.extraPlatformData.keys()) {
                b.put(key, this.diagnosticParams.extraPlatformData.get(key));
            }
        }
        return b.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordStreamInit(long timestamp, long durationMillis, boolean failed) {
        Object object = this.streamInitsLock;
        synchronized (object) {
            this.streamInits.add(new DiagnosticEvent.StreamInit(timestamp, durationMillis, failed));
        }
    }

    public void recordEventsInBatch(int eventsInBatch) {
        this.eventsInLastBatch.set(eventsInBatch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiagnosticEvent createEventAndReset(long droppedEvents, long deduplicatedContexts) {
        ArrayList<DiagnosticEvent.StreamInit> eventInits;
        long currentTime = System.currentTimeMillis();
        Object object = this.streamInitsLock;
        synchronized (object) {
            eventInits = this.streamInits;
            this.streamInits = new ArrayList();
        }
        long eventsInBatch = this.eventsInLastBatch.getAndSet(0);
        DiagnosticEvent res = DiagnosticEvent.makeStatistics(currentTime, this.diagnosticId, this.dataSinceDate, droppedEvents, deduplicatedContexts, eventsInBatch, eventInits);
        this.dataSinceDate = currentTime;
        return res;
    }

    public static class SdkDiagnosticParams {
        final String sdkKeyOrMobileKey;
        final String sdkName;
        final String sdkVersion;
        final String platformName;
        final LDValue extraPlatformData;
        final Map<String, String> defaultHttpHeaders;
        final List<LDValue> configProperties;

        public SdkDiagnosticParams(String sdkKeyOrMobileKey, String sdkName, String sdkVersion, String platformName, LDValue extraPlatformData, Map<String, String> defaultHttpHeaders, List<LDValue> configProperties) {
            this.sdkKeyOrMobileKey = sdkKeyOrMobileKey;
            this.sdkName = sdkName;
            this.sdkVersion = sdkVersion;
            this.platformName = platformName;
            this.extraPlatformData = extraPlatformData;
            this.defaultHttpHeaders = defaultHttpHeaders == null ? Collections.emptyMap() : new HashMap<String, String>(defaultHttpHeaders);
            this.configProperties = configProperties == null ? Collections.emptyList() : new ArrayList<LDValue>(configProperties);
        }
    }
}

