/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.internal.events;

import com.google.gson.stream.JsonWriter;
import com.launchdarkly.sdk.AttributeRef;
import com.launchdarkly.sdk.EvaluationReason;
import com.launchdarkly.sdk.LDContext;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.internal.GsonHelpers;
import com.launchdarkly.sdk.internal.events.Event;
import com.launchdarkly.sdk.internal.events.EventContextFormatter;
import com.launchdarkly.sdk.internal.events.EventSummarizer;
import com.launchdarkly.sdk.internal.events.EventsConfiguration;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;

final class EventOutputFormatter {
    private final EventContextFormatter contextFormatter;

    EventOutputFormatter(EventsConfiguration config) {
        this.contextFormatter = new EventContextFormatter(config.allAttributesPrivate, config.privateAttributes.toArray(new AttributeRef[config.privateAttributes.size()]));
    }

    int writeOutputEvents(Event[] events, EventSummarizer.EventSummary summary, Writer writer) throws IOException {
        int count = 0;
        JsonWriter jsonWriter = new JsonWriter(writer);
        jsonWriter.beginArray();
        for (Event event : events) {
            if (!this.writeOutputEvent(event, jsonWriter)) continue;
            ++count;
        }
        if (!summary.isEmpty()) {
            this.writeSummaryEvent(summary, jsonWriter);
            ++count;
        }
        jsonWriter.endArray();
        jsonWriter.flush();
        return count;
    }

    private boolean writeOutputEvent(Event event, JsonWriter jw) throws IOException {
        if (event.getContext() == null || !event.getContext().isValid()) {
            return false;
        }
        if (event instanceof Event.FeatureRequest) {
            Event.FeatureRequest fe = (Event.FeatureRequest)event;
            jw.beginObject();
            this.writeKindAndCreationDate(jw, fe.isDebug() ? "debug" : "feature", event.getCreationDate());
            jw.name("key").value(fe.getKey());
            this.writeContext(fe.getContext(), jw, !fe.isDebug());
            if (fe.getVersion() >= 0) {
                jw.name("version");
                jw.value((long)fe.getVersion());
            }
            if (fe.getVariation() >= 0) {
                jw.name("variation");
                jw.value((long)fe.getVariation());
            }
            this.writeLDValue("value", fe.getValue(), jw);
            this.writeLDValue("default", fe.getDefaultVal(), jw);
            if (fe.getPrereqOf() != null) {
                jw.name("prereqOf");
                jw.value(fe.getPrereqOf());
            }
            this.writeEvaluationReason(fe.getReason(), jw);
            jw.endObject();
        } else if (event instanceof Event.Identify) {
            jw.beginObject();
            this.writeKindAndCreationDate(jw, "identify", event.getCreationDate());
            this.writeContext(event.getContext(), jw, false);
            jw.endObject();
        } else if (event instanceof Event.Custom) {
            Event.Custom ce = (Event.Custom)event;
            jw.beginObject();
            this.writeKindAndCreationDate(jw, "custom", event.getCreationDate());
            jw.name("key").value(ce.getKey());
            this.writeContext(ce.getContext(), jw, false);
            this.writeLDValue("data", ce.getData(), jw);
            if (ce.getMetricValue() != null) {
                jw.name("metricValue");
                jw.value((Number)ce.getMetricValue());
            }
            jw.endObject();
        } else if (event instanceof Event.Index) {
            jw.beginObject();
            this.writeKindAndCreationDate(jw, "index", event.getCreationDate());
            this.writeContext(event.getContext(), jw, false);
            jw.endObject();
        } else if (event instanceof Event.MigrationOp) {
            jw.beginObject();
            this.writeKindAndCreationDate(jw, "migration_op", event.getCreationDate());
            this.writeContext(event.getContext(), jw, false);
            Event.MigrationOp me = (Event.MigrationOp)event;
            jw.name("operation").value(me.getOperation());
            long samplingRatio = me.getSamplingRatio();
            if (samplingRatio != 1L) {
                jw.name("samplingRatio").value(samplingRatio);
            }
            this.writeMigrationEvaluation(jw, me);
            EventOutputFormatter.writeMeasurements(jw, me);
            jw.endObject();
        } else {
            return false;
        }
        return true;
    }

    private static void writeMeasurements(JsonWriter jw, Event.MigrationOp me) throws IOException {
        jw.name("measurements");
        jw.beginArray();
        EventOutputFormatter.writeInvokedMeasurement(jw, me);
        EventOutputFormatter.writeConsistencyMeasurement(jw, me);
        EventOutputFormatter.writeLatencyMeasurement(jw, me);
        EventOutputFormatter.writeErrorMeasurement(jw, me);
        jw.endArray();
    }

    private static void writeErrorMeasurement(JsonWriter jw, Event.MigrationOp me) throws IOException {
        Event.MigrationOp.ErrorMeasurement errorMeasurement = me.getErrorMeasurement();
        if (errorMeasurement != null && errorMeasurement.hasMeasurement()) {
            jw.beginObject();
            jw.name("key").value("error");
            jw.name("values");
            jw.beginObject();
            if (errorMeasurement.hasOldError()) {
                jw.name("old").value(errorMeasurement.hasOldError());
            }
            if (errorMeasurement.hasNewError()) {
                jw.name("new").value(errorMeasurement.hasNewError());
            }
            jw.endObject();
            jw.endObject();
        }
    }

    private static void writeLatencyMeasurement(JsonWriter jw, Event.MigrationOp me) throws IOException {
        Event.MigrationOp.LatencyMeasurement latencyMeasurement = me.getLatencyMeasurement();
        if (latencyMeasurement != null && latencyMeasurement.hasMeasurement()) {
            jw.beginObject();
            jw.name("key").value("latency_ms");
            jw.name("values");
            jw.beginObject();
            if (latencyMeasurement.getOldLatencyMs() != null) {
                jw.name("old").value((Number)latencyMeasurement.getOldLatencyMs());
            }
            if (latencyMeasurement.getNewLatencyMs() != null) {
                jw.name("new").value((Number)latencyMeasurement.getNewLatencyMs());
            }
            jw.endObject();
            jw.endObject();
        }
    }

    private static void writeConsistencyMeasurement(JsonWriter jw, Event.MigrationOp me) throws IOException {
        Event.MigrationOp.ConsistencyMeasurement consistencyMeasurement = me.getConsistencyMeasurement();
        if (consistencyMeasurement != null) {
            jw.beginObject();
            jw.name("key").value("consistent");
            jw.name("value").value(consistencyMeasurement.isConsistent());
            if (consistencyMeasurement.getSamplingRatio() != 1L) {
                jw.name("samplingRatio").value(consistencyMeasurement.getSamplingRatio());
            }
            jw.endObject();
        }
    }

    private static void writeInvokedMeasurement(JsonWriter jw, Event.MigrationOp me) throws IOException {
        jw.beginObject();
        jw.name("key").value("invoked");
        Event.MigrationOp.InvokedMeasurement invokedMeasurement = me.getInvokedMeasurement();
        jw.name("values");
        jw.beginObject();
        if (invokedMeasurement.wasOldInvoked()) {
            jw.name("old").value(invokedMeasurement.wasOldInvoked());
        }
        if (invokedMeasurement.wasNewInvoked()) {
            jw.name("new").value(invokedMeasurement.wasNewInvoked());
        }
        jw.endObject();
        jw.endObject();
    }

    private void writeMigrationEvaluation(JsonWriter jw, Event.MigrationOp me) throws IOException {
        jw.name("evaluation");
        jw.beginObject();
        jw.name("key").value(me.getFeatureKey());
        if (me.getVariation() >= 0) {
            jw.name("variation");
            jw.value((long)me.getVariation());
        }
        if (me.getFlagVersion() >= 0) {
            jw.name("version");
            jw.value((long)me.getFlagVersion());
        }
        this.writeLDValue("value", me.getValue(), jw);
        this.writeLDValue("default", me.getDefaultVal(), jw);
        this.writeEvaluationReason(me.getReason(), jw);
        jw.endObject();
    }

    private void writeSummaryEvent(EventSummarizer.EventSummary summary, JsonWriter jw) throws IOException {
        jw.beginObject();
        jw.name("kind");
        jw.value("summary");
        jw.name("startDate");
        jw.value(summary.startDate);
        jw.name("endDate");
        jw.value(summary.endDate);
        jw.name("features");
        jw.beginObject();
        for (Map.Entry<String, EventSummarizer.FlagInfo> flag : summary.counters.entrySet()) {
            String flagKey = flag.getKey();
            EventSummarizer.FlagInfo flagInfo = flag.getValue();
            jw.name(flagKey);
            jw.beginObject();
            this.writeLDValue("default", flagInfo.defaultVal, jw);
            jw.name("contextKinds").beginArray();
            for (String kind : flagInfo.contextKinds) {
                jw.value(kind);
            }
            jw.endArray();
            jw.name("counters");
            jw.beginArray();
            for (int i = 0; i < flagInfo.versionsAndVariations.size(); ++i) {
                int version = flagInfo.versionsAndVariations.keyAt(i);
                EventSummarizer.SimpleIntKeyedMap<EventSummarizer.CounterValue> variations = flagInfo.versionsAndVariations.valueAt(i);
                for (int j = 0; j < variations.size(); ++j) {
                    int variation = variations.keyAt(j);
                    EventSummarizer.CounterValue counter = variations.valueAt(j);
                    jw.beginObject();
                    if (variation >= 0) {
                        jw.name("variation").value((long)variation);
                    }
                    if (version >= 0) {
                        jw.name("version").value((long)version);
                    } else {
                        jw.name("unknown").value(true);
                    }
                    this.writeLDValue("value", counter.flagValue, jw);
                    jw.name("count").value(counter.count);
                    jw.endObject();
                }
            }
            jw.endArray();
            jw.endObject();
        }
        jw.endObject();
        jw.endObject();
    }

    private void writeKindAndCreationDate(JsonWriter jw, String kind, long creationDate) throws IOException {
        jw.name("kind").value(kind);
        jw.name("creationDate").value(creationDate);
    }

    private void writeContext(LDContext context, JsonWriter jw, boolean redactAnonymous) throws IOException {
        jw.name("context");
        this.contextFormatter.write(context, jw, redactAnonymous);
    }

    private void writeLDValue(String key, LDValue value, JsonWriter jw) throws IOException {
        if (value == null || value.isNull()) {
            return;
        }
        jw.name(key);
        GsonHelpers.gsonInstance().toJson((Object)value, LDValue.class, jw);
    }

    private void writeEvaluationReason(EvaluationReason er, JsonWriter jw) throws IOException {
        if (er == null) {
            return;
        }
        jw.name("reason");
        GsonHelpers.gsonInstance().toJson((Object)er, EvaluationReason.class, jw);
    }
}

