/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.internal.http;

import com.launchdarkly.sdk.internal.http.HeadersTransformer;
import java.net.Proxy;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.Authenticator;
import okhttp3.ConnectionPool;
import okhttp3.Headers;
import okhttp3.OkHttpClient;

public final class HttpProperties {
    private static final int DEFAULT_TIMEOUT = 10000;
    private final long connectTimeoutMillis;
    private final Map<String, String> defaultHeaders;
    private final HeadersTransformer headersTransformer;
    private final Proxy proxy;
    private final Authenticator proxyAuth;
    private final OkHttpClient sharedHttpClient;
    private final SocketFactory socketFactory;
    private final long socketTimeoutMillis;
    private final SSLSocketFactory sslSocketFactory;
    private final X509TrustManager trustManager;

    public HttpProperties(long connectTimeoutMillis, Map<String, String> defaultHeaders, HeadersTransformer headersTransformer, Proxy proxy, Authenticator proxyAuth, SocketFactory socketFactory, long socketTimeoutMillis, SSLSocketFactory sslSocketFactory, X509TrustManager trustManager) {
        this.connectTimeoutMillis = connectTimeoutMillis <= 0L ? 10000L : connectTimeoutMillis;
        this.defaultHeaders = defaultHeaders == null ? Collections.emptyMap() : new HashMap<String, String>(defaultHeaders);
        this.headersTransformer = headersTransformer;
        this.proxy = proxy;
        this.proxyAuth = proxyAuth;
        this.sharedHttpClient = null;
        this.socketFactory = socketFactory;
        this.socketTimeoutMillis = socketTimeoutMillis <= 0L ? 10000L : socketTimeoutMillis;
        this.sslSocketFactory = sslSocketFactory;
        this.trustManager = trustManager;
    }

    public HttpProperties(OkHttpClient sharedHttpClient, Map<String, String> defaultHeaders, HeadersTransformer headersTransformer) {
        this.defaultHeaders = defaultHeaders == null ? Collections.emptyMap() : new HashMap<String, String>(defaultHeaders);
        this.headersTransformer = headersTransformer;
        this.sharedHttpClient = sharedHttpClient;
        this.connectTimeoutMillis = 10000L;
        this.proxy = null;
        this.proxyAuth = null;
        this.socketFactory = null;
        this.socketTimeoutMillis = 10000L;
        this.sslSocketFactory = null;
        this.trustManager = null;
    }

    public static HttpProperties defaults() {
        return new HttpProperties(0L, null, null, null, null, null, 0L, null, null);
    }

    public Iterable<Map.Entry<String, String>> getDefaultHeaders() {
        return this.defaultHeaders.entrySet();
    }

    public Iterable<Map.Entry<String, String>> getTransformedDefaultHeaders() {
        if (this.headersTransformer == null) {
            return this.defaultHeaders.entrySet();
        }
        HashMap<String, String> ret = new HashMap<String, String>(this.defaultHeaders);
        this.headersTransformer.updateHeaders(ret);
        return ret.entrySet();
    }

    public HeadersTransformer getHeadersTransformer() {
        return this.headersTransformer;
    }

    public OkHttpClient getSharedHttpClient() {
        return this.sharedHttpClient;
    }

    public void applyToHttpClientBuilder(OkHttpClient.Builder builder) {
        builder.connectionPool(new ConnectionPool(5, 5L, TimeUnit.SECONDS));
        if (this.connectTimeoutMillis > 0L) {
            builder.connectTimeout(this.connectTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        if (this.socketTimeoutMillis > 0L) {
            builder.readTimeout(this.socketTimeoutMillis, TimeUnit.MILLISECONDS).writeTimeout(this.socketTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        builder.retryOnConnectionFailure(false);
        if (this.socketFactory != null) {
            builder.socketFactory(this.socketFactory);
        }
        if (this.sslSocketFactory != null) {
            builder.sslSocketFactory(this.sslSocketFactory, this.trustManager);
        }
        if (this.proxy != null) {
            builder.proxy(this.proxy);
            if (this.proxyAuth != null) {
                builder.proxyAuthenticator(this.proxyAuth);
            }
        }
    }

    public OkHttpClient.Builder toHttpClientBuilder() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        this.applyToHttpClientBuilder(builder);
        return builder;
    }

    public Headers.Builder toHeadersBuilder() {
        Headers.Builder builder = new Headers.Builder();
        for (Map.Entry<String, String> kv : this.getTransformedDefaultHeaders()) {
            builder.add(kv.getKey(), kv.getValue());
        }
        return builder;
    }

    public static void shutdownHttpClient(OkHttpClient client) {
        if (client.dispatcher() != null) {
            client.dispatcher().cancelAll();
            if (client.dispatcher().executorService() != null) {
                client.dispatcher().executorService().shutdown();
            }
        }
        if (client.connectionPool() != null) {
            client.connectionPool().evictAll();
        }
        if (client.cache() != null) {
            try {
                client.cache().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

