/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server.integrations;

import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.sdk.server.integrations.DynamoDbStoreImplBase;
import com.launchdarkly.sdk.server.subsystems.BigSegmentStore;
import com.launchdarkly.sdk.server.subsystems.BigSegmentStoreTypes;
import java.util.List;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.GetItemResponse;

final class DynamoDbBigSegmentStoreImpl
extends DynamoDbStoreImplBase
implements BigSegmentStore {
    private static final String MEMBERSHIP_KEY = "big_segments_user";
    private static final String INCLUDED_ATTR = "included";
    private static final String EXCLUDED_ATTR = "excluded";
    private static final String METADATA_KEY = "big_segments_metadata";
    private static final String SYNC_TIME_ATTR = "synchronizedOn";

    DynamoDbBigSegmentStoreImpl(DynamoDbClient client, boolean wasExistingClient, String tableName, String prefix, LDLogger baseLogger) {
        super(client, wasExistingClient, tableName, prefix, baseLogger.subLogger("BigSegments").subLogger("DynamoDb"));
    }

    public BigSegmentStoreTypes.Membership getMembership(String userHash) {
        String namespaceKey = this.prefixedNamespace(MEMBERSHIP_KEY);
        GetItemResponse response = this.getItemByKeys(namespaceKey, userHash);
        if (response == null || response.item() == null || response.item().isEmpty()) {
            return null;
        }
        List<String> includedRefs = DynamoDbBigSegmentStoreImpl.stringListFromAttrValue((AttributeValue)response.item().get(INCLUDED_ATTR));
        List<String> excludedRefs = DynamoDbBigSegmentStoreImpl.stringListFromAttrValue((AttributeValue)response.item().get(EXCLUDED_ATTR));
        return BigSegmentStoreTypes.createMembershipFromSegmentRefs(includedRefs, excludedRefs);
    }

    private static List<String> stringListFromAttrValue(AttributeValue attrValue) {
        return attrValue == null ? null : attrValue.ss();
    }

    public BigSegmentStoreTypes.StoreMetadata getMetadata() {
        String key = this.prefixedNamespace(METADATA_KEY);
        GetItemResponse response = this.getItemByKeys(key, key);
        if (response == null || response.item() == null) {
            return null;
        }
        AttributeValue syncTimeValue = (AttributeValue)response.item().get(SYNC_TIME_ATTR);
        if (syncTimeValue == null) {
            return null;
        }
        String syncTimeString = syncTimeValue.n();
        if (syncTimeString == null) {
            return null;
        }
        return new BigSegmentStoreTypes.StoreMetadata(Long.parseLong(syncTimeString));
    }
}

