/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server.integrations;

import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.sdk.server.integrations.CollectionHelpers;
import com.launchdarkly.sdk.server.integrations.DynamoDbStoreImplBase;
import com.launchdarkly.sdk.server.subsystems.DataStoreTypes;
import com.launchdarkly.sdk.server.subsystems.PersistentDataStore;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ComparisonOperator;
import software.amazon.awssdk.services.dynamodb.model.Condition;
import software.amazon.awssdk.services.dynamodb.model.ConditionalCheckFailedException;
import software.amazon.awssdk.services.dynamodb.model.GetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.QueryRequest;
import software.amazon.awssdk.services.dynamodb.model.QueryResponse;
import software.amazon.awssdk.services.dynamodb.model.WriteRequest;
import software.amazon.awssdk.services.dynamodb.paginators.QueryIterable;

final class DynamoDbDataStoreImpl
extends DynamoDbStoreImplBase
implements PersistentDataStore {
    private static final String versionAttribute = "version";
    private static final String itemJsonAttribute = "item";
    private static final String deletedItemPlaceholder = "null";
    private static final int DYNAMO_DB_MAX_ITEM_SIZE = 400000;
    private Runnable updateHook;

    DynamoDbDataStoreImpl(DynamoDbClient client, boolean wasExistingClient, String tableName, String prefix, LDLogger baseLogger) {
        super(client, wasExistingClient, tableName, prefix, baseLogger.subLogger("DataStore").subLogger("DynamoDb"));
    }

    public DataStoreTypes.SerializedItemDescriptor get(DataStoreTypes.DataKind kind, String key) {
        GetItemResponse resp = this.getItemByKeys(this.namespaceForKind(kind), key);
        return this.unmarshalItem(kind, resp.item());
    }

    public DataStoreTypes.KeyedItems<DataStoreTypes.SerializedItemDescriptor> getAll(DataStoreTypes.DataKind kind) {
        ArrayList<AbstractMap.SimpleEntry<String, DataStoreTypes.SerializedItemDescriptor>> itemsOut = new ArrayList<AbstractMap.SimpleEntry<String, DataStoreTypes.SerializedItemDescriptor>>();
        for (QueryResponse resp : this.client.queryPaginator((QueryRequest)this.makeQueryForKind(kind).build())) {
            for (Map item : resp.items()) {
                DataStoreTypes.SerializedItemDescriptor itemOut;
                AttributeValue keyAttr = (AttributeValue)item.get("key");
                if (keyAttr == null || keyAttr.s() == null || (itemOut = this.unmarshalItem(kind, item)) == null) continue;
                itemsOut.add(new AbstractMap.SimpleEntry<String, DataStoreTypes.SerializedItemDescriptor>(keyAttr.s(), itemOut));
            }
        }
        return new DataStoreTypes.KeyedItems(itemsOut);
    }

    public void init(DataStoreTypes.FullDataSet<DataStoreTypes.SerializedItemDescriptor> allData) {
        Set<Map.Entry<String, String>> unusedOldKeys = this.readExistingKeys(allData);
        ArrayList<WriteRequest> requests = new ArrayList<WriteRequest>();
        int numItems = 0;
        for (Map.Entry entry : allData.getData()) {
            DataStoreTypes.DataKind kind = (DataStoreTypes.DataKind)entry.getKey();
            for (Map.Entry itemEntry : ((DataStoreTypes.KeyedItems)entry.getValue()).getItems()) {
                String key = (String)itemEntry.getKey();
                Map<String, AttributeValue> encodedItem = this.marshalItem(kind, key, (DataStoreTypes.SerializedItemDescriptor)itemEntry.getValue());
                if (!this.checkSizeLimit(encodedItem)) continue;
                requests.add((WriteRequest)WriteRequest.builder().putRequest(builder -> builder.item(encodedItem)).build());
                AbstractMap.SimpleEntry<String, String> combinedKey = new AbstractMap.SimpleEntry<String, String>(this.namespaceForKind(kind), key);
                unusedOldKeys.remove(combinedKey);
                ++numItems;
            }
        }
        for (Map.Entry entry : unusedOldKeys) {
            if (((String)entry.getKey()).equals(this.initedKey())) continue;
            requests.add((WriteRequest)WriteRequest.builder().deleteRequest(builder -> builder.key(this.makeKeysMap((String)combinedKey.getKey(), (String)combinedKey.getValue()))).build());
        }
        requests.add((WriteRequest)WriteRequest.builder().putRequest(builder -> builder.item(this.makeKeysMap(this.initedKey(), this.initedKey()))).build());
        DynamoDbDataStoreImpl.batchWriteRequests(this.client, this.tableName, requests);
        this.logger.info("Initialized table {} with {} items", (Object)this.tableName, (Object)numItems);
    }

    public boolean upsert(DataStoreTypes.DataKind kind, String key, DataStoreTypes.SerializedItemDescriptor newItem) {
        Map<String, AttributeValue> encodedItem = this.marshalItem(kind, key, newItem);
        if (!this.checkSizeLimit(encodedItem)) {
            return false;
        }
        if (this.updateHook != null) {
            this.updateHook.run();
        }
        try {
            this.client.putItem(builder -> builder.tableName(this.tableName).item(encodedItem).conditionExpression("attribute_not_exists(#namespace) or attribute_not_exists(#key) or :version > #version").expressionAttributeNames(CollectionHelpers.mapOf("#namespace", "namespace", "#key", "key", "#version", versionAttribute)).expressionAttributeValues(CollectionHelpers.mapOf(":version", AttributeValue.builder().n(String.valueOf(newItem.getVersion())).build())));
        }
        catch (ConditionalCheckFailedException e) {
            return false;
        }
        return true;
    }

    public boolean isInitialized() {
        GetItemResponse resp = this.getItemByKeys(this.initedKey(), this.initedKey());
        return resp.item() != null && resp.item().size() > 0;
    }

    public boolean isStoreAvailable() {
        try {
            this.isInitialized();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setUpdateHook(Runnable updateHook) {
        this.updateHook = updateHook;
    }

    private String namespaceForKind(DataStoreTypes.DataKind kind) {
        return this.prefixedNamespace(kind.getName());
    }

    private String initedKey() {
        return this.prefixedNamespace("$inited");
    }

    private QueryRequest.Builder makeQueryForKind(DataStoreTypes.DataKind kind) {
        Map<String, Object> keyConditions = CollectionHelpers.mapOf("namespace", Condition.builder().comparisonOperator(ComparisonOperator.EQ).attributeValueList(new AttributeValue[]{(AttributeValue)AttributeValue.builder().s(this.namespaceForKind(kind)).build()}).build());
        return QueryRequest.builder().tableName(this.tableName).consistentRead(Boolean.valueOf(true)).keyConditions(keyConditions);
    }

    private Set<Map.Entry<String, String>> readExistingKeys(DataStoreTypes.FullDataSet<?> kindsFromThisDataSet) {
        HashSet<Map.Entry<String, String>> keys = new HashSet<Map.Entry<String, String>>();
        for (Map.Entry e : kindsFromThisDataSet.getData()) {
            DataStoreTypes.DataKind kind = (DataStoreTypes.DataKind)e.getKey();
            QueryRequest req = (QueryRequest)this.makeQueryForKind(kind).projectionExpression("#namespace, #key").expressionAttributeNames(CollectionHelpers.mapOf("#namespace", "namespace", "#key", "key")).build();
            QueryIterable queryResults = this.client.queryPaginator(req);
            for (QueryResponse resp : queryResults) {
                for (Map item : resp.items()) {
                    String namespace = ((AttributeValue)item.get("namespace")).s();
                    String key = ((AttributeValue)item.get("key")).s();
                    keys.add(new AbstractMap.SimpleEntry<String, String>(namespace, key));
                }
            }
        }
        return keys;
    }

    private Map<String, AttributeValue> marshalItem(DataStoreTypes.DataKind kind, String key, DataStoreTypes.SerializedItemDescriptor item) {
        String json = item.isDeleted() ? deletedItemPlaceholder : item.getSerializedItem();
        return CollectionHelpers.mapOf("namespace", AttributeValue.builder().s(this.namespaceForKind(kind)).build(), "key", AttributeValue.builder().s(key).build(), versionAttribute, AttributeValue.builder().n(String.valueOf(item.getVersion())).build(), itemJsonAttribute, AttributeValue.builder().s(json).build());
    }

    private DataStoreTypes.SerializedItemDescriptor unmarshalItem(DataStoreTypes.DataKind kind, Map<String, AttributeValue> item) {
        int version;
        if (item == null || item.size() == 0) {
            return null;
        }
        AttributeValue jsonAttr = item.get(itemJsonAttribute);
        if (jsonAttr == null || jsonAttr.s() == null) {
            throw new IllegalStateException("DynamoDB map did not contain expected item string");
        }
        String jsonValue = jsonAttr.s();
        AttributeValue versionAttr = item.get(versionAttribute);
        if (versionAttr == null || versionAttr.n() == null) {
            throw new IllegalStateException("DynamoDB map did not contain expected version attribute");
        }
        try {
            version = Integer.parseInt(versionAttr.n());
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException("DynamoDB version attribute had a non-numeric value");
        }
        if (jsonValue.equals(deletedItemPlaceholder)) {
            return new DataStoreTypes.SerializedItemDescriptor(version, true, null);
        }
        return new DataStoreTypes.SerializedItemDescriptor(version, false, jsonValue);
    }

    static void batchWriteRequests(DynamoDbClient client, String tableName, List<WriteRequest> requests) {
        int batchSize = 25;
        for (int i = 0; i < requests.size(); i += batchSize) {
            int limit = i + batchSize < requests.size() ? i + batchSize : requests.size();
            List<WriteRequest> batch = requests.subList(i, limit);
            Map<String, List<WriteRequest>> batchMap = CollectionHelpers.mapOf(tableName, batch);
            client.batchWriteItem(builder -> builder.requestItems(batchMap));
        }
    }

    private boolean checkSizeLimit(Map<String, AttributeValue> item) {
        int size = 100;
        for (Map.Entry<String, AttributeValue> kv : item.entrySet()) {
            size += DynamoDbDataStoreImpl.utf8Length(kv.getKey());
            if (kv.getValue().s() != null) {
                size += DynamoDbDataStoreImpl.utf8Length(kv.getValue().s());
                continue;
            }
            if (kv.getValue().n() == null) continue;
            size += DynamoDbDataStoreImpl.utf8Length(kv.getValue().n());
        }
        if (size <= 400000) {
            return true;
        }
        this.logger.error("The item \"{}\" in \"{}\" was too large to store in DynamoDB and was dropped", (Object)item.get("key").s(), (Object)item.get("namespace").s());
        return false;
    }

    private static int utf8Length(String s) {
        if (s == null) {
            return 0;
        }
        int count = 0;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            if (ch <= '\u007f') {
                ++count;
                continue;
            }
            if (ch <= '\u07ff') {
                count += 2;
                continue;
            }
            if (Character.isHighSurrogate(ch)) {
                count += 4;
                ++i;
                continue;
            }
            count += 3;
        }
        return count;
    }
}

