/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server.integrations;

import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.server.integrations.DynamoDbBigSegmentStoreImpl;
import com.launchdarkly.sdk.server.integrations.DynamoDbDataStoreImpl;
import com.launchdarkly.sdk.server.subsystems.BigSegmentStore;
import com.launchdarkly.sdk.server.subsystems.ClientContext;
import com.launchdarkly.sdk.server.subsystems.ComponentConfigurer;
import com.launchdarkly.sdk.server.subsystems.DiagnosticDescription;
import com.launchdarkly.sdk.server.subsystems.PersistentDataStore;
import java.net.URI;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClientBuilder;

public abstract class DynamoDbStoreBuilder<T>
implements ComponentConfigurer<T>,
DiagnosticDescription {
    final String tableName;
    String prefix;
    DynamoDbClient existingClient;
    DynamoDbClientBuilder clientBuilder;

    private DynamoDbStoreBuilder(String tableName) {
        this.tableName = tableName;
        this.clientBuilder = DynamoDbClient.builder();
    }

    public DynamoDbStoreBuilder<T> clientOverrideConfiguration(ClientOverrideConfiguration config) {
        this.clientBuilder.overrideConfiguration(config);
        return this;
    }

    public DynamoDbStoreBuilder<T> credentials(AwsCredentialsProvider credentialsProvider) {
        this.clientBuilder.credentialsProvider(credentialsProvider);
        return this;
    }

    public DynamoDbStoreBuilder<T> endpoint(URI endpointUri) {
        this.clientBuilder.endpointOverride(endpointUri);
        return this;
    }

    public DynamoDbStoreBuilder<T> region(Region region) {
        this.clientBuilder.region(region);
        return this;
    }

    public DynamoDbStoreBuilder<T> prefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public DynamoDbStoreBuilder<T> existingClient(DynamoDbClient existingClient) {
        this.existingClient = existingClient;
        return this;
    }

    public LDValue describeConfiguration(ClientContext context) {
        return LDValue.of((String)"DynamoDB");
    }

    DynamoDbClient makeClient() {
        return this.existingClient != null ? this.existingClient : (DynamoDbClient)this.clientBuilder.build();
    }

    static final class ForBigSegments
    extends DynamoDbStoreBuilder<BigSegmentStore> {
        ForBigSegments(String tableName) {
            super(tableName);
        }

        public BigSegmentStore build(ClientContext clientContext) {
            return new DynamoDbBigSegmentStoreImpl(this.existingClient != null ? this.existingClient : (DynamoDbClient)this.clientBuilder.build(), this.existingClient != null, this.tableName, this.prefix, clientContext.getBaseLogger());
        }
    }

    static final class ForDataStore
    extends DynamoDbStoreBuilder<PersistentDataStore> {
        ForDataStore(String tableName) {
            super(tableName);
        }

        public PersistentDataStore build(ClientContext clientContext) {
            return new DynamoDbDataStoreImpl(this.existingClient != null ? this.existingClient : (DynamoDbClient)this.clientBuilder.build(), this.existingClient != null, this.tableName, this.prefix, clientContext.getBaseLogger());
        }
    }
}

