/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server.integrations;

import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.sdk.server.integrations.CollectionHelpers;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.GetItemResponse;

abstract class DynamoDbStoreImplBase
implements Closeable {
    static final String PARTITION_KEY = "namespace";
    static final String SORT_KEY = "key";
    protected final DynamoDbClient client;
    protected final boolean wasExistingClient;
    protected final String tableName;
    protected final String prefix;
    protected final LDLogger logger;

    public DynamoDbStoreImplBase(DynamoDbClient client, boolean wasExistingClient, String tableName, String prefix, LDLogger logger) {
        this.client = client;
        this.wasExistingClient = wasExistingClient;
        this.tableName = tableName;
        this.prefix = "".equals(prefix) ? null : prefix;
        this.logger = logger;
    }

    protected String prefixedNamespace(String base) {
        return this.prefix == null ? base : this.prefix + ":" + base;
    }

    protected Map<String, AttributeValue> makeKeysMap(String partitionKey, String sortKey) {
        return CollectionHelpers.mapOf(PARTITION_KEY, AttributeValue.builder().s(partitionKey).build(), SORT_KEY, AttributeValue.builder().s(sortKey).build());
    }

    protected GetItemResponse getItemByKeys(String namespace, String key) {
        return this.client.getItem(builder -> builder.tableName(this.tableName).consistentRead(Boolean.valueOf(true)).key(this.makeKeysMap(namespace, key)));
    }

    @Override
    public void close() throws IOException {
        if (!this.wasExistingClient) {
            this.client.close();
        }
    }
}

