/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server.integrations;

import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.sdk.server.integrations.RedisStoreBuilder;
import com.launchdarkly.sdk.server.integrations.RedisStoreImplBase;
import com.launchdarkly.sdk.server.subsystems.BigSegmentStore;
import com.launchdarkly.sdk.server.subsystems.BigSegmentStoreTypes;
import java.util.Set;
import redis.clients.jedis.Jedis;

final class RedisBigSegmentStoreImpl
extends RedisStoreImplBase
implements BigSegmentStore {
    private final String syncTimeKey;
    private final String includedKeyPrefix;
    private final String excludedKeyPrefix;

    RedisBigSegmentStoreImpl(RedisStoreBuilder<BigSegmentStore> builder, LDLogger baseLogger) {
        super(builder, baseLogger.subLogger("BigSegments").subLogger("Redis"));
        this.syncTimeKey = this.prefix + ":big_segments_synchronized_on";
        this.includedKeyPrefix = this.prefix + ":big_segment_include:";
        this.excludedKeyPrefix = this.prefix + ":big_segment_exclude:";
    }

    public BigSegmentStoreTypes.Membership getMembership(String userHash) {
        try (Jedis jedis = this.pool.getResource();){
            Set includedRefs = jedis.smembers(this.includedKeyPrefix + userHash);
            Set excludedRefs = jedis.smembers(this.excludedKeyPrefix + userHash);
            BigSegmentStoreTypes.Membership membership = BigSegmentStoreTypes.createMembershipFromSegmentRefs((Iterable)includedRefs, (Iterable)excludedRefs);
            return membership;
        }
    }

    public BigSegmentStoreTypes.StoreMetadata getMetadata() {
        try (Jedis jedis = this.pool.getResource();){
            String value = jedis.get(this.syncTimeKey);
            if (value == null || value.isEmpty()) {
                BigSegmentStoreTypes.StoreMetadata storeMetadata = null;
                return storeMetadata;
            }
            BigSegmentStoreTypes.StoreMetadata storeMetadata = new BigSegmentStoreTypes.StoreMetadata(Long.parseLong(value));
            return storeMetadata;
        }
    }
}

