/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server.integrations;

import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.sdk.server.integrations.RedisStoreBuilder;
import com.launchdarkly.sdk.server.integrations.RedisStoreImplBase;
import com.launchdarkly.sdk.server.subsystems.DataStoreTypes;
import com.launchdarkly.sdk.server.subsystems.PersistentDataStore;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Transaction;

final class RedisDataStoreImpl
extends RedisStoreImplBase
implements PersistentDataStore {
    private UpdateListener updateListener;

    RedisDataStoreImpl(RedisStoreBuilder<PersistentDataStore> builder, LDLogger baseLogger) {
        super(builder, baseLogger.subLogger("DataStore").subLogger("Redis"));
    }

    public DataStoreTypes.SerializedItemDescriptor get(DataStoreTypes.DataKind kind, String key) {
        try (Jedis jedis = this.pool.getResource();){
            String item = this.getRedis(kind, key, jedis);
            DataStoreTypes.SerializedItemDescriptor serializedItemDescriptor = item == null ? null : new DataStoreTypes.SerializedItemDescriptor(0, false, item);
            return serializedItemDescriptor;
        }
    }

    public DataStoreTypes.KeyedItems<DataStoreTypes.SerializedItemDescriptor> getAll(DataStoreTypes.DataKind kind) {
        try (Jedis jedis = this.pool.getResource();){
            Map allJson = jedis.hgetAll(this.itemsKey(kind));
            ArrayList itemsOut = new ArrayList(allJson.size());
            for (Map.Entry e : allJson.entrySet()) {
                itemsOut.add(new AbstractMap.SimpleEntry(e.getKey(), new DataStoreTypes.SerializedItemDescriptor(0, false, (String)e.getValue())));
            }
            DataStoreTypes.KeyedItems keyedItems = new DataStoreTypes.KeyedItems(itemsOut);
            return keyedItems;
        }
    }

    public void init(DataStoreTypes.FullDataSet<DataStoreTypes.SerializedItemDescriptor> allData) {
        try (Jedis jedis = this.pool.getResource();){
            Transaction t = jedis.multi();
            for (Map.Entry e0 : allData.getData()) {
                DataStoreTypes.DataKind kind = (DataStoreTypes.DataKind)e0.getKey();
                String baseKey = this.itemsKey(kind);
                t.del(baseKey);
                for (Map.Entry e1 : ((DataStoreTypes.KeyedItems)e0.getValue()).getItems()) {
                    t.hset(baseKey, (String)e1.getKey(), RedisDataStoreImpl.jsonOrPlaceholder(kind, (DataStoreTypes.SerializedItemDescriptor)e1.getValue()));
                }
            }
            t.set(this.initedKey(), "");
            t.exec();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean upsert(DataStoreTypes.DataKind kind, String key, DataStoreTypes.SerializedItemDescriptor newItem) {
        while (true) {
            Jedis jedis = null;
            try {
                String oldItemJson;
                int oldVersion;
                jedis = this.pool.getResource();
                String baseKey = this.itemsKey(kind);
                jedis.watch(new String[]{baseKey});
                if (this.updateListener != null) {
                    this.updateListener.aboutToUpdate(baseKey, key);
                }
                int n = oldVersion = (oldItemJson = this.getRedis(kind, key, jedis)) == null ? -1 : kind.deserialize(oldItemJson).getVersion();
                if (oldVersion >= newItem.getVersion()) {
                    this.logger.debug("Attempted to {} key: {} version: {} with a version that is the same or older: {} in \"{}\"", new Object[]{newItem.getSerializedItem() == null ? "delete" : "update", key, oldVersion, newItem.getVersion(), kind.getName()});
                    boolean bl = false;
                    return bl;
                }
                Transaction tx = jedis.multi();
                tx.hset(baseKey, key, RedisDataStoreImpl.jsonOrPlaceholder(kind, newItem));
                List result = tx.exec();
                if (result == null || result.isEmpty()) {
                    this.logger.debug((Object)"Concurrent modification detected, retrying");
                    continue;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                if (jedis == null) continue;
                jedis.unwatch();
                jedis.close();
                continue;
            }
            break;
        }
    }

    public boolean isInitialized() {
        try (Jedis jedis = this.pool.getResource();){
            boolean bl = jedis.exists(this.initedKey());
            return bl;
        }
    }

    public boolean isStoreAvailable() {
        try {
            this.isInitialized();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    void setUpdateListener(UpdateListener updateListener) {
        this.updateListener = updateListener;
    }

    private String itemsKey(DataStoreTypes.DataKind kind) {
        return this.prefix + ":" + kind.getName();
    }

    private String initedKey() {
        return this.prefix + ":$inited";
    }

    private String getRedis(DataStoreTypes.DataKind kind, String key, Jedis jedis) {
        String json = jedis.hget(this.itemsKey(kind), key);
        if (json == null) {
            this.logger.debug("[get] Key: {} not found in \"{}\". Returning null", (Object)key, (Object)kind.getName());
        }
        return json;
    }

    private static String jsonOrPlaceholder(DataStoreTypes.DataKind kind, DataStoreTypes.SerializedItemDescriptor serializedItem) {
        String s = serializedItem.getSerializedItem();
        if (s != null) {
            return s;
        }
        return kind.serialize(DataStoreTypes.ItemDescriptor.deletedItem((int)serializedItem.getVersion()));
    }

    static interface UpdateListener {
        public void aboutToUpdate(String var1, String var2);
    }
}

