/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server.integrations;

import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.server.integrations.RedisBigSegmentStoreImpl;
import com.launchdarkly.sdk.server.integrations.RedisDataStoreImpl;
import com.launchdarkly.sdk.server.subsystems.BigSegmentStore;
import com.launchdarkly.sdk.server.subsystems.ClientContext;
import com.launchdarkly.sdk.server.subsystems.ComponentConfigurer;
import com.launchdarkly.sdk.server.subsystems.DiagnosticDescription;
import com.launchdarkly.sdk.server.subsystems.PersistentDataStore;
import java.net.URI;
import java.time.Duration;
import redis.clients.jedis.JedisPoolConfig;

public abstract class RedisStoreBuilder<T>
implements ComponentConfigurer<T>,
DiagnosticDescription {
    public static final URI DEFAULT_URI = URI.create("redis://localhost:6379");
    public static final String DEFAULT_PREFIX = "launchdarkly";
    URI uri = DEFAULT_URI;
    String prefix = "launchdarkly";
    Duration connectTimeout = Duration.ofMillis(2000L);
    Duration socketTimeout = Duration.ofMillis(2000L);
    Integer database = null;
    String password = null;
    boolean tls = false;
    JedisPoolConfig poolConfig = null;

    RedisStoreBuilder() {
    }

    public RedisStoreBuilder<T> database(Integer database) {
        this.database = database;
        return this;
    }

    public RedisStoreBuilder<T> password(String password) {
        this.password = password;
        return this;
    }

    public RedisStoreBuilder<T> tls(boolean tls) {
        this.tls = tls;
        return this;
    }

    public RedisStoreBuilder<T> uri(URI redisUri) {
        this.uri = redisUri;
        return this;
    }

    public RedisStoreBuilder<T> prefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public RedisStoreBuilder<T> poolConfig(JedisPoolConfig poolConfig) {
        this.poolConfig = poolConfig;
        return this;
    }

    public RedisStoreBuilder<T> connectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout == null ? Duration.ofMillis(2000L) : connectTimeout;
        return this;
    }

    public RedisStoreBuilder<T> socketTimeout(Duration socketTimeout) {
        this.socketTimeout = socketTimeout == null ? Duration.ofMillis(2000L) : socketTimeout;
        return this;
    }

    public LDValue describeConfiguration(ClientContext clientContext) {
        return LDValue.of((String)"Redis");
    }

    static final class ForBigSegments
    extends RedisStoreBuilder<BigSegmentStore> {
        ForBigSegments() {
        }

        public BigSegmentStore build(ClientContext clientContext) {
            return new RedisBigSegmentStoreImpl(this, clientContext.getBaseLogger());
        }
    }

    static final class ForDataStore
    extends RedisStoreBuilder<PersistentDataStore> {
        ForDataStore() {
        }

        public PersistentDataStore build(ClientContext clientContext) {
            return new RedisDataStoreImpl(this, clientContext.getBaseLogger());
        }
    }
}

