/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.server.integrations;

import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.sdk.server.integrations.RedisStoreBuilder;
import com.launchdarkly.sdk.server.integrations.RedisURIComponents;
import java.io.Closeable;
import java.io.IOException;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

abstract class RedisStoreImplBase
implements Closeable {
    protected final LDLogger logger;
    protected final JedisPool pool;
    protected final String prefix;

    protected RedisStoreImplBase(RedisStoreBuilder<?> builder, LDLogger logger) {
        String extra;
        this.logger = logger;
        String host = builder.uri.getHost();
        int port = builder.uri.getPort();
        String password = builder.password == null ? RedisURIComponents.getPassword(builder.uri) : builder.password;
        int database = builder.database == null ? RedisURIComponents.getDBIndex(builder.uri) : builder.database;
        boolean tls = builder.tls || builder.uri.getScheme().equals("rediss");
        String string = extra = tls ? " with TLS" : "";
        if (password != null) {
            extra = extra + (extra.isEmpty() ? " with" : " and") + " password";
        }
        logger.info("Using Redis data store at {}:{}/{}{}", new Object[]{host, port, database, extra});
        JedisPoolConfig poolConfig = builder.poolConfig != null ? builder.poolConfig : new JedisPoolConfig();
        this.prefix = builder.prefix == null || builder.prefix.isEmpty() ? "launchdarkly" : builder.prefix;
        this.pool = new JedisPool((GenericObjectPoolConfig)poolConfig, host, port, (int)builder.connectTimeout.toMillis(), (int)builder.socketTimeout.toMillis(), password, database, null, tls, null, null, null);
    }

    @Override
    public void close() throws IOException {
        this.logger.info((Object)"Closing Redis store");
        this.pool.destroy();
    }
}

