/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.launchdarkly.client.Event;
import com.launchdarkly.client.EventFactory;
import com.launchdarkly.client.EventOutputFormatter;
import com.launchdarkly.client.EventProcessor;
import com.launchdarkly.client.EventSummarizer;
import com.launchdarkly.client.LDConfig;
import com.launchdarkly.client.LDUser;
import com.launchdarkly.client.SimpleLRUCache;
import com.launchdarkly.client.Util;
import com.launchdarkly.shaded.com.google.common.annotations.VisibleForTesting;
import com.launchdarkly.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.launchdarkly.shaded.okhttp3.MediaType;
import com.launchdarkly.shaded.okhttp3.OkHttpClient;
import com.launchdarkly.shaded.okhttp3.Request;
import com.launchdarkly.shaded.okhttp3.RequestBody;
import com.launchdarkly.shaded.okhttp3.Response;
import java.io.IOException;
import java.io.StringWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultEventProcessor
implements EventProcessor {
    private static final Logger logger = LoggerFactory.getLogger(DefaultEventProcessor.class);
    private static final String EVENT_SCHEMA_HEADER = "X-LaunchDarkly-Event-Schema";
    private static final String EVENT_SCHEMA_VERSION = "3";
    private final BlockingQueue<EventProcessorMessage> inbox;
    private final ScheduledExecutorService scheduler;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private volatile boolean inputCapacityExceeded = false;

    DefaultEventProcessor(String sdkKey, LDConfig config) {
        this.inbox = new ArrayBlockingQueue<EventProcessorMessage>(config.capacity);
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("LaunchDarkly-EventProcessor-%d").setPriority(1).build();
        this.scheduler = Executors.newSingleThreadScheduledExecutor(threadFactory);
        new EventDispatcher(sdkKey, config, this.inbox, threadFactory, this.closed);
        Runnable flusher = new Runnable(){

            @Override
            public void run() {
                DefaultEventProcessor.this.postMessageAsync(MessageType.FLUSH, null);
            }
        };
        this.scheduler.scheduleAtFixedRate(flusher, config.flushInterval, config.flushInterval, TimeUnit.SECONDS);
        Runnable userKeysFlusher = new Runnable(){

            @Override
            public void run() {
                DefaultEventProcessor.this.postMessageAsync(MessageType.FLUSH_USERS, null);
            }
        };
        this.scheduler.scheduleAtFixedRate(userKeysFlusher, config.userKeysFlushInterval, config.userKeysFlushInterval, TimeUnit.SECONDS);
    }

    @Override
    public void sendEvent(Event e) {
        if (!this.closed.get()) {
            this.postMessageAsync(MessageType.EVENT, e);
        }
    }

    @Override
    public void flush() {
        if (!this.closed.get()) {
            this.postMessageAsync(MessageType.FLUSH, null);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            this.scheduler.shutdown();
            this.postMessageAsync(MessageType.FLUSH, null);
            this.postMessageAndWait(MessageType.SHUTDOWN, null);
        }
    }

    @VisibleForTesting
    void waitUntilInactive() throws IOException {
        this.postMessageAndWait(MessageType.SYNC, null);
    }

    private void postMessageAsync(MessageType type, Event event) {
        this.postToChannel(new EventProcessorMessage(type, event, false));
    }

    private void postMessageAndWait(MessageType type, Event event) {
        EventProcessorMessage message = new EventProcessorMessage(type, event, true);
        if (this.postToChannel(message)) {
            message.waitForCompletion();
        }
    }

    private boolean postToChannel(EventProcessorMessage message) {
        if (this.inbox.offer(message)) {
            return true;
        }
        boolean alreadyLogged = this.inputCapacityExceeded;
        this.inputCapacityExceeded = true;
        if (!alreadyLogged) {
            logger.warn("Events are being produced faster than they can be processed; some events will be dropped");
        }
        return false;
    }

    private static final class SendEventsTask
    implements Runnable {
        private final String sdkKey;
        private final LDConfig config;
        private final OkHttpClient httpClient;
        private final EventResponseListener responseListener;
        private final BlockingQueue<FlushPayload> payloadQueue;
        private final AtomicInteger activeFlushWorkersCount;
        private final AtomicBoolean stopping;
        private final EventOutputFormatter formatter;
        private final Thread thread;
        private final SimpleDateFormat httpDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");

        SendEventsTask(String sdkKey, LDConfig config, OkHttpClient httpClient, EventResponseListener responseListener, BlockingQueue<FlushPayload> payloadQueue, AtomicInteger activeFlushWorkersCount, ThreadFactory threadFactory) {
            this.sdkKey = sdkKey;
            this.config = config;
            this.httpClient = httpClient;
            this.formatter = new EventOutputFormatter(config);
            this.responseListener = responseListener;
            this.payloadQueue = payloadQueue;
            this.activeFlushWorkersCount = activeFlushWorkersCount;
            this.stopping = new AtomicBoolean(false);
            this.thread = threadFactory.newThread(this);
            this.thread.setDaemon(true);
            this.thread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.stopping.get()) {
                FlushPayload payload = null;
                try {
                    payload = this.payloadQueue.take();
                }
                catch (InterruptedException e) {
                    continue;
                }
                try {
                    StringWriter stringWriter = new StringWriter();
                    int outputEventCount = this.formatter.writeOutputEvents(payload.events, payload.summary, stringWriter);
                    if (outputEventCount > 0) {
                        this.postEvents(stringWriter.toString(), outputEventCount);
                    }
                }
                catch (Exception e) {
                    logger.error("Unexpected error in event processor: {}", (Object)e.toString());
                    logger.debug(e.toString(), (Throwable)e);
                }
                AtomicInteger atomicInteger = this.activeFlushWorkersCount;
                synchronized (atomicInteger) {
                    this.activeFlushWorkersCount.decrementAndGet();
                    this.activeFlushWorkersCount.notifyAll();
                }
            }
        }

        void stop() {
            this.stopping.set(true);
            this.thread.interrupt();
        }

        private void postEvents(String json, int outputEventCount) {
            String uriStr = this.config.eventsURI.toString() + "/bulk";
            logger.debug("Posting {} event(s) to {} with payload: {}", new Object[]{outputEventCount, uriStr, json});
            for (int attempt = 0; attempt < 2; ++attempt) {
                if (attempt > 0) {
                    logger.warn("Will retry posting events after 1 second");
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                Request request = Util.getRequestBuilder(this.sdkKey).url(uriStr).post(RequestBody.create(MediaType.parse("application/json; charset=utf-8"), json)).addHeader("Content-Type", "application/json").addHeader(DefaultEventProcessor.EVENT_SCHEMA_HEADER, DefaultEventProcessor.EVENT_SCHEMA_VERSION).build();
                long startTime = System.currentTimeMillis();
                try (Response response = this.httpClient.newCall(request).execute();){
                    long endTime = System.currentTimeMillis();
                    logger.debug("Event delivery took {} ms, response status {}", (Object)(endTime - startTime), (Object)response.code());
                    if (!response.isSuccessful()) {
                        logger.warn("Unexpected response status when posting events: {}", (Object)response.code());
                        if (Util.isHttpErrorRecoverable(response.code())) continue;
                    }
                    this.responseListener.handleResponse(response, this.getResponseDate(response));
                    break;
                }
                catch (IOException e) {
                    logger.warn("Unhandled exception in LaunchDarkly client when posting events to URL: " + request.url(), (Throwable)e);
                }
            }
        }

        private Date getResponseDate(Response response) {
            String dateStr = response.header("Date");
            if (dateStr != null) {
                try {
                    return this.httpDateFormat.parse(dateStr);
                }
                catch (ParseException e) {
                    logger.warn("Received invalid Date header from events service");
                }
            }
            return null;
        }
    }

    private static interface EventResponseListener {
        public void handleResponse(Response var1, Date var2);
    }

    private static final class FlushPayload {
        final Event[] events;
        final EventSummarizer.EventSummary summary;

        FlushPayload(Event[] events, EventSummarizer.EventSummary summary) {
            this.events = events;
            this.summary = summary;
        }
    }

    private static final class EventBuffer {
        final List<Event> events = new ArrayList<Event>();
        final EventSummarizer summarizer = new EventSummarizer();
        private final int capacity;
        private boolean capacityExceeded = false;

        EventBuffer(int capacity) {
            this.capacity = capacity;
        }

        void add(Event e) {
            if (this.events.size() >= this.capacity) {
                if (!this.capacityExceeded) {
                    this.capacityExceeded = true;
                    logger.warn("Exceeded event queue capacity. Increase capacity to avoid dropping events.");
                }
            } else {
                this.capacityExceeded = false;
                this.events.add(e);
            }
        }

        void addToSummary(Event e) {
            this.summarizer.summarizeEvent(e);
        }

        boolean isEmpty() {
            return this.events.isEmpty() && this.summarizer.snapshot().isEmpty();
        }

        FlushPayload getPayload() {
            Event[] eventsOut = this.events.toArray(new Event[this.events.size()]);
            EventSummarizer.EventSummary summary = this.summarizer.snapshot();
            return new FlushPayload(eventsOut, summary);
        }

        void clear() {
            this.events.clear();
            this.summarizer.clear();
        }
    }

    static final class EventDispatcher {
        private static final int MAX_FLUSH_THREADS = 5;
        private static final int MESSAGE_BATCH_SIZE = 50;
        private final LDConfig config;
        private final OkHttpClient httpClient;
        private final List<SendEventsTask> flushWorkers;
        private final AtomicInteger busyFlushWorkersCount;
        private final Random random = new Random();
        private final AtomicLong lastKnownPastTime = new AtomicLong(0L);
        private final AtomicBoolean disabled = new AtomicBoolean(false);

        private EventDispatcher(String sdkKey, LDConfig config, final BlockingQueue<EventProcessorMessage> inbox, ThreadFactory threadFactory, final AtomicBoolean closed) {
            this.config = config;
            this.busyFlushWorkersCount = new AtomicInteger(0);
            OkHttpClient.Builder httpBuilder = new OkHttpClient.Builder();
            Util.configureHttpClientBuilder(config, httpBuilder);
            this.httpClient = httpBuilder.build();
            final ArrayBlockingQueue<FlushPayload> payloadQueue = new ArrayBlockingQueue<FlushPayload>(1);
            final EventBuffer outbox = new EventBuffer(config.capacity);
            final SimpleLRUCache userKeys = new SimpleLRUCache(config.userKeysCapacity);
            Thread mainThread = threadFactory.newThread(new Runnable(){

                @Override
                public void run() {
                    EventDispatcher.this.runMainLoop(inbox, outbox, userKeys, payloadQueue);
                }
            });
            mainThread.setDaemon(true);
            mainThread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    logger.error("Event processor thread was terminated by an unrecoverable error. No more analytics events will be sent.", e);
                    closed.set(true);
                    ArrayList messages = new ArrayList();
                    inbox.drainTo(messages);
                    for (EventProcessorMessage m : messages) {
                        m.completed();
                    }
                }
            });
            mainThread.start();
            this.flushWorkers = new ArrayList<SendEventsTask>();
            EventResponseListener listener = new EventResponseListener(){

                @Override
                public void handleResponse(Response response, Date responseDate) {
                    EventDispatcher.this.handleResponse(response, responseDate);
                }
            };
            for (int i = 0; i < 5; ++i) {
                SendEventsTask task = new SendEventsTask(sdkKey, config, this.httpClient, listener, payloadQueue, this.busyFlushWorkersCount, threadFactory);
                this.flushWorkers.add(task);
            }
        }

        private void runMainLoop(BlockingQueue<EventProcessorMessage> inbox, EventBuffer outbox, SimpleLRUCache<String, String> userKeys, BlockingQueue<FlushPayload> payloadQueue) {
            ArrayList<EventProcessorMessage> batch = new ArrayList<EventProcessorMessage>(50);
            while (true) {
                try {
                    block11: while (true) {
                        batch.clear();
                        batch.add(inbox.take());
                        inbox.drainTo(batch, 49);
                        Iterator iterator = batch.iterator();
                        while (true) {
                            if (!iterator.hasNext()) continue block11;
                            EventProcessorMessage message = (EventProcessorMessage)iterator.next();
                            switch (message.type) {
                                case EVENT: {
                                    this.processEvent(message.event, userKeys, outbox);
                                    break;
                                }
                                case FLUSH: {
                                    this.triggerFlush(outbox, payloadQueue);
                                    break;
                                }
                                case FLUSH_USERS: {
                                    userKeys.clear();
                                    break;
                                }
                                case SYNC: {
                                    this.waitUntilAllFlushWorkersInactive();
                                    break;
                                }
                                case SHUTDOWN: {
                                    this.doShutdown();
                                    message.completed();
                                    return;
                                }
                            }
                            message.completed();
                        }
                        break;
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                catch (Exception e) {
                    logger.error("Unexpected error in event processor: {}", (Object)e.toString());
                    logger.debug(e.toString(), (Throwable)e);
                    continue;
                }
                break;
            }
        }

        private void doShutdown() {
            this.waitUntilAllFlushWorkersInactive();
            this.disabled.set(true);
            for (SendEventsTask task : this.flushWorkers) {
                task.stop();
            }
            Util.shutdownHttpClient(this.httpClient);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void waitUntilAllFlushWorkersInactive() {
            while (true) {
                try {
                    while (true) {
                        AtomicInteger atomicInteger = this.busyFlushWorkersCount;
                        synchronized (atomicInteger) {
                            if (this.busyFlushWorkersCount.get() == 0) {
                                return;
                            }
                            this.busyFlushWorkersCount.wait();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        private void processEvent(Event e, SimpleLRUCache<String, String> userKeys, EventBuffer outbox) {
            if (this.disabled.get()) {
                return;
            }
            outbox.addToSummary(e);
            boolean addIndexEvent = false;
            boolean addFullEvent = false;
            Event.FeatureRequest debugEvent = null;
            if (e instanceof Event.FeatureRequest) {
                if (this.shouldSampleEvent()) {
                    Event.FeatureRequest fe = (Event.FeatureRequest)e;
                    addFullEvent = fe.trackEvents;
                    if (this.shouldDebugEvent(fe)) {
                        debugEvent = EventFactory.DEFAULT.newDebugEvent(fe);
                    }
                }
            } else {
                addFullEvent = this.shouldSampleEvent();
            }
            if (!(addFullEvent && this.config.inlineUsersInEvents || e.user == null || e.user.getKey() == null || this.noticeUser(e.user, userKeys) || e instanceof Event.Identify)) {
                addIndexEvent = true;
            }
            if (addIndexEvent) {
                Event.Index ie = new Event.Index(e.creationDate, e.user);
                outbox.add(ie);
            }
            if (addFullEvent) {
                outbox.add(e);
            }
            if (debugEvent != null) {
                outbox.add(debugEvent);
            }
        }

        private boolean noticeUser(LDUser user, SimpleLRUCache<String, String> userKeys) {
            if (user == null || user.getKey() == null) {
                return false;
            }
            String key = user.getKeyAsString();
            return userKeys.put(key, key) != null;
        }

        private boolean shouldSampleEvent() {
            return this.config.samplingInterval <= 0 || this.random.nextInt(this.config.samplingInterval) == 0;
        }

        private boolean shouldDebugEvent(Event.FeatureRequest fe) {
            if (fe.debugEventsUntilDate != null) {
                long lastPast = this.lastKnownPastTime.get();
                if (fe.debugEventsUntilDate > lastPast && fe.debugEventsUntilDate > System.currentTimeMillis()) {
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void triggerFlush(EventBuffer outbox, BlockingQueue<FlushPayload> payloadQueue) {
            if (this.disabled.get() || outbox.isEmpty()) {
                return;
            }
            FlushPayload payload = outbox.getPayload();
            this.busyFlushWorkersCount.incrementAndGet();
            if (payloadQueue.offer(payload)) {
                outbox.clear();
            } else {
                logger.debug("Skipped flushing because all workers are busy");
                AtomicInteger atomicInteger = this.busyFlushWorkersCount;
                synchronized (atomicInteger) {
                    this.busyFlushWorkersCount.decrementAndGet();
                    this.busyFlushWorkersCount.notify();
                }
            }
        }

        private void handleResponse(Response response, Date responseDate) {
            if (responseDate != null) {
                this.lastKnownPastTime.set(responseDate.getTime());
            }
            if (!Util.isHttpErrorRecoverable(response.code())) {
                this.disabled.set(true);
                logger.error(Util.httpErrorMessage(response.code(), "posting events", "some events were dropped"));
            }
        }
    }

    private static final class EventProcessorMessage {
        private final MessageType type;
        private final Event event;
        private final Semaphore reply;

        private EventProcessorMessage(MessageType type, Event event, boolean sync) {
            this.type = type;
            this.event = event;
            this.reply = sync ? new Semaphore(0) : null;
        }

        void completed() {
            if (this.reply != null) {
                this.reply.release();
            }
        }

        void waitForCompletion() {
            if (this.reply == null) {
                return;
            }
            while (true) {
                try {
                    this.reply.acquire();
                    return;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        public String toString() {
            return (this.event == null ? this.type.toString() : (Object)((Object)this.type) + ": " + this.event.getClass().getSimpleName()) + (this.reply == null ? "" : " (sync)");
        }
    }

    private static enum MessageType {
        EVENT,
        FLUSH,
        FLUSH_USERS,
        SYNC,
        SHUTDOWN;

    }
}

