/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.launchdarkly.client.FeatureStoreCacheConfig;
import com.launchdarkly.client.FeatureStoreFactory;
import com.launchdarkly.client.RedisFeatureStore;
import com.launchdarkly.shaded.redis.clients.jedis.JedisPoolConfig;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;

public final class RedisFeatureStoreBuilder
implements FeatureStoreFactory {
    public static final URI DEFAULT_URI = URI.create("com/launchdarkly/shaded/redis://localhost:6379");
    public static final String DEFAULT_PREFIX = "launchdarkly";
    public static final long DEFAULT_CACHE_TIME_SECONDS = 15L;
    final URI uri;
    String prefix = "launchdarkly";
    int connectTimeout = 2000;
    int socketTimeout = 2000;
    Integer database = null;
    String password = null;
    boolean tls = false;
    FeatureStoreCacheConfig caching = FeatureStoreCacheConfig.DEFAULT;
    boolean refreshStaleValues = false;
    boolean asyncRefresh = false;
    JedisPoolConfig poolConfig = null;

    RedisFeatureStoreBuilder() {
        this.uri = DEFAULT_URI;
    }

    RedisFeatureStoreBuilder(URI uri) {
        this.uri = uri;
    }

    public RedisFeatureStoreBuilder(URI uri, long cacheTimeSecs) {
        this.uri = uri;
        this.cacheTime(cacheTimeSecs, TimeUnit.SECONDS);
    }

    public RedisFeatureStoreBuilder(String scheme, String host, int port, long cacheTimeSecs) throws URISyntaxException {
        this.uri = new URI(scheme, null, host, port, null, null, null);
        this.cacheTime(cacheTimeSecs, TimeUnit.SECONDS);
    }

    public RedisFeatureStoreBuilder database(Integer database) {
        this.database = database;
        return this;
    }

    public RedisFeatureStoreBuilder password(String password) {
        this.password = password;
        return this;
    }

    public RedisFeatureStoreBuilder tls(boolean tls) {
        this.tls = tls;
        return this;
    }

    public RedisFeatureStoreBuilder caching(FeatureStoreCacheConfig caching) {
        this.caching = caching;
        return this;
    }

    public RedisFeatureStoreBuilder refreshStaleValues(boolean enabled) {
        this.refreshStaleValues = enabled;
        this.updateCachingStaleValuesPolicy();
        return this;
    }

    public RedisFeatureStoreBuilder asyncRefresh(boolean enabled) {
        this.asyncRefresh = enabled;
        this.updateCachingStaleValuesPolicy();
        return this;
    }

    private void updateCachingStaleValuesPolicy() {
        this.caching = this.refreshStaleValues ? this.caching.staleValuesPolicy(this.asyncRefresh ? FeatureStoreCacheConfig.StaleValuesPolicy.REFRESH_ASYNC : FeatureStoreCacheConfig.StaleValuesPolicy.REFRESH) : this.caching.staleValuesPolicy(FeatureStoreCacheConfig.StaleValuesPolicy.EVICT);
    }

    public RedisFeatureStoreBuilder prefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public RedisFeatureStoreBuilder cacheTime(long cacheTime, TimeUnit timeUnit) {
        this.caching = this.caching.ttl(cacheTime, timeUnit).staleValuesPolicy(this.caching.getStaleValuesPolicy());
        return this;
    }

    public RedisFeatureStoreBuilder poolConfig(JedisPoolConfig poolConfig) {
        this.poolConfig = poolConfig;
        return this;
    }

    public RedisFeatureStoreBuilder connectTimeout(int connectTimeout, TimeUnit timeUnit) {
        this.connectTimeout = (int)timeUnit.toMillis(connectTimeout);
        return this;
    }

    public RedisFeatureStoreBuilder socketTimeout(int socketTimeout, TimeUnit timeUnit) {
        this.socketTimeout = (int)timeUnit.toMillis(socketTimeout);
        return this;
    }

    public RedisFeatureStore build() {
        return new RedisFeatureStore(this);
    }

    @Override
    public RedisFeatureStore createFeatureStore() {
        return this.build();
    }
}

