/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.google.gson.stream.JsonWriter;
import com.launchdarkly.client.EvaluationReason;
import com.launchdarkly.client.Event;
import com.launchdarkly.client.EventSummarizer;
import com.launchdarkly.client.LDConfig;
import com.launchdarkly.client.LDUser;
import com.launchdarkly.client.value.LDValue;
import java.io.IOException;
import java.io.Writer;

class EventOutputFormatter {
    private final LDConfig config;

    EventOutputFormatter(LDConfig config) {
        this.config = config;
    }

    int writeOutputEvents(Event[] events, EventSummarizer.EventSummary summary, Writer writer) throws IOException {
        int count = 0;
        try (JsonWriter jsonWriter = new JsonWriter(writer);){
            jsonWriter.beginArray();
            for (Event event : events) {
                if (!this.writeOutputEvent(event, jsonWriter)) continue;
                ++count;
            }
            if (!summary.isEmpty()) {
                this.writeSummaryEvent(summary, jsonWriter);
                ++count;
            }
            jsonWriter.endArray();
        }
        return count;
    }

    private boolean writeOutputEvent(Event event, JsonWriter jw) throws IOException {
        if (event instanceof Event.FeatureRequest) {
            Event.FeatureRequest fe = (Event.FeatureRequest)event;
            this.startEvent(fe, fe.debug ? "debug" : "feature", fe.key, jw);
            this.writeUserOrKey(fe, fe.debug, jw);
            if (fe.version != null) {
                jw.name("version");
                jw.value((Number)fe.version);
            }
            if (fe.variation != null) {
                jw.name("variation");
                jw.value((Number)fe.variation);
            }
            this.writeLDValue("value", fe.value, jw);
            this.writeLDValue("default", fe.defaultVal, jw);
            if (fe.prereqOf != null) {
                jw.name("prereqOf");
                jw.value(fe.prereqOf);
            }
            this.writeEvaluationReason("reason", fe.reason, jw);
            jw.endObject();
        } else if (event instanceof Event.Identify) {
            this.startEvent(event, "identify", event.user == null ? null : event.user.getKeyAsString(), jw);
            this.writeUser(event.user, jw);
            jw.endObject();
        } else if (event instanceof Event.Custom) {
            Event.Custom ce = (Event.Custom)event;
            this.startEvent(event, "custom", ce.key, jw);
            this.writeUserOrKey(ce, false, jw);
            this.writeLDValue("data", ce.data, jw);
            if (ce.metricValue != null) {
                jw.name("metricValue");
                jw.value((Number)ce.metricValue);
            }
            jw.endObject();
        } else if (event instanceof Event.Index) {
            this.startEvent(event, "index", null, jw);
            this.writeUser(event.user, jw);
            jw.endObject();
        } else {
            return false;
        }
        return true;
    }

    private void writeSummaryEvent(EventSummarizer.EventSummary summary, JsonWriter jw) throws IOException {
        jw.beginObject();
        jw.name("kind");
        jw.value("summary");
        jw.name("startDate");
        jw.value(summary.startDate);
        jw.name("endDate");
        jw.value(summary.endDate);
        jw.name("features");
        jw.beginObject();
        EventSummarizer.CounterKey[] unprocessedKeys = summary.counters.keySet().toArray(new EventSummarizer.CounterKey[summary.counters.size()]);
        for (int i = 0; i < unprocessedKeys.length; ++i) {
            if (unprocessedKeys[i] == null) continue;
            EventSummarizer.CounterKey key = unprocessedKeys[i];
            String flagKey = key.key;
            EventSummarizer.CounterValue firstValue = summary.counters.get(key);
            jw.name(flagKey);
            jw.beginObject();
            this.writeLDValue("default", firstValue.defaultVal, jw);
            jw.name("counters");
            jw.beginArray();
            for (int j = i; j < unprocessedKeys.length; ++j) {
                EventSummarizer.CounterKey keyForThisFlag = unprocessedKeys[j];
                if (j != i && (keyForThisFlag == null || !keyForThisFlag.key.equals(flagKey))) continue;
                EventSummarizer.CounterValue value = keyForThisFlag == key ? firstValue : summary.counters.get(keyForThisFlag);
                unprocessedKeys[j] = null;
                jw.beginObject();
                if (keyForThisFlag.variation != null) {
                    jw.name("variation");
                    jw.value((Number)keyForThisFlag.variation);
                }
                if (keyForThisFlag.version != null) {
                    jw.name("version");
                    jw.value((Number)keyForThisFlag.version);
                } else {
                    jw.name("unknown");
                    jw.value(true);
                }
                this.writeLDValue("value", value.flagValue, jw);
                jw.name("count");
                jw.value(value.count);
                jw.endObject();
            }
            jw.endArray();
            jw.endObject();
        }
        jw.endObject();
        jw.endObject();
    }

    private void startEvent(Event event, String kind, String key, JsonWriter jw) throws IOException {
        jw.beginObject();
        jw.name("kind");
        jw.value(kind);
        jw.name("creationDate");
        jw.value(event.creationDate);
        if (key != null) {
            jw.name("key");
            jw.value(key);
        }
    }

    private void writeUserOrKey(Event event, boolean forceInline, JsonWriter jw) throws IOException {
        LDUser user = event.user;
        if (user != null) {
            if (this.config.inlineUsersInEvents || forceInline) {
                this.writeUser(user, jw);
            } else {
                jw.name("userKey");
                jw.value(user.getKeyAsString());
            }
        }
    }

    private void writeUser(LDUser user, JsonWriter jw) throws IOException {
        jw.name("user");
        this.config.gson.toJson((Object)user, LDUser.class, jw);
    }

    private void writeLDValue(String key, LDValue value, JsonWriter jw) throws IOException {
        if (value == null || value.isNull()) {
            return;
        }
        jw.name(key);
        this.config.gson.toJson((Object)value, LDValue.class, jw);
    }

    private void writeEvaluationReason(String key, EvaluationReason er, JsonWriter jw) throws IOException {
        if (er == null) {
            return;
        }
        jw.name(key);
        jw.beginObject();
        jw.name("kind");
        jw.value(er.getKind().name());
        if (er instanceof EvaluationReason.Error) {
            EvaluationReason.Error ere = (EvaluationReason.Error)er;
            jw.name("errorKind");
            jw.value(ere.getErrorKind().name());
        } else if (er instanceof EvaluationReason.PrerequisiteFailed) {
            EvaluationReason.PrerequisiteFailed erpf = (EvaluationReason.PrerequisiteFailed)er;
            jw.name("prerequisiteKey");
            jw.value(erpf.getPrerequisiteKey());
        } else if (er instanceof EvaluationReason.RuleMatch) {
            EvaluationReason.RuleMatch errm = (EvaluationReason.RuleMatch)er;
            jw.name("ruleIndex");
            jw.value((long)errm.getRuleIndex());
            if (errm.getRuleId() != null) {
                jw.name("ruleId");
                jw.value(errm.getRuleId());
            }
        }
        jw.endObject();
    }
}

