/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.launchdarkly.client.Components;
import com.launchdarkly.client.DiagnosticId;
import com.launchdarkly.client.LDClient;
import com.launchdarkly.client.LDConfig;
import com.launchdarkly.client.interfaces.DiagnosticDescription;
import com.launchdarkly.client.value.LDValue;
import com.launchdarkly.client.value.LDValueType;
import com.launchdarkly.client.value.ObjectBuilder;
import java.util.List;

class DiagnosticEvent {
    final String kind;
    final long creationDate;
    final DiagnosticId id;

    DiagnosticEvent(String kind, long creationDate, DiagnosticId id) {
        this.kind = kind;
        this.creationDate = creationDate;
        this.id = id;
    }

    static class Init
    extends DiagnosticEvent {
        final DiagnosticSdk sdk;
        final LDValue configuration;
        final DiagnosticPlatform platform = new DiagnosticPlatform();

        Init(long creationDate, DiagnosticId diagnosticId, LDConfig config) {
            super("diagnostic-init", creationDate, diagnosticId);
            this.sdk = new DiagnosticSdk(config);
            this.configuration = Init.getConfigurationData(config);
        }

        static LDValue getConfigurationData(LDConfig config) {
            ObjectBuilder builder = LDValue.buildObject();
            builder.put("connectTimeoutMillis", config.httpConfig.connectTimeoutUnit.toMillis(config.httpConfig.connectTimeout));
            builder.put("socketTimeoutMillis", config.httpConfig.socketTimeoutUnit.toMillis(config.httpConfig.socketTimeout));
            builder.put("usingProxy", config.httpConfig.proxy != null);
            builder.put("usingProxyAuthenticator", config.httpConfig.proxyAuthenticator != null);
            builder.put("offline", config.offline);
            builder.put("startWaitMillis", config.startWaitMillis);
            Init.mergeComponentProperties(builder, config.deprecatedFeatureStore, config, "dataStoreType");
            Init.mergeComponentProperties(builder, config.dataStoreFactory == null ? Components.inMemoryDataStore() : config.dataStoreFactory, config, "dataStoreType");
            Init.mergeComponentProperties(builder, config.dataSourceFactory == null ? Components.defaultUpdateProcessor() : config.dataSourceFactory, config, null);
            Init.mergeComponentProperties(builder, config.eventProcessorFactory == null ? Components.defaultEventProcessor() : config.eventProcessorFactory, config, null);
            return builder.build();
        }

        private static void mergeComponentProperties(ObjectBuilder builder, Object component, LDConfig config, String defaultPropertyName) {
            if (component == null) {
                return;
            }
            if (!(component instanceof DiagnosticDescription)) {
                if (defaultPropertyName != null) {
                    builder.put(defaultPropertyName, LDValue.of(component.getClass().getSimpleName()));
                }
                return;
            }
            LDValue componentDesc = ((DiagnosticDescription)component).describeConfiguration(config);
            if (componentDesc == null || componentDesc.isNull()) {
                return;
            }
            if (componentDesc.isString() && defaultPropertyName != null) {
                builder.put(defaultPropertyName, componentDesc);
            } else if (componentDesc.getType() == LDValueType.OBJECT) {
                for (String key : componentDesc.keys()) {
                    for (ConfigProperty prop : ConfigProperty.values()) {
                        LDValue value;
                        if (!prop.name.equals(key) || !(value = componentDesc.get(key)).isNull() && value.getType() != prop.type) continue;
                        builder.put(key, value);
                    }
                }
            }
        }

        static class DiagnosticPlatform {
            private final String name = "Java";
            private final String javaVendor = System.getProperty("java.vendor");
            private final String javaVersion = System.getProperty("java.version");
            private final String osArch = System.getProperty("os.arch");
            private final String osName = DiagnosticPlatform.normalizeOsName(System.getProperty("os.name"));
            private final String osVersion = System.getProperty("os.version");

            DiagnosticPlatform() {
            }

            private static String normalizeOsName(String osName) {
                if (osName != null) {
                    if (osName.equals("Mac OS X")) {
                        return "MacOS";
                    }
                    if (osName.startsWith("Windows")) {
                        return "Windows";
                    }
                }
                return osName;
            }
        }

        static class DiagnosticSdk {
            final String name = "java-server-sdk";
            final String version = LDClient.CLIENT_VERSION;
            final String wrapperName;
            final String wrapperVersion;

            DiagnosticSdk(LDConfig config) {
                this.wrapperName = config.httpConfig.wrapperName;
                this.wrapperVersion = config.httpConfig.wrapperVersion;
            }
        }
    }

    static class Statistics
    extends DiagnosticEvent {
        final long dataSinceDate;
        final long droppedEvents;
        final long deduplicatedUsers;
        final long eventsInLastBatch;
        final List<StreamInit> streamInits;

        Statistics(long creationDate, DiagnosticId id, long dataSinceDate, long droppedEvents, long deduplicatedUsers, long eventsInLastBatch, List<StreamInit> streamInits) {
            super("diagnostic", creationDate, id);
            this.dataSinceDate = dataSinceDate;
            this.droppedEvents = droppedEvents;
            this.deduplicatedUsers = deduplicatedUsers;
            this.eventsInLastBatch = eventsInLastBatch;
            this.streamInits = streamInits;
        }
    }

    static class StreamInit {
        long timestamp;
        long durationMillis;
        boolean failed;

        StreamInit(long timestamp, long durationMillis, boolean failed) {
            this.timestamp = timestamp;
            this.durationMillis = durationMillis;
            this.failed = failed;
        }
    }

    static enum ConfigProperty {
        ALL_ATTRIBUTES_PRIVATE("allAttributesPrivate", LDValueType.BOOLEAN),
        CUSTOM_BASE_URI("customBaseURI", LDValueType.BOOLEAN),
        CUSTOM_EVENTS_URI("customEventsURI", LDValueType.BOOLEAN),
        CUSTOM_STREAM_URI("customStreamURI", LDValueType.BOOLEAN),
        DIAGNOSTIC_RECORDING_INTERVAL_MILLIS("diagnosticRecordingIntervalMillis", LDValueType.NUMBER),
        EVENTS_CAPACITY("eventsCapacity", LDValueType.NUMBER),
        EVENTS_FLUSH_INTERVAL_MILLIS("eventsFlushIntervalMillis", LDValueType.NUMBER),
        INLINE_USERS_IN_EVENTS("inlineUsersInEvents", LDValueType.BOOLEAN),
        POLLING_INTERVAL_MILLIS("pollingIntervalMillis", LDValueType.NUMBER),
        RECONNECT_TIME_MILLIS("reconnectTimeMillis", LDValueType.NUMBER),
        SAMPLING_INTERVAL("samplingInterval", LDValueType.NUMBER),
        STREAMING_DISABLED("streamingDisabled", LDValueType.BOOLEAN),
        USER_KEYS_CAPACITY("userKeysCapacity", LDValueType.NUMBER),
        USER_KEYS_FLUSH_INTERVAL_MILLIS("userKeysFlushIntervalMillis", LDValueType.NUMBER),
        USING_RELAY_DAEMON("usingRelayDaemon", LDValueType.BOOLEAN);

        String name;
        LDValueType type;

        private ConfigProperty(String name, LDValueType type) {
            this.name = name;
            this.type = type;
        }
    }
}

