/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.launchdarkly.client.DefaultFeatureRequestor;
import com.launchdarkly.client.FeatureRequestor;
import com.launchdarkly.client.FeatureStore;
import com.launchdarkly.client.HttpErrorException;
import com.launchdarkly.client.UpdateProcessor;
import com.launchdarkly.client.Util;
import com.launchdarkly.shaded.com.google.common.annotations.VisibleForTesting;
import com.launchdarkly.shaded.com.google.common.util.concurrent.SettableFuture;
import com.launchdarkly.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PollingProcessor
implements UpdateProcessor {
    private static final Logger logger = LoggerFactory.getLogger(PollingProcessor.class);
    @VisibleForTesting
    final FeatureRequestor requestor;
    private final FeatureStore store;
    @VisibleForTesting
    final long pollIntervalMillis;
    private AtomicBoolean initialized = new AtomicBoolean(false);
    private ScheduledExecutorService scheduler = null;

    PollingProcessor(FeatureRequestor requestor, FeatureStore featureStore, long pollIntervalMillis) {
        this.requestor = requestor;
        this.store = featureStore;
        this.pollIntervalMillis = pollIntervalMillis;
    }

    @Override
    public boolean initialized() {
        return this.initialized.get();
    }

    @Override
    public void close() throws IOException {
        logger.info("Closing LaunchDarkly PollingProcessor");
        if (this.scheduler != null) {
            this.scheduler.shutdown();
        }
        this.requestor.close();
    }

    @Override
    public Future<Void> start() {
        logger.info("Starting LaunchDarkly polling client with interval: " + this.pollIntervalMillis + " milliseconds");
        final SettableFuture<Void> initFuture = SettableFuture.create();
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("LaunchDarkly-PollingProcessor-%d").build();
        this.scheduler = Executors.newScheduledThreadPool(1, threadFactory);
        this.scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    FeatureRequestor.AllData allData = PollingProcessor.this.requestor.getAllData();
                    PollingProcessor.this.store.init(DefaultFeatureRequestor.toVersionedDataMap(allData));
                    if (!PollingProcessor.this.initialized.getAndSet(true)) {
                        logger.info("Initialized LaunchDarkly client.");
                        initFuture.set(null);
                    }
                }
                catch (HttpErrorException e) {
                    logger.error(Util.httpErrorMessage(e.getStatus(), "polling request", "will retry"));
                    if (!Util.isHttpErrorRecoverable(e.getStatus())) {
                        PollingProcessor.this.scheduler.shutdown();
                        initFuture.set(null);
                    }
                }
                catch (IOException e) {
                    logger.error("Encountered exception in LaunchDarkly client when retrieving update: {}", (Object)e.toString());
                    logger.debug(e.toString(), (Throwable)e);
                }
            }
        }, 0L, this.pollIntervalMillis, TimeUnit.MILLISECONDS);
        return initFuture;
    }
}

