/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client.value;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonWriter;
import com.launchdarkly.client.value.ArrayBuilder;
import com.launchdarkly.client.value.LDValueBool;
import com.launchdarkly.client.value.LDValueJsonElement;
import com.launchdarkly.client.value.LDValueNull;
import com.launchdarkly.client.value.LDValueNumber;
import com.launchdarkly.client.value.LDValueString;
import com.launchdarkly.client.value.LDValueType;
import com.launchdarkly.client.value.LDValueTypeAdapter;
import com.launchdarkly.client.value.ObjectBuilder;
import com.launchdarkly.shaded.com.google.common.base.Function;
import com.launchdarkly.shaded.com.google.common.collect.ImmutableList;
import com.launchdarkly.shaded.com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Map;

@JsonAdapter(value=LDValueTypeAdapter.class)
public abstract class LDValue {
    static final Gson gson = new Gson();
    private boolean haveComputedJsonElement = false;
    private JsonElement computedJsonElement = null;

    public static LDValue normalize(LDValue value) {
        return value == null ? LDValue.ofNull() : value;
    }

    public static LDValue ofNull() {
        return LDValueNull.INSTANCE;
    }

    public static LDValue of(boolean value) {
        return LDValueBool.fromBoolean(value);
    }

    public static LDValue of(int value) {
        return LDValueNumber.fromDouble(value);
    }

    public static LDValue of(long value) {
        return LDValueNumber.fromDouble(value);
    }

    public static LDValue of(float value) {
        return LDValueNumber.fromDouble(value);
    }

    public static LDValue of(double value) {
        return LDValueNumber.fromDouble(value);
    }

    public static LDValue of(String value) {
        return value == null ? LDValue.ofNull() : LDValueString.fromString(value);
    }

    public static ArrayBuilder buildArray() {
        return new ArrayBuilder();
    }

    public static ObjectBuilder buildObject() {
        return new ObjectBuilder();
    }

    @Deprecated
    public static LDValue fromJsonElement(JsonElement value) {
        return value == null || value.isJsonNull() ? LDValue.ofNull() : LDValueJsonElement.copyValue(value);
    }

    @Deprecated
    public static LDValue unsafeFromJsonElement(JsonElement value) {
        return value == null || value.isJsonNull() ? LDValue.ofNull() : LDValueJsonElement.wrapUnsafeValue(value);
    }

    public abstract LDValueType getType();

    public boolean isNull() {
        return false;
    }

    public boolean booleanValue() {
        return false;
    }

    public boolean isNumber() {
        return false;
    }

    public boolean isInt() {
        return false;
    }

    public int intValue() {
        return 0;
    }

    public long longValue() {
        return 0L;
    }

    public float floatValue() {
        return 0.0f;
    }

    public double doubleValue() {
        return 0.0;
    }

    public boolean isString() {
        return false;
    }

    public String stringValue() {
        return null;
    }

    public int size() {
        return 0;
    }

    public Iterable<String> keys() {
        return ImmutableList.of();
    }

    public Iterable<LDValue> values() {
        return ImmutableList.of();
    }

    public <T> Iterable<T> valuesAs(final Converter<T> converter) {
        return Iterables.transform(this.values(), new Function<LDValue, T>(){

            @Override
            public T apply(LDValue value) {
                return converter.toType(value);
            }
        });
    }

    public LDValue get(int index) {
        return LDValue.ofNull();
    }

    public LDValue get(String name) {
        return LDValue.ofNull();
    }

    public String toJsonString() {
        return gson.toJson((Object)this);
    }

    @Deprecated
    public JsonElement asJsonElement() {
        return LDValueJsonElement.deepCopy(this.asUnsafeJsonElement());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public JsonElement asUnsafeJsonElement() {
        LDValue lDValue = this;
        synchronized (lDValue) {
            if (!this.haveComputedJsonElement) {
                this.computedJsonElement = this.computeJsonElement();
                this.haveComputedJsonElement = true;
            }
            return this.computedJsonElement;
        }
    }

    abstract JsonElement computeJsonElement();

    abstract void write(JsonWriter var1) throws IOException;

    static boolean isInteger(double value) {
        return value == (double)((int)value);
    }

    public String toString() {
        return this.toJsonString();
    }

    public boolean equals(Object o) {
        if (o instanceof LDValue) {
            LDValue other = (LDValue)o;
            if (this.getType() == other.getType()) {
                switch (this.getType()) {
                    case NULL: {
                        return other.isNull();
                    }
                    case BOOLEAN: {
                        return this.booleanValue() == other.booleanValue();
                    }
                    case NUMBER: {
                        return this.doubleValue() == other.doubleValue();
                    }
                    case STRING: {
                        return this.stringValue().equals(other.stringValue());
                    }
                    case ARRAY: {
                        if (this.size() != other.size()) {
                            return false;
                        }
                        for (int i = 0; i < this.size(); ++i) {
                            if (this.get(i).equals(other.get(i))) continue;
                            return false;
                        }
                        return true;
                    }
                    case OBJECT: {
                        if (this.size() != other.size()) {
                            return false;
                        }
                        for (String name : this.keys()) {
                            if (this.get(name).equals(other.get(name))) continue;
                            return false;
                        }
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public int hashCode() {
        switch (this.getType()) {
            case NULL: {
                return 0;
            }
            case BOOLEAN: {
                return this.booleanValue() ? 1 : 0;
            }
            case NUMBER: {
                return this.intValue();
            }
            case STRING: {
                return this.stringValue().hashCode();
            }
            case ARRAY: {
                int ah = 0;
                for (LDValue v : this.values()) {
                    ah = ah * 31 + v.hashCode();
                }
                return ah;
            }
            case OBJECT: {
                int oh = 0;
                for (String name : this.keys()) {
                    oh = (oh * 31 + name.hashCode()) * 31 + this.get(name).hashCode();
                }
                return oh;
            }
        }
        return 0;
    }

    public static abstract class Convert {
        public static final Converter<Boolean> Boolean = new Converter<Boolean>(){

            @Override
            public LDValue fromType(Boolean value) {
                return value == null ? LDValue.ofNull() : LDValue.of(value);
            }

            @Override
            public Boolean toType(LDValue value) {
                return value.booleanValue();
            }
        };
        public static final Converter<Integer> Integer = new Converter<Integer>(){

            @Override
            public LDValue fromType(Integer value) {
                return value == null ? LDValue.ofNull() : LDValue.of(value);
            }

            @Override
            public Integer toType(LDValue value) {
                return value.intValue();
            }
        };
        public static final Converter<Long> Long = new Converter<Long>(){

            @Override
            public LDValue fromType(Long value) {
                return value == null ? LDValue.ofNull() : LDValue.of(value);
            }

            @Override
            public Long toType(LDValue value) {
                return value.longValue();
            }
        };
        public static final Converter<Float> Float = new Converter<Float>(){

            @Override
            public LDValue fromType(Float value) {
                return value == null ? LDValue.ofNull() : LDValue.of(value.floatValue());
            }

            @Override
            public Float toType(LDValue value) {
                return java.lang.Float.valueOf(value.floatValue());
            }
        };
        public static final Converter<Double> Double = new Converter<Double>(){

            @Override
            public LDValue fromType(Double value) {
                return value == null ? LDValue.ofNull() : LDValue.of(value);
            }

            @Override
            public Double toType(LDValue value) {
                return value.doubleValue();
            }
        };
        public static final Converter<String> String = new Converter<String>(){

            @Override
            public LDValue fromType(String value) {
                return LDValue.of(value);
            }

            @Override
            public String toType(LDValue value) {
                return value.stringValue();
            }
        };

        private Convert() {
        }
    }

    public static abstract class Converter<T> {
        public abstract LDValue fromType(T var1);

        public abstract T toType(LDValue var1);

        public LDValue arrayFrom(Iterable<T> values) {
            ArrayBuilder ab = LDValue.buildArray();
            for (T value : values) {
                ab.add(this.fromType(value));
            }
            return ab.build();
        }

        public LDValue arrayOf(T ... values) {
            ArrayBuilder ab = LDValue.buildArray();
            for (T value : values) {
                ab.add(this.fromType(value));
            }
            return ab.build();
        }

        public LDValue objectFrom(Map<String, T> map) {
            ObjectBuilder ob = LDValue.buildObject();
            for (String key : map.keySet()) {
                ob.put(key, this.fromType(map.get(key)));
            }
            return ob.build();
        }
    }
}

