/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.launchdarkly.client.Components;
import com.launchdarkly.client.EventProcessorFactory;
import com.launchdarkly.client.FeatureStore;
import com.launchdarkly.client.FeatureStoreFactory;
import com.launchdarkly.client.HttpConfiguration;
import com.launchdarkly.client.UpdateProcessorFactory;
import com.launchdarkly.shaded.com.google.common.collect.ImmutableSet;
import com.launchdarkly.shaded.okhttp3.Authenticator;
import com.launchdarkly.shaded.okhttp3.Credentials;
import com.launchdarkly.shaded.okhttp3.Request;
import com.launchdarkly.shaded.okhttp3.Response;
import com.launchdarkly.shaded.okhttp3.Route;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LDConfig {
    private static final Logger logger = LoggerFactory.getLogger(LDConfig.class);
    static final URI DEFAULT_BASE_URI = URI.create("https://app.launchdarkly.com");
    static final URI DEFAULT_EVENTS_URI = URI.create("https://events.launchdarkly.com");
    static final URI DEFAULT_STREAM_URI = URI.create("https://stream.launchdarkly.com");
    private static final int DEFAULT_CAPACITY = 10000;
    private static final int DEFAULT_CONNECT_TIMEOUT_MILLIS = 2000;
    private static final int DEFAULT_SOCKET_TIMEOUT_MILLIS = 10000;
    private static final int DEFAULT_FLUSH_INTERVAL_SECONDS = 5;
    private static final long MIN_POLLING_INTERVAL_MILLIS = 30000L;
    private static final long DEFAULT_START_WAIT_MILLIS = 5000L;
    private static final int DEFAULT_SAMPLING_INTERVAL = 0;
    private static final int DEFAULT_USER_KEYS_CAPACITY = 1000;
    private static final int DEFAULT_USER_KEYS_FLUSH_INTERVAL_SECONDS = 300;
    private static final long DEFAULT_RECONNECT_TIME_MILLIS = 1000L;
    protected static final LDConfig DEFAULT = new Builder().build();
    final UpdateProcessorFactory dataSourceFactory;
    final FeatureStoreFactory dataStoreFactory;
    final boolean diagnosticOptOut;
    final EventProcessorFactory eventProcessorFactory;
    final HttpConfiguration httpConfig;
    final boolean offline;
    final long startWaitMillis;
    final URI deprecatedBaseURI;
    final URI deprecatedEventsURI;
    final URI deprecatedStreamURI;
    final int deprecatedCapacity;
    final int deprecatedFlushInterval;
    final boolean deprecatedStream;
    final FeatureStore deprecatedFeatureStore;
    final boolean deprecatedAllAttributesPrivate;
    final ImmutableSet<String> deprecatedPrivateAttrNames;
    final boolean deprecatedSendEvents;
    final long deprecatedPollingIntervalMillis;
    final int deprecatedSamplingInterval;
    final long deprecatedReconnectTimeMs;
    final int deprecatedUserKeysCapacity;
    final int deprecatedUserKeysFlushInterval;
    final boolean deprecatedInlineUsersInEvents;

    protected LDConfig(Builder builder) {
        this.dataStoreFactory = builder.dataStoreFactory;
        this.eventProcessorFactory = builder.eventProcessorFactory;
        this.dataSourceFactory = builder.dataSourceFactory;
        this.diagnosticOptOut = builder.diagnosticOptOut;
        this.offline = builder.offline;
        this.startWaitMillis = builder.startWaitMillis;
        Proxy proxy = builder.proxy();
        Authenticator proxyAuthenticator = builder.proxyAuthenticator();
        if (proxy != null) {
            if (proxyAuthenticator != null) {
                logger.info("Using proxy: " + proxy + " with authentication.");
            } else {
                logger.info("Using proxy: " + proxy + " without authentication.");
            }
        }
        this.httpConfig = new HttpConfiguration(builder.connectTimeout, builder.connectTimeoutUnit, proxy, proxyAuthenticator, builder.socketTimeout, builder.socketTimeoutUnit, builder.sslSocketFactory, builder.trustManager, builder.wrapperName, builder.wrapperVersion);
        this.deprecatedAllAttributesPrivate = builder.allAttributesPrivate;
        this.deprecatedBaseURI = builder.baseURI;
        this.deprecatedCapacity = builder.capacity;
        this.deprecatedEventsURI = builder.eventsURI;
        this.deprecatedFeatureStore = builder.featureStore;
        this.deprecatedFlushInterval = builder.flushIntervalSeconds;
        this.deprecatedInlineUsersInEvents = builder.inlineUsersInEvents;
        this.deprecatedPollingIntervalMillis = builder.pollingIntervalMillis < 30000L ? 30000L : builder.pollingIntervalMillis;
        this.deprecatedPrivateAttrNames = builder.privateAttrNames;
        this.deprecatedSendEvents = builder.sendEvents;
        this.deprecatedStream = builder.stream;
        this.deprecatedStreamURI = builder.streamURI;
        this.deprecatedSamplingInterval = builder.samplingInterval;
        this.deprecatedReconnectTimeMs = builder.reconnectTimeMillis;
        this.deprecatedUserKeysCapacity = builder.userKeysCapacity;
        this.deprecatedUserKeysFlushInterval = builder.userKeysFlushInterval;
    }

    LDConfig(LDConfig config) {
        this.dataSourceFactory = config.dataSourceFactory;
        this.dataStoreFactory = config.dataStoreFactory;
        this.diagnosticOptOut = config.diagnosticOptOut;
        this.eventProcessorFactory = config.eventProcessorFactory;
        this.httpConfig = config.httpConfig;
        this.offline = config.offline;
        this.startWaitMillis = config.startWaitMillis;
        this.deprecatedAllAttributesPrivate = config.deprecatedAllAttributesPrivate;
        this.deprecatedBaseURI = config.deprecatedBaseURI;
        this.deprecatedCapacity = config.deprecatedCapacity;
        this.deprecatedEventsURI = config.deprecatedEventsURI;
        this.deprecatedFeatureStore = config.deprecatedFeatureStore;
        this.deprecatedFlushInterval = config.deprecatedFlushInterval;
        this.deprecatedInlineUsersInEvents = config.deprecatedInlineUsersInEvents;
        this.deprecatedPollingIntervalMillis = config.deprecatedPollingIntervalMillis;
        this.deprecatedPrivateAttrNames = config.deprecatedPrivateAttrNames;
        this.deprecatedReconnectTimeMs = config.deprecatedReconnectTimeMs;
        this.deprecatedSamplingInterval = config.deprecatedSamplingInterval;
        this.deprecatedSendEvents = config.deprecatedSendEvents;
        this.deprecatedStream = config.deprecatedStream;
        this.deprecatedStreamURI = config.deprecatedStreamURI;
        this.deprecatedUserKeysCapacity = config.deprecatedUserKeysCapacity;
        this.deprecatedUserKeysFlushInterval = config.deprecatedUserKeysFlushInterval;
    }

    public static class Builder {
        private URI baseURI = DEFAULT_BASE_URI;
        private URI eventsURI = DEFAULT_EVENTS_URI;
        private URI streamURI = DEFAULT_STREAM_URI;
        private int connectTimeout = 2000;
        private TimeUnit connectTimeoutUnit = TimeUnit.MILLISECONDS;
        private int socketTimeout = 10000;
        private TimeUnit socketTimeoutUnit = TimeUnit.MILLISECONDS;
        private boolean diagnosticOptOut = false;
        private int capacity = 10000;
        private int flushIntervalSeconds = 5;
        private String proxyHost = "localhost";
        private int proxyPort = -1;
        private String proxyUsername = null;
        private String proxyPassword = null;
        private boolean stream = true;
        private boolean offline = false;
        private boolean allAttributesPrivate = false;
        private boolean sendEvents = true;
        private long pollingIntervalMillis = 30000L;
        private FeatureStore featureStore = null;
        private FeatureStoreFactory dataStoreFactory = null;
        private EventProcessorFactory eventProcessorFactory = null;
        private UpdateProcessorFactory dataSourceFactory = null;
        private long startWaitMillis = 5000L;
        private int samplingInterval = 0;
        private long reconnectTimeMillis = 1000L;
        private ImmutableSet<String> privateAttrNames = ImmutableSet.of();
        private int userKeysCapacity = 1000;
        private int userKeysFlushInterval = 300;
        private boolean inlineUsersInEvents = false;
        private SSLSocketFactory sslSocketFactory = null;
        private X509TrustManager trustManager = null;
        private String wrapperName = null;
        private String wrapperVersion = null;

        @Deprecated
        public Builder baseURI(URI baseURI) {
            this.baseURI = baseURI;
            return this;
        }

        @Deprecated
        public Builder eventsURI(URI eventsURI) {
            this.eventsURI = eventsURI;
            return this;
        }

        @Deprecated
        public Builder streamURI(URI streamURI) {
            this.streamURI = streamURI;
            return this;
        }

        public Builder dataStore(FeatureStoreFactory factory) {
            this.dataStoreFactory = factory;
            return this;
        }

        @Deprecated
        public Builder featureStore(FeatureStore store) {
            this.featureStore = store;
            return this;
        }

        @Deprecated
        public Builder featureStoreFactory(FeatureStoreFactory factory) {
            this.dataStoreFactory = factory;
            return this;
        }

        public Builder events(EventProcessorFactory factory) {
            this.eventProcessorFactory = factory;
            return this;
        }

        public Builder eventProcessorFactory(EventProcessorFactory factory) {
            this.eventProcessorFactory = factory;
            return this;
        }

        public Builder dataSource(UpdateProcessorFactory factory) {
            this.dataSourceFactory = factory;
            return this;
        }

        @Deprecated
        public Builder updateProcessorFactory(UpdateProcessorFactory factory) {
            this.dataSourceFactory = factory;
            return this;
        }

        @Deprecated
        public Builder stream(boolean stream) {
            this.stream = stream;
            return this;
        }

        public Builder connectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            this.connectTimeoutUnit = TimeUnit.SECONDS;
            return this;
        }

        public Builder socketTimeout(int socketTimeout) {
            this.socketTimeout = socketTimeout;
            this.socketTimeoutUnit = TimeUnit.SECONDS;
            return this;
        }

        public Builder connectTimeoutMillis(int connectTimeoutMillis) {
            this.connectTimeout = connectTimeoutMillis;
            this.connectTimeoutUnit = TimeUnit.MILLISECONDS;
            return this;
        }

        public Builder socketTimeoutMillis(int socketTimeoutMillis) {
            this.socketTimeout = socketTimeoutMillis;
            this.socketTimeoutUnit = TimeUnit.MILLISECONDS;
            return this;
        }

        @Deprecated
        public Builder flushInterval(int flushInterval) {
            this.flushIntervalSeconds = flushInterval;
            return this;
        }

        @Deprecated
        public Builder capacity(int capacity) {
            this.capacity = capacity;
            return this;
        }

        public Builder proxyHost(String host) {
            this.proxyHost = host;
            return this;
        }

        public Builder proxyPort(int port) {
            this.proxyPort = port;
            return this;
        }

        public Builder proxyUsername(String username) {
            this.proxyUsername = username;
            return this;
        }

        public Builder proxyPassword(String password) {
            this.proxyPassword = password;
            return this;
        }

        public Builder sslSocketFactory(SSLSocketFactory sslSocketFactory, X509TrustManager trustManager) {
            this.sslSocketFactory = sslSocketFactory;
            this.trustManager = trustManager;
            return this;
        }

        @Deprecated
        public Builder useLdd(boolean useLdd) {
            if (useLdd) {
                return this.dataSource(Components.externalUpdatesOnly());
            }
            return this.dataSource(null);
        }

        public Builder offline(boolean offline) {
            this.offline = offline;
            return this;
        }

        @Deprecated
        public Builder allAttributesPrivate(boolean allPrivate) {
            this.allAttributesPrivate = allPrivate;
            return this;
        }

        @Deprecated
        public Builder sendEvents(boolean sendEvents) {
            this.sendEvents = sendEvents;
            return this;
        }

        @Deprecated
        public Builder pollingIntervalMillis(long pollingIntervalMillis) {
            this.pollingIntervalMillis = pollingIntervalMillis;
            return this;
        }

        public Builder startWaitMillis(long startWaitMillis) {
            this.startWaitMillis = startWaitMillis;
            return this;
        }

        @Deprecated
        public Builder samplingInterval(int samplingInterval) {
            this.samplingInterval = samplingInterval;
            return this;
        }

        @Deprecated
        public Builder reconnectTimeMs(long reconnectTimeMs) {
            this.reconnectTimeMillis = reconnectTimeMs;
            return this;
        }

        @Deprecated
        public Builder privateAttributeNames(String ... names) {
            this.privateAttrNames = ImmutableSet.copyOf(names);
            return this;
        }

        @Deprecated
        public Builder userKeysCapacity(int capacity) {
            this.userKeysCapacity = capacity;
            return this;
        }

        @Deprecated
        public Builder userKeysFlushInterval(int flushInterval) {
            this.userKeysFlushInterval = flushInterval;
            return this;
        }

        @Deprecated
        public Builder inlineUsersInEvents(boolean inlineUsersInEvents) {
            this.inlineUsersInEvents = inlineUsersInEvents;
            return this;
        }

        public Builder diagnosticOptOut(boolean diagnosticOptOut) {
            this.diagnosticOptOut = diagnosticOptOut;
            return this;
        }

        public Builder wrapperName(String wrapperName) {
            this.wrapperName = wrapperName;
            return this;
        }

        public Builder wrapperVersion(String wrapperVersion) {
            this.wrapperVersion = wrapperVersion;
            return this;
        }

        Proxy proxy() {
            if (this.proxyPort == -1) {
                return null;
            }
            return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(this.proxyHost, this.proxyPort));
        }

        Authenticator proxyAuthenticator() {
            if (this.proxyUsername != null && this.proxyPassword != null) {
                final String credential = Credentials.basic(this.proxyUsername, this.proxyPassword);
                return new Authenticator(){

                    @Override
                    public Request authenticate(Route route, Response response) throws IOException {
                        if (response.request().header("Proxy-Authorization") != null) {
                            return null;
                        }
                        return response.request().newBuilder().header("Proxy-Authorization", credential).build();
                    }
                };
            }
            return null;
        }

        public LDConfig build() {
            return new LDConfig(this);
        }
    }
}

