/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client;

import com.launchdarkly.client.HttpConfiguration;
import com.launchdarkly.client.LDClient;
import com.launchdarkly.client.value.LDValue;
import com.launchdarkly.shaded.okhttp3.ConnectionPool;
import com.launchdarkly.shaded.okhttp3.Headers;
import com.launchdarkly.shaded.okhttp3.OkHttpClient;
import com.launchdarkly.shaded.org.joda.time.DateTime;
import com.launchdarkly.shaded.org.joda.time.DateTimeZone;
import java.util.concurrent.TimeUnit;

class Util {
    Util() {
    }

    static DateTime jsonPrimitiveToDateTime(LDValue maybeDate) {
        if (maybeDate.isNumber()) {
            return new DateTime((long)maybeDate.doubleValue());
        }
        if (maybeDate.isString()) {
            try {
                return new DateTime((Object)maybeDate.stringValue(), DateTimeZone.UTC);
            }
            catch (Throwable t) {
                return null;
            }
        }
        return null;
    }

    static Headers.Builder getHeadersBuilderFor(String sdkKey, HttpConfiguration config) {
        Headers.Builder builder = new Headers.Builder().add("Authorization", sdkKey).add("User-Agent", "JavaClient/" + LDClient.CLIENT_VERSION);
        if (config.wrapperName != null) {
            String wrapperVersion = "";
            if (config.wrapperVersion != null) {
                wrapperVersion = "/" + config.wrapperVersion;
            }
            builder.add("X-LaunchDarkly-Wrapper", config.wrapperName + wrapperVersion);
        }
        return builder;
    }

    static void configureHttpClientBuilder(HttpConfiguration config, OkHttpClient.Builder builder) {
        builder.connectionPool(new ConnectionPool(5, 5L, TimeUnit.SECONDS)).connectTimeout(config.connectTimeout, config.connectTimeoutUnit).readTimeout(config.socketTimeout, config.socketTimeoutUnit).writeTimeout(config.socketTimeout, config.socketTimeoutUnit).retryOnConnectionFailure(false);
        if (config.sslSocketFactory != null) {
            builder.sslSocketFactory(config.sslSocketFactory, config.trustManager);
        }
        if (config.proxy != null) {
            builder.proxy(config.proxy);
            if (config.proxyAuthenticator != null) {
                builder.proxyAuthenticator(config.proxyAuthenticator);
            }
        }
    }

    static void shutdownHttpClient(OkHttpClient client) {
        if (client.dispatcher() != null) {
            client.dispatcher().cancelAll();
            if (client.dispatcher().executorService() != null) {
                client.dispatcher().executorService().shutdown();
            }
        }
        if (client.connectionPool() != null) {
            client.connectionPool().evictAll();
        }
        if (client.cache() != null) {
            try {
                client.cache().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static boolean isHttpErrorRecoverable(int statusCode) {
        if (statusCode >= 400 && statusCode < 500) {
            switch (statusCode) {
                case 400: 
                case 408: 
                case 429: {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    static String httpErrorMessage(int statusCode, String context, String recoverableMessage) {
        StringBuilder sb = new StringBuilder();
        sb.append("Received HTTP error ").append(statusCode);
        switch (statusCode) {
            case 401: 
            case 403: {
                sb.append(" (invalid SDK key)");
            }
        }
        sb.append(" for ").append(context).append(" - ");
        sb.append(Util.isHttpErrorRecoverable(statusCode) ? recoverableMessage : "giving up permanently");
        return sb.toString();
    }
}

