/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client.integrations;

import com.launchdarkly.client.EventProcessorFactory;
import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public abstract class EventProcessorBuilder
implements EventProcessorFactory {
    public static final int DEFAULT_CAPACITY = 10000;
    public static final int DEFAULT_DIAGNOSTIC_RECORDING_INTERVAL_SECONDS = 900;
    public static final int DEFAULT_FLUSH_INTERVAL_SECONDS = 5;
    public static final int DEFAULT_USER_KEYS_CAPACITY = 1000;
    public static final int DEFAULT_USER_KEYS_FLUSH_INTERVAL_SECONDS = 300;
    public static final int MIN_DIAGNOSTIC_RECORDING_INTERVAL_SECONDS = 60;
    protected boolean allAttributesPrivate = false;
    protected URI baseURI;
    protected int capacity = 10000;
    protected int diagnosticRecordingIntervalSeconds = 900;
    protected int flushIntervalSeconds = 5;
    protected boolean inlineUsersInEvents = false;
    protected Set<String> privateAttrNames;
    protected int userKeysCapacity = 1000;
    protected int userKeysFlushIntervalSeconds = 300;

    public EventProcessorBuilder allAttributesPrivate(boolean allAttributesPrivate) {
        this.allAttributesPrivate = allAttributesPrivate;
        return this;
    }

    public EventProcessorBuilder baseURI(URI baseURI) {
        this.baseURI = baseURI;
        return this;
    }

    public EventProcessorBuilder capacity(int capacity) {
        this.capacity = capacity;
        return this;
    }

    public EventProcessorBuilder diagnosticRecordingIntervalSeconds(int diagnosticRecordingIntervalSeconds) {
        this.diagnosticRecordingIntervalSeconds = diagnosticRecordingIntervalSeconds < 60 ? 60 : diagnosticRecordingIntervalSeconds;
        return this;
    }

    public EventProcessorBuilder flushIntervalSeconds(int flushIntervalSeconds) {
        this.flushIntervalSeconds = flushIntervalSeconds;
        return this;
    }

    public EventProcessorBuilder inlineUsersInEvents(boolean inlineUsersInEvents) {
        this.inlineUsersInEvents = inlineUsersInEvents;
        return this;
    }

    public EventProcessorBuilder privateAttributeNames(String ... attributeNames) {
        this.privateAttrNames = new HashSet<String>(Arrays.asList(attributeNames));
        return this;
    }

    public EventProcessorBuilder userKeysCapacity(int userKeysCapacity) {
        this.userKeysCapacity = userKeysCapacity;
        return this;
    }

    public EventProcessorBuilder userKeysFlushIntervalSeconds(int userKeysFlushIntervalSeconds) {
        this.userKeysFlushIntervalSeconds = userKeysFlushIntervalSeconds;
        return this;
    }
}

