/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.client.utils;

import com.launchdarkly.client.FeatureStore;
import com.launchdarkly.client.FeatureStoreCacheConfig;
import com.launchdarkly.client.VersionedData;
import com.launchdarkly.client.VersionedDataKind;
import com.launchdarkly.client.integrations.CacheMonitor;
import com.launchdarkly.client.utils.FeatureStoreCore;
import com.launchdarkly.shaded.com.google.common.base.Optional;
import com.launchdarkly.shaded.com.google.common.cache.CacheBuilder;
import com.launchdarkly.shaded.com.google.common.cache.CacheLoader;
import com.launchdarkly.shaded.com.google.common.cache.CacheStats;
import com.launchdarkly.shaded.com.google.common.cache.LoadingCache;
import com.launchdarkly.shaded.com.google.common.collect.ImmutableMap;
import com.launchdarkly.shaded.com.google.common.util.concurrent.ListeningExecutorService;
import com.launchdarkly.shaded.com.google.common.util.concurrent.MoreExecutors;
import com.launchdarkly.shaded.com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;

@Deprecated
public class CachingStoreWrapper
implements FeatureStore {
    private static final String CACHE_REFRESH_THREAD_POOL_NAME_FORMAT = "CachingStoreWrapper-refresher-pool-%d";
    private final FeatureStoreCore core;
    private final FeatureStoreCacheConfig caching;
    private final LoadingCache<CacheKey, Optional<VersionedData>> itemCache;
    private final LoadingCache<VersionedDataKind<?>, ImmutableMap<String, VersionedData>> allCache;
    private final LoadingCache<String, Boolean> initCache;
    private final AtomicBoolean inited = new AtomicBoolean(false);
    private final ListeningExecutorService executorService;

    public static Builder builder(FeatureStoreCore core) {
        return new Builder(core);
    }

    protected CachingStoreWrapper(final FeatureStoreCore core, FeatureStoreCacheConfig caching, CacheMonitor cacheMonitor) {
        this.core = core;
        this.caching = caching;
        if (!caching.isEnabled()) {
            this.itemCache = null;
            this.allCache = null;
            this.initCache = null;
            this.executorService = null;
        } else {
            CacheLoader<CacheKey, Optional<VersionedData>> itemLoader = new CacheLoader<CacheKey, Optional<VersionedData>>(){

                @Override
                public Optional<VersionedData> load(CacheKey key) throws Exception {
                    return Optional.fromNullable(core.getInternal(key.kind, key.key));
                }
            };
            CacheLoader allLoader = new CacheLoader<VersionedDataKind<?>, ImmutableMap<String, VersionedData>>(){

                @Override
                public ImmutableMap<String, VersionedData> load(VersionedDataKind<?> kind) throws Exception {
                    return CachingStoreWrapper.this.itemsOnlyIfNotDeleted(core.getAllInternal(kind));
                }
            };
            CacheLoader<String, Boolean> initLoader = new CacheLoader<String, Boolean>(){

                @Override
                public Boolean load(String key) throws Exception {
                    return core.initializedInternal();
                }
            };
            if (caching.getStaleValuesPolicy() == FeatureStoreCacheConfig.StaleValuesPolicy.REFRESH_ASYNC) {
                ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat(CACHE_REFRESH_THREAD_POOL_NAME_FORMAT).setDaemon(true).build();
                ExecutorService parentExecutor = Executors.newSingleThreadExecutor(threadFactory);
                this.executorService = MoreExecutors.listeningDecorator(parentExecutor);
                itemLoader = CacheLoader.asyncReloading(itemLoader, this.executorService);
            } else {
                this.executorService = null;
            }
            this.itemCache = CachingStoreWrapper.newCacheBuilder(caching, cacheMonitor).build(itemLoader);
            this.allCache = CachingStoreWrapper.newCacheBuilder(caching, cacheMonitor).build(allLoader);
            this.initCache = CachingStoreWrapper.newCacheBuilder(caching, cacheMonitor).build(initLoader);
            if (cacheMonitor != null) {
                cacheMonitor.setSource(new CacheStatsSource());
            }
        }
    }

    private static CacheBuilder<Object, Object> newCacheBuilder(FeatureStoreCacheConfig caching, CacheMonitor cacheMonitor) {
        CacheBuilder<Object, Object> builder = CacheBuilder.newBuilder();
        if (!caching.isInfiniteTtl()) {
            builder = caching.getStaleValuesPolicy() == FeatureStoreCacheConfig.StaleValuesPolicy.EVICT ? builder.expireAfterWrite(caching.getCacheTime(), caching.getCacheTimeUnit()) : builder.refreshAfterWrite(caching.getCacheTime(), caching.getCacheTimeUnit());
        }
        if (cacheMonitor != null) {
            builder = builder.recordStats();
        }
        return builder;
    }

    @Override
    public void close() throws IOException {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
        this.core.close();
    }

    @Override
    public <T extends VersionedData> T get(VersionedDataKind<T> kind, String key) {
        Optional<VersionedData> cachedItem;
        if (this.itemCache != null && (cachedItem = this.itemCache.getUnchecked(CacheKey.forItem(kind, key))) != null) {
            return (T)this.itemOnlyIfNotDeleted(cachedItem.orNull());
        }
        return (T)this.itemOnlyIfNotDeleted(this.core.getInternal(kind, key));
    }

    @Override
    public <T extends VersionedData> Map<String, T> all(VersionedDataKind<T> kind) {
        Map items;
        if (this.allCache != null && (items = (Map)this.allCache.getUnchecked(kind)) != null) {
            return items;
        }
        return this.itemsOnlyIfNotDeleted(this.core.getAllInternal(kind));
    }

    @Override
    public void init(Map<VersionedDataKind<?>, Map<String, ? extends VersionedData>> allData) {
        Map<VersionedDataKind<?>, Map<String, VersionedData>> castMap = allData;
        try {
            this.core.initInternal(castMap);
        }
        catch (RuntimeException e) {
            if (this.allCache != null && this.itemCache != null && this.caching.isInfiniteTtl()) {
                this.updateAllCache(castMap);
                this.inited.set(true);
            }
            throw e;
        }
        if (this.allCache != null && this.itemCache != null) {
            this.allCache.invalidateAll();
            this.itemCache.invalidateAll();
            this.updateAllCache(castMap);
        }
        this.inited.set(true);
    }

    private void updateAllCache(Map<VersionedDataKind<?>, Map<String, VersionedData>> allData) {
        for (Map.Entry<VersionedDataKind<?>, Map<String, VersionedData>> e0 : allData.entrySet()) {
            VersionedDataKind<?> kind = e0.getKey();
            this.allCache.put(kind, this.itemsOnlyIfNotDeleted(e0.getValue()));
            for (Map.Entry<String, VersionedData> e1 : e0.getValue().entrySet()) {
                this.itemCache.put(CacheKey.forItem(kind, e1.getKey()), Optional.of(e1.getValue()));
            }
        }
    }

    @Override
    public <T extends VersionedData> void delete(VersionedDataKind<T> kind, String key, int version) {
        this.upsert(kind, kind.makeDeletedItem(key, version));
    }

    @Override
    public <T extends VersionedData> void upsert(VersionedDataKind<T> kind, T item) {
        Object newState = item;
        RuntimeException failure = null;
        try {
            newState = this.core.upsertInternal(kind, item);
        }
        catch (RuntimeException e) {
            failure = e;
        }
        if (failure == null || this.caching.isInfiniteTtl()) {
            if (this.itemCache != null) {
                this.itemCache.put(CacheKey.forItem(kind, item.getKey()), Optional.fromNullable(newState));
            }
            if (this.allCache != null) {
                if (this.caching.isInfiniteTtl()) {
                    try {
                        ImmutableMap<String, VersionedData> cachedAll = this.allCache.get(kind);
                        HashMap<String, VersionedData> newValues = new HashMap<String, VersionedData>();
                        newValues.putAll(cachedAll);
                        newValues.put(item.getKey(), (VersionedData)newState);
                        this.allCache.put(kind, ImmutableMap.copyOf(newValues));
                    }
                    catch (Exception exception) {}
                } else {
                    this.allCache.invalidate(kind);
                }
            }
        }
        if (failure != null) {
            throw failure;
        }
    }

    @Override
    public boolean initialized() {
        if (this.inited.get()) {
            return true;
        }
        boolean result = this.initCache != null ? this.initCache.getUnchecked("arbitrary-key").booleanValue() : this.core.initializedInternal();
        if (result) {
            this.inited.set(true);
        }
        return result;
    }

    public CacheStats getCacheStats() {
        if (this.itemCache != null) {
            return this.itemCache.stats();
        }
        return null;
    }

    public FeatureStoreCore getCore() {
        return this.core;
    }

    private VersionedData itemOnlyIfNotDeleted(VersionedData item) {
        return item != null && item.isDeleted() ? null : item;
    }

    private <T extends VersionedData> ImmutableMap<String, T> itemsOnlyIfNotDeleted(Map<String, ? extends VersionedData> items) {
        ImmutableMap.Builder<String, VersionedData> builder = ImmutableMap.builder();
        if (items != null) {
            for (Map.Entry<String, ? extends VersionedData> item : items.entrySet()) {
                if (item.getValue().isDeleted()) continue;
                builder.put(item.getKey(), item.getValue());
            }
        }
        return builder.build();
    }

    public static class Builder {
        private final FeatureStoreCore core;
        private FeatureStoreCacheConfig caching = FeatureStoreCacheConfig.DEFAULT;
        private CacheMonitor cacheMonitor = null;

        Builder(FeatureStoreCore core) {
            this.core = core;
        }

        public Builder caching(FeatureStoreCacheConfig caching) {
            this.caching = caching;
            return this;
        }

        public Builder cacheMonitor(CacheMonitor cacheMonitor) {
            this.cacheMonitor = cacheMonitor;
            return this;
        }

        public CachingStoreWrapper build() {
            return new CachingStoreWrapper(this.core, this.caching, this.cacheMonitor);
        }
    }

    private static class CacheKey {
        final VersionedDataKind<?> kind;
        final String key;

        public static CacheKey forItem(VersionedDataKind<?> kind, String key) {
            return new CacheKey(kind, key);
        }

        private CacheKey(VersionedDataKind<?> kind, String key) {
            this.kind = kind;
            this.key = key;
        }

        public boolean equals(Object other) {
            if (other instanceof CacheKey) {
                CacheKey o = (CacheKey)other;
                return o.kind.getNamespace().equals(this.kind.getNamespace()) && o.key.equals(this.key);
            }
            return false;
        }

        public int hashCode() {
            return this.kind.getNamespace().hashCode() * 31 + this.key.hashCode();
        }
    }

    private final class CacheStatsSource
    implements Callable<CacheMonitor.CacheStats> {
        private CacheStatsSource() {
        }

        @Override
        public CacheMonitor.CacheStats call() {
            if (CachingStoreWrapper.this.itemCache == null || CachingStoreWrapper.this.allCache == null) {
                return null;
            }
            CacheStats itemStats = CachingStoreWrapper.this.itemCache.stats();
            CacheStats allStats = CachingStoreWrapper.this.allCache.stats();
            return new CacheMonitor.CacheStats(itemStats.hitCount() + allStats.hitCount(), itemStats.missCount() + allStats.missCount(), itemStats.loadSuccessCount() + allStats.loadSuccessCount(), itemStats.loadExceptionCount() + allStats.loadExceptionCount(), itemStats.totalLoadTime() + allStats.totalLoadTime(), itemStats.evictionCount() + allStats.evictionCount());
        }
    }
}

